/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.FrozenRealmReference;
import io.realm.kotlin.internal.RealmLog;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmT;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u00020\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015RB\u0010\u0005\u001a6\u00122\u00120\u0012,\u0012*\u0012\u0010\u0012\u000e\u0012\u0006\b\u0001\u0012\u00020\n0\tj\u0002`\u000b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000e0\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lio/realm/kotlin/internal/VersionTracker;", "", "log", "Lio/realm/kotlin/internal/RealmLog;", "(Lio/realm/kotlin/internal/RealmLog;)V", "intermediateReferences", "Lkotlinx/atomicfu/AtomicRef;", "", "Lkotlin/Pair;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmT;", "Lio/realm/kotlin/internal/interop/RealmPointer;", "Ljava/lang/ref/WeakReference;", "Lio/realm/kotlin/internal/RealmReference;", "Lio/realm/kotlin/internal/platform/WeakReference;", "getLog", "()Lio/realm/kotlin/internal/RealmLog;", "close", "", "trackAndCloseExpiredReferences", "realmReference", "Lio/realm/kotlin/internal/FrozenRealmReference;", "io.realm.kotlin.library"})
public final class VersionTracker {
    @NotNull
    private final RealmLog log;
    @NotNull
    private final AtomicRef<Set<Pair<NativePointer<? extends RealmT>, WeakReference<RealmReference>>>> intermediateReferences;

    public VersionTracker(@NotNull RealmLog log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        this.intermediateReferences = AtomicFU.atomic((Object)new LinkedHashSet());
    }

    @NotNull
    public final RealmLog getLog() {
        return this.log;
    }

    public final void trackAndCloseExpiredReferences(@Nullable FrozenRealmReference realmReference2) {
        Set references = new LinkedHashSet();
        FrozenRealmReference frozenRealmReference = realmReference2;
        if (frozenRealmReference != null) {
            FrozenRealmReference it = frozenRealmReference;
            boolean bl = false;
            references.add(new Pair(realmReference2.getDbPointer(), new WeakReference<FrozenRealmReference>(it)));
        }
        Iterable $this$forEach$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair entry = (Pair)element$iv;
            boolean bl = false;
            NativePointer pointer = (NativePointer)entry.component1();
            WeakReference ref = (WeakReference)entry.component2();
            if (ref.get() == null) {
                this.log.debug("Closing unreferenced version: " + RealmInterop.INSTANCE.realm_get_version_id(pointer), new Object[0]);
                RealmInterop.INSTANCE.realm_close(pointer);
                continue;
            }
            references.add(entry);
        }
        this.intermediateReferences.setValue((Object)references);
    }

    public static /* synthetic */ void trackAndCloseExpiredReferences$default(VersionTracker versionTracker, FrozenRealmReference frozenRealmReference, int n, Object object) {
        if ((n & 1) != 0) {
            frozenRealmReference = null;
        }
        versionTracker.trackAndCloseExpiredReferences(frozenRealmReference);
    }

    public final void close() {
        Iterable $this$forEach$iv = (Iterable)this.intermediateReferences.getValue();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            NativePointer pointer = (NativePointer)pair.component1();
            this.log.debug("Closing intermediate version: " + RealmInterop.INSTANCE.realm_get_version_id(pointer), new Object[0]);
            RealmInterop.INSTANCE.realm_close(pointer);
        }
    }
}

