/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin;

import io.realm.kotlin.Configuration;
import io.realm.kotlin.LogConfiguration;
import io.realm.kotlin.internal.RealmConfigurationImpl;
import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.util.CoroutineDispatcherFactory;
import io.realm.kotlin.migration.RealmMigration;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\bf\u0018\u0000 \u00072\u00020\u0001:\u0002\u0006\u0007R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lio/realm/kotlin/RealmConfiguration;", "Lio/realm/kotlin/Configuration;", "deleteRealmIfMigrationNeeded", "", "getDeleteRealmIfMigrationNeeded", "()Z", "Builder", "Companion", "io.realm.kotlin.library"})
public interface RealmConfiguration
extends Configuration {
    @NotNull
    public static final Companion Companion = io.realm.kotlin.RealmConfiguration$Companion.$$INSTANCE;

    public boolean getDeleteRealmIfMigrationNeeded();

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\u0012\u0014\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000bX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lio/realm/kotlin/RealmConfiguration$Builder;", "Lio/realm/kotlin/Configuration$SharedBuilder;", "Lio/realm/kotlin/RealmConfiguration;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "(Ljava/util/Set;)V", "deleteRealmIfMigrationNeeded", "", "directory", "", "migration", "Lio/realm/kotlin/migration/RealmMigration;", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "build", "directoryPath", "io.realm.kotlin.library"})
    public static final class Builder
    extends Configuration.SharedBuilder<RealmConfiguration, Builder> {
        @Nullable
        private String name;
        @NotNull
        private String directory;
        private boolean deleteRealmIfMigrationNeeded;
        @Nullable
        private RealmMigration migration;

        public Builder(@NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            super(schema);
            this.name = "default.realm";
            this.directory = SystemUtilsJvmKt.appFilesDirectory();
        }

        @Override
        @Nullable
        protected String getName() {
            return this.name;
        }

        @Override
        protected void setName(@Nullable String string) {
            this.name = string;
        }

        @NotNull
        public final Builder directory(@NotNull String directoryPath) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
            Builder $this$directory_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$directory_u24lambda_u240.directory = directoryPath;
            return builder;
        }

        @NotNull
        public final Builder deleteRealmIfMigrationNeeded() {
            Builder builder;
            Builder $this$deleteRealmIfMigrationNeeded_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$deleteRealmIfMigrationNeeded_u24lambda_u241.deleteRealmIfMigrationNeeded = true;
            return builder;
        }

        @NotNull
        public final Builder migration(@NotNull RealmMigration migration) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)migration, (String)"migration");
            Builder $this$migration_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$migration_u24lambda_u242.migration = migration;
            return builder;
        }

        @Override
        @NotNull
        public Builder name(@NotNull String name) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$name_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$name_u24lambda_u243.checkName(name);
            $this$name_u24lambda_u243.setName(name);
            return builder;
        }

        @Override
        @NotNull
        public RealmConfiguration build() {
            CoroutineDispatcherFactory coroutineDispatcherFactory;
            CoroutineDispatcherFactory notificationDispatcherFactory;
            CoroutineDispatcherFactory coroutineDispatcherFactory2;
            List allLoggers = new ArrayList();
            if (!this.getRemoveSystemLogger()) {
                allLoggers.add(SystemUtilsJvmKt.createDefaultSystemLogger$default("REALM", null, 2, null));
            }
            allLoggers.addAll((Collection)this.getUserLoggers());
            String string = this.getName();
            Intrinsics.checkNotNull((Object)string);
            String fileName = string;
            if (this.getNotificationDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getNotificationDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory2 = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory2 = notificationDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default(CoroutineDispatcherFactory.Companion, fileName, 0, 2, null);
            }
            if (this.getWriteDispatcher() != null) {
                CoroutineDispatcher coroutineDispatcher = this.getWriteDispatcher();
                Intrinsics.checkNotNull((Object)coroutineDispatcher);
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.unmanaged(coroutineDispatcher);
            } else {
                coroutineDispatcherFactory = CoroutineDispatcherFactory.Companion.managed$default(CoroutineDispatcherFactory.Companion, fileName, 0, 2, null);
            }
            CoroutineDispatcherFactory writerDispatcherFactory = coroutineDispatcherFactory;
            return new RealmConfigurationImpl(this.directory, fileName, this.getSchema(), new LogConfiguration(this.getLogLevel(), allLoggers), this.getMaxNumberOfActiveVersions(), notificationDispatcherFactory, writerDispatcherFactory, this.getSchemaVersion(), this.getEncryptionKey(), this.deleteRealmIfMigrationNeeded, this.getCompactOnLaunchCallback(), this.migration, this.getInitialDataCallback(), this.getInMemory());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/RealmConfiguration$Companion;", "", "()V", "create", "Lio/realm/kotlin/RealmConfiguration;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/kotlin/types/BaseRealmObject;", "io.realm.kotlin.library"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final RealmConfiguration create(@NotNull Set<? extends KClass<? extends BaseRealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            return new Builder(schema).build();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

