/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.CoreExceptionConverter;
import io.realm.kotlin.internal.Flowable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.Observable;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.SetChangeSetBuilderImpl;
import io.realm.kotlin.internal.SetOperator;
import io.realm.kotlin.internal.UnmanagedRealmSet;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.internal.interop.RealmSetT;
import io.realm.kotlin.notifications.SetChange;
import io.realm.kotlin.notifications.internal.DeletedSetImpl;
import io.realm.kotlin.notifications.internal.InitialSetImpl;
import io.realm.kotlin.notifications.internal.UpdatedSetImpl;
import io.realm.kotlin.types.RealmSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0007B%\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010 \u001a\u00020\u001eH\u0016JL\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\"2\u0006\u0010#\u001a\u00020$2\u0010\u0010%\u001a\f\u0012\u0004\u0012\u00020&0\tj\u0002`'2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060)H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b*J\u0018\u0010+\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010#\u001a\u00020$H\u0016J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0096\u0002J*\u0010.\u001a\f\u0012\u0004\u0012\u00020/0\tj\u0002`02\u0016\u00101\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020&0\tj\u0002`'02H\u0016J\u0018\u00103\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00104\u001a\u00020$H\u0016R\u001e\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00065"}, d2={"Lio/realm/kotlin/internal/ManagedRealmSet;", "E", "Lkotlin/collections/AbstractMutableSet;", "Lio/realm/kotlin/types/RealmSet;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/Observable;", "Lio/realm/kotlin/notifications/SetChange;", "Lio/realm/kotlin/internal/Flowable;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmSetT;", "Lio/realm/kotlin/internal/interop/RealmSetPointer;", "operator", "Lio/realm/kotlin/internal/SetOperator;", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/SetOperator;)V", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOperator", "()Lio/realm/kotlin/internal/SetOperator;", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "clear", "", "contains", "delete", "emitFrozenUpdate", "Lkotlinx/coroutines/channels/ChannelResult;", "frozenRealm", "Lio/realm/kotlin/internal/RealmReference;", "change", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "emitFrozenUpdate-t11v4CI", "freeze", "iterator", "", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "thaw", "liveRealm", "io.realm.kotlin.library"})
public final class ManagedRealmSet<E>
extends AbstractMutableSet<E>
implements RealmSet<E>,
InternalDeleteable,
Observable<ManagedRealmSet<E>, SetChange<E>>,
Flowable<SetChange<E>> {
    @NotNull
    private final NativePointer<RealmSetT> nativePointer;
    @NotNull
    private final SetOperator<E> operator;

    public ManagedRealmSet(@NotNull NativePointer<RealmSetT> nativePointer, @NotNull SetOperator<E> operator) {
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.nativePointer = nativePointer;
        this.operator = operator;
    }

    @NotNull
    public final NativePointer<RealmSetT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @NotNull
    public final SetOperator<E> getOperator() {
        return this.operator;
    }

    public int getSize() {
        this.operator.getRealmReference().checkClosed();
        return (int)RealmInterop.INSTANCE.realm_set_size(this.nativePointer);
    }

    @Override
    public boolean add(E element) {
        this.operator.getRealmReference().checkClosed();
        try {
            return SetOperator.DefaultImpls.add$default(this.operator, element, null, null, 6, null);
        }
        catch (Throwable exception) {
            throw CoreExceptionConverter.convertToPublicException$default(CoreExceptionConverter.INSTANCE, exception, "Could not add element to set", null, 4, null);
        }
    }

    @Override
    public void clear() {
        this.operator.getRealmReference().checkClosed();
        RealmInterop.INSTANCE.realm_set_clear(this.nativePointer);
    }

    @Override
    public boolean contains(Object element) {
        this.operator.getRealmReference().checkClosed();
        return this.operator.contains(element);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        this.operator.getRealmReference().checkClosed();
        return new Iterator<E>(this){
            private int pos;
            final /* synthetic */ ManagedRealmSet<E> this$0;
            {
                this.this$0 = $receiver;
                this.pos = -1;
            }

            public boolean hasNext() {
                return this.pos + 1 < this.this$0.size();
            }

            public E next() {
                ++this.pos;
                if (this.pos >= this.this$0.size()) {
                    throw new NoSuchElementException("Cannot access index " + this.pos + " when size is " + this.this$0.size() + ". Remember to check hasNext() before using next().");
                }
                return this.this$0.getOperator().get(this.pos);
            }

            public void remove() {
                if (this.pos < 0) {
                    throw new NoSuchElementException("Could not remove last element returned by the iterator: iterator never returned an element.");
                }
                if (this.this$0.isEmpty()) {
                    throw new NoSuchElementException("Could not remove last element returned by the iterator: set is empty.");
                }
                Object element = RealmInterop.INSTANCE.realm_set_get-399rIkc(this.this$0.getNativePointer$io_realm_kotlin_library(), (long)this.pos);
                boolean erased = RealmInterop.INSTANCE.realm_set_erase-7Gcd38g(this.this$0.getNativePointer$io_realm_kotlin_library(), element);
                if (!erased) {
                    throw new NoSuchElementException("Could not remove last element returned by the iterator: was there an element to remove?");
                }
            }
        };
    }

    @Override
    @NotNull
    public Flow<SetChange<E>> asFlow() {
        this.operator.getRealmReference().checkClosed();
        return this.operator.getRealmReference().getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    @Nullable
    public ManagedRealmSet<E> freeze(@NotNull RealmReference frozenRealm) {
        ManagedRealmSet<E> managedRealmSet;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_set_resolve_in(this.nativePointer, frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmSet = new ManagedRealmSet<E>((NativePointer<RealmSetT>)it, this.operator.copy(frozenRealm, (NativePointer<RealmSetT>)it));
        } else {
            managedRealmSet = null;
        }
        return managedRealmSet;
    }

    @Override
    @Nullable
    public ManagedRealmSet<E> thaw(@NotNull RealmReference liveRealm) {
        ManagedRealmSet<E> managedRealmSet;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_set_resolve_in(this.nativePointer, liveRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmSet = new ManagedRealmSet<E>((NativePointer<RealmSetT>)it, this.operator.copy(liveRealm, (NativePointer<RealmSetT>)it));
        } else {
            managedRealmSet = null;
        }
        return managedRealmSet;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_set_add_notification_callback(this.nativePointer, callback);
    }

    @Override
    @Nullable
    public ChannelResult<Unit> emitFrozenUpdate-t11v4CI(@NotNull RealmReference frozenRealm, @NotNull NativePointer<RealmChangesT> change, @NotNull SendChannel<? super SetChange<E>> channel) {
        ChannelResult channelResult;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        Intrinsics.checkNotNullParameter(change, (String)"change");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Object frozenSet = this.freeze(frozenRealm);
        if (frozenSet != null) {
            SetChangeSetBuilderImpl builder = new SetChangeSetBuilderImpl(change);
            channelResult = ChannelResult.box-impl((Object)(builder.isEmpty() ? channel.trySend-JP2dKIU(new InitialSetImpl((RealmSet)frozenSet)) : channel.trySend-JP2dKIU(new UpdatedSetImpl((RealmSet)frozenSet, builder.build()))));
        } else {
            ChannelResult channelResult2 = ChannelResult.box-impl((Object)channel.trySend-JP2dKIU(new DeletedSetImpl(new UnmanagedRealmSet())));
            Object it = channelResult2.unbox-impl();
            boolean bl = false;
            SendChannel.DefaultImpls.close$default(channel, null, (int)1, null);
            channelResult = channelResult2;
        }
        return channelResult;
    }

    @Override
    public void delete() {
        RealmInterop.INSTANCE.realm_set_remove_all(this.nativePointer);
    }
}

