/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.internal.CoreExceptionConverter;
import io.realm.kotlin.internal.Flowable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.ListChangeSetBuilderImpl;
import io.realm.kotlin.internal.ListOperator;
import io.realm.kotlin.internal.Observable;
import io.realm.kotlin.internal.RealmListInternalKt;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.UnmanagedRealmList;
import io.realm.kotlin.internal.interop.Callback;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmChangesT;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmListT;
import io.realm.kotlin.internal.interop.RealmNotificationTokenT;
import io.realm.kotlin.notifications.ListChange;
import io.realm.kotlin.notifications.internal.DeletedListImpl;
import io.realm.kotlin.notifications.internal.InitialListImpl;
import io.realm.kotlin.notifications.internal.UpdatedListImpl;
import io.realm.kotlin.types.RealmList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0007B%\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u0014\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060!H\u0016J\b\u0010\"\u001a\u00020\u0018H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016JL\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0010\u0010(\u001a\f\u0012\u0004\u0012\u00020)0\tj\u0002`*2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060,H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b-J\u0018\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010/\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0014H\u0096\u0002\u00a2\u0006\u0002\u00100J\r\u00101\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b2J*\u00103\u001a\f\u0012\u0004\u0012\u0002040\tj\u0002`52\u0016\u00106\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020)0\tj\u0002`*07H\u0016J\u0015\u00108\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u00100J\u001e\u00109\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010<\u001a\u00020'H\u0016R\u001e\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lio/realm/kotlin/internal/ManagedRealmList;", "E", "Lkotlin/collections/AbstractMutableList;", "Lio/realm/kotlin/types/RealmList;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/Observable;", "Lio/realm/kotlin/notifications/ListChange;", "Lio/realm/kotlin/internal/Flowable;", "nativePointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmListT;", "Lio/realm/kotlin/internal/interop/RealmListPointer;", "operator", "Lio/realm/kotlin/internal/ListOperator;", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/ListOperator;)V", "getNativePointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "getOperator", "()Lio/realm/kotlin/internal/ListOperator;", "size", "", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "addAll", "", "elements", "", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "clear", "delete", "emitFrozenUpdate", "Lkotlinx/coroutines/channels/ChannelResult;", "frozenRealm", "Lio/realm/kotlin/internal/RealmReference;", "change", "Lio/realm/kotlin/internal/interop/RealmChangesT;", "Lio/realm/kotlin/internal/interop/RealmChangesPointer;", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "emitFrozenUpdate-t11v4CI", "freeze", "get", "(I)Ljava/lang/Object;", "isValid", "isValid$io_realm_kotlin_library", "registerForNotification", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenT;", "Lio/realm/kotlin/internal/interop/RealmNotificationTokenPointer;", "callback", "Lio/realm/kotlin/internal/interop/Callback;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "thaw", "liveRealm", "io.realm.kotlin.library"})
public final class ManagedRealmList<E>
extends AbstractMutableList<E>
implements RealmList<E>,
InternalDeleteable,
Observable<ManagedRealmList<E>, ListChange<E>>,
Flowable<ListChange<E>> {
    @NotNull
    private final NativePointer<RealmListT> nativePointer;
    @NotNull
    private final ListOperator<E> operator;

    public ManagedRealmList(@NotNull NativePointer<RealmListT> nativePointer, @NotNull ListOperator<E> operator) {
        Intrinsics.checkNotNullParameter(nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.nativePointer = nativePointer;
        this.operator = operator;
    }

    @NotNull
    public final NativePointer<RealmListT> getNativePointer$io_realm_kotlin_library() {
        return this.nativePointer;
    }

    @NotNull
    public final ListOperator<E> getOperator() {
        return this.operator;
    }

    public int getSize() {
        this.operator.getRealmReference().checkClosed();
        return (int)RealmInterop.INSTANCE.realm_list_size(this.nativePointer);
    }

    @Override
    public E get(int index) {
        this.operator.getRealmReference().checkClosed();
        try {
            return this.operator.get(index);
        }
        catch (Throwable exception) {
            throw CoreExceptionConverter.convertToPublicException$default(CoreExceptionConverter.INSTANCE, exception, "Could not get element at list index " + index, null, 4, null);
        }
    }

    @Override
    public void add(int index, E element) {
        try {
            ListOperator.DefaultImpls.insert$default(this.operator, index, element, null, null, 12, null);
        }
        catch (Throwable exception) {
            throw CoreExceptionConverter.convertToPublicException$default(CoreExceptionConverter.INSTANCE, exception, "Could not add element at list index " + index, null, 4, null);
        }
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return ListOperator.DefaultImpls.insertAll$default(this.operator, this.size(), elements, null, null, 12, null);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        RealmListInternalKt.access$checkPositionIndex(index, this.size());
        return ListOperator.DefaultImpls.insertAll$default(this.operator, index, elements, null, null, 12, null);
    }

    @Override
    public void clear() {
        this.operator.getRealmReference().checkClosed();
        RealmInterop.INSTANCE.realm_list_clear(this.nativePointer);
    }

    public E removeAt(int index) {
        E e;
        E it = e = this.get(index);
        boolean bl = false;
        this.operator.getRealmReference().checkClosed();
        try {
            RealmInterop.INSTANCE.realm_list_erase(this.nativePointer, (long)index);
        }
        catch (Throwable exception) {
            throw CoreExceptionConverter.convertToPublicException$default(CoreExceptionConverter.INSTANCE, exception, "Could not remove element at list index " + index, null, 4, null);
        }
        return e;
    }

    @Override
    public E set(int index, E element) {
        this.operator.getRealmReference().checkClosed();
        try {
            return (E)ListOperator.DefaultImpls.set$default(this.operator, index, element, null, null, 12, null);
        }
        catch (Throwable exception) {
            throw CoreExceptionConverter.convertToPublicException$default(CoreExceptionConverter.INSTANCE, exception, "Could not set list element at list index " + index, null, 4, null);
        }
    }

    @Override
    @NotNull
    public Flow<ListChange<E>> asFlow() {
        this.operator.getRealmReference().checkClosed();
        return this.operator.getRealmReference().getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    @Nullable
    public ManagedRealmList<E> freeze(@NotNull RealmReference frozenRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, frozenRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>((NativePointer<RealmListT>)it, this.operator.copy(frozenRealm, (NativePointer<RealmListT>)it));
        } else {
            managedRealmList = null;
        }
        return managedRealmList;
    }

    @Override
    @Nullable
    public ManagedRealmList<E> thaw(@NotNull RealmReference liveRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, liveRealm.getDbPointer());
        if (nativePointer != null) {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>((NativePointer<RealmListT>)it, this.operator.copy(liveRealm, (NativePointer<RealmListT>)it));
        } else {
            managedRealmList = null;
        }
        return managedRealmList;
    }

    @Override
    @NotNull
    public NativePointer<RealmNotificationTokenT> registerForNotification(@NotNull Callback<NativePointer<RealmChangesT>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_list_add_notification_callback(this.nativePointer, callback);
    }

    @Override
    @Nullable
    public ChannelResult<Unit> emitFrozenUpdate-t11v4CI(@NotNull RealmReference frozenRealm, @NotNull NativePointer<RealmChangesT> change, @NotNull SendChannel<? super ListChange<E>> channel) {
        ChannelResult channelResult;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        Intrinsics.checkNotNullParameter(change, (String)"change");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Object frozenList = this.freeze(frozenRealm);
        if (frozenList != null) {
            ListChangeSetBuilderImpl builder = new ListChangeSetBuilderImpl(change);
            channelResult = ChannelResult.box-impl((Object)(builder.isEmpty() ? channel.trySend-JP2dKIU(new InitialListImpl((RealmList)frozenList)) : channel.trySend-JP2dKIU(new UpdatedListImpl((RealmList)frozenList, builder.build()))));
        } else {
            ChannelResult channelResult2 = ChannelResult.box-impl((Object)channel.trySend-JP2dKIU(new DeletedListImpl(new UnmanagedRealmList())));
            Object it = channelResult2.unbox-impl();
            boolean bl = false;
            SendChannel.DefaultImpls.close$default(channel, null, (int)1, null);
            channelResult = channelResult2;
        }
        return channelResult;
    }

    public final boolean isValid$io_realm_kotlin_library() {
        return RealmInterop.INSTANCE.realm_list_is_valid(this.nativePointer);
    }

    @Override
    public void delete() {
        RealmInterop.INSTANCE.realm_list_remove_all(this.nativePointer);
    }
}

