/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import io.realm.kotlin.internal.platform.SystemUtilsJvmKt;
import io.realm.kotlin.internal.util.Exceptions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u000e\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u001a\u0006\u0010\u001b\u001a\u00020\u0007\u001a\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0016\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010 \u001a\u00020\u0001\u001a&\u0010!\u001a\u00020\"\"\u0004\b\u0000\u0010#\"\u0004\b\u0001\u0010$2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u0002H#\u0012\u0004\u0012\u0002H$0&\u001a\u000e\u0010'\u001a\u00020(\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)\"\u0017\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006*"}, d2={"PATH_SEPARATOR", "", "getPATH_SEPARATOR$annotations", "()V", "getPATH_SEPARATOR", "()Ljava/lang/String;", "canWrite", "", "path", "copyAssetFile", "", "realmFilePath", "assetFilename", "sha256Checksum", "copyStream", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "directoryExists", "epochInSeconds", "", "fileExists", "identityHashCode", "", "obj", "", "isWindows", "preparePath", "directoryPath", "prepareRealmDirectoryPath", "prepareRealmFilePath", "filename", "returnType", "Lkotlin/reflect/KType;", "K", "V", "field", "Lkotlin/reflect/KMutableProperty1;", "threadId", "Lkotlin/ULong;", "()J", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nSystemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemUtils.kt\nio/realm/kotlin/internal/platform/SystemUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,117:1\n1#2:118\n12734#3,3:119\n*S KotlinDebug\n*F\n+ 1 SystemUtils.kt\nio/realm/kotlin/internal/platform/SystemUtilsKt\n*L\n80#1:119,3\n*E\n"})
public final class SystemUtilsKt {
    @NotNull
    private static final String PATH_SEPARATOR;

    @NotNull
    public static final String getPATH_SEPARATOR() {
        return PATH_SEPARATOR;
    }

    public static /* synthetic */ void getPATH_SEPARATOR$annotations() {
    }

    public static final long threadId() {
        return ULong.constructor-impl((long)Thread.currentThread().getId());
    }

    public static final long epochInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    public static final boolean fileExists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File it = new File(path);
        boolean bl = false;
        return it.exists() && it.isFile();
    }

    public static final boolean directoryExists(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File it = new File(path);
        boolean bl = false;
        return it.exists() && it.isDirectory();
    }

    public static final boolean canWrite(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new File(path).canWrite();
    }

    @NotNull
    public static final String prepareRealmDirectoryPath(@NotNull String directoryPath) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        SystemUtilsKt.preparePath(directoryPath);
        String string = new File(directoryPath).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    @NotNull
    public static final String prepareRealmFilePath(@NotNull String directoryPath, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)directoryPath, (String)"directoryPath");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        SystemUtilsKt.preparePath(directoryPath);
        String string = new File(directoryPath, filename).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    private static final void copyStream(InputStream inputStream, OutputStream outputStream) {
        byte[] buf = new byte[4096];
        int bytesRead = 0;
        while (true) {
            int n;
            int it = n = inputStream.read(buf);
            boolean bl = false;
            bytesRead = it;
            if (n <= -1) break;
            outputStream.write(buf, 0, bytesRead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void copyAssetFile(@NotNull String realmFilePath, @NotNull String assetFilename, @Nullable String sha256Checksum) {
        Intrinsics.checkNotNullParameter((Object)realmFilePath, (String)"realmFilePath");
        Intrinsics.checkNotNullParameter((Object)assetFilename, (String)"assetFilename");
        InputStream inputStream = SystemUtilsJvmKt.assetFileAsStream(assetFilename);
        boolean bl = false;
        Closeable closeable = sha256Checksum != null ? (InputStream)new DigestInputStream(inputStream, MessageDigest.getInstance("SHA-256")) : inputStream;
        Throwable throwable = null;
        try {
            InputStream assetStream = (InputStream)closeable;
            boolean bl2 = false;
            File outputFile = new File(realmFilePath);
            try {
                Closeable closeable2 = new FileOutputStream(outputFile);
                Object object = null;
                try {
                    FileOutputStream outputStream = (FileOutputStream)closeable2;
                    boolean bl3 = false;
                    SystemUtilsKt.copyStream(assetStream, outputStream);
                    outputStream = Unit.INSTANCE;
                }
                catch (Throwable outputStream) {
                    object = outputStream;
                    throw outputStream;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                }
                if (sha256Checksum != null && assetStream instanceof DigestInputStream) {
                    void $this$fold$iv;
                    byte[] byArray = ((DigestInputStream)assetStream).getMessageDigest().digest();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                    object = byArray;
                    String initial$iv = "";
                    boolean $i$f$fold = false;
                    String accumulator$iv = initial$iv;
                    int n = ((void)$this$fold$iv).length;
                    for (int i = 0; i < n; ++i) {
                        void element;
                        void element$iv;
                        void var16_22 = element$iv = $this$fold$iv[i];
                        String str = accumulator$iv;
                        boolean bl4 = false;
                        StringBuilder stringBuilder = new StringBuilder().append(str);
                        String string = "%02x";
                        Object[] objectArray = new Object[]{(byte)element};
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                        accumulator$iv = stringBuilder.append(string2).toString();
                    }
                    String actual = accumulator$iv;
                    if (!Intrinsics.areEqual((Object)actual, (Object)sha256Checksum)) {
                        throw Exceptions.INSTANCE.assetFileChecksumMismatch(assetFilename, sha256Checksum, actual);
                    }
                }
            }
            catch (Exception e) {
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final <K, V> KType returnType(@NotNull KMutableProperty1<K, V> field) {
        Intrinsics.checkNotNullParameter(field, (String)"field");
        return field.getReturnType();
    }

    private static final void preparePath(String directoryPath) {
        File dir = new File(directoryPath).getAbsoluteFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("Directories for Realm file could not be created: " + directoryPath);
        }
        if (dir.isFile()) {
            throw new IllegalArgumentException("Provided directory is a file: " + directoryPath);
        }
    }

    public static final boolean isWindows() {
        return StringsKt.contains((CharSequence)SystemUtilsJvmKt.getOS_NAME(), (CharSequence)"windows", (boolean)true);
    }

    public static final int identityHashCode(@Nullable Object obj) {
        return System.identityHashCode(obj);
    }

    static {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        PATH_SEPARATOR = string;
    }
}

