/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import io.realm.kotlin.Realm;
import io.realm.kotlin.internal.RealmInstantImpl;
import io.realm.kotlin.internal.interop.SyncConnectionParams;
import io.realm.kotlin.internal.platform.StdOutLogger;
import io.realm.kotlin.internal.util.Exceptions;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import io.realm.kotlin.types.RealmInstant;
import java.io.InputStream;
import java.net.URL;
import java.time.Clock;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0012\u001a\u00020\u0001\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u001a\u0006\u0010\u001b\u001a\u00020\u001c\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0003\"\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0011\u0010\u0010\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0003\u00a8\u0006\u001d"}, d2={"CPU_ARCH", "", "getCPU_ARCH", "()Ljava/lang/String;", "DEVICE_MANUFACTURER", "getDEVICE_MANUFACTURER", "DEVICE_MODEL", "getDEVICE_MODEL", "OS_NAME", "getOS_NAME", "OS_VERSION", "getOS_VERSION", "RUNTIME", "Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "getRUNTIME", "()Lio/realm/kotlin/internal/interop/SyncConnectionParams$Runtime;", "RUNTIME_VERSION", "getRUNTIME_VERSION", "appFilesDirectory", "assetFileAsStream", "Ljava/io/InputStream;", "assetFilename", "createDefaultSystemLogger", "Lio/realm/kotlin/log/RealmLogger;", "tag", "logLevel", "Lio/realm/kotlin/log/LogLevel;", "currentTime", "Lio/realm/kotlin/types/RealmInstant;", "io.realm.kotlin.library"})
public final class SystemUtilsJvmKt {
    @NotNull
    private static final SyncConnectionParams.Runtime RUNTIME = SyncConnectionParams.Runtime.JVM;
    @NotNull
    private static final String RUNTIME_VERSION;
    @NotNull
    private static final String CPU_ARCH;
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;
    @NotNull
    private static final String DEVICE_MANUFACTURER;
    @NotNull
    private static final String DEVICE_MODEL;

    @NotNull
    public static final SyncConnectionParams.Runtime getRUNTIME() {
        return RUNTIME;
    }

    @NotNull
    public static final String getRUNTIME_VERSION() {
        return RUNTIME_VERSION;
    }

    @NotNull
    public static final String getCPU_ARCH() {
        return CPU_ARCH;
    }

    @NotNull
    public static final String getOS_NAME() {
        return OS_NAME;
    }

    @NotNull
    public static final String getOS_VERSION() {
        return OS_VERSION;
    }

    @NotNull
    public static final String getDEVICE_MANUFACTURER() {
        return DEVICE_MANUFACTURER;
    }

    @NotNull
    public static final String getDEVICE_MODEL() {
        return DEVICE_MODEL;
    }

    @NotNull
    public static final String appFilesDirectory() {
        String string = System.getProperty("user.dir");
        if (string == null) {
            string = ".";
        }
        return string;
    }

    @NotNull
    public static final InputStream assetFileAsStream(@NotNull String assetFilename) {
        Intrinsics.checkNotNullParameter((Object)assetFilename, (String)"assetFilename");
        ClassLoader classLoader = Realm.Companion.getClass().getClassLoader();
        URL uRL = classLoader.getResource(assetFilename);
        if (uRL == null) {
            throw Exceptions.assetFileNotFound$default(Exceptions.INSTANCE, assetFilename, null, 2, null);
        }
        URL resource = uRL;
        InputStream inputStream = resource.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
        return inputStream;
    }

    @NotNull
    public static final RealmLogger createDefaultSystemLogger(@NotNull String tag, @NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        return new StdOutLogger(tag, logLevel);
    }

    public static /* synthetic */ RealmLogger createDefaultSystemLogger$default(String string, LogLevel logLevel, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.NONE;
        }
        return SystemUtilsJvmKt.createDefaultSystemLogger(string, logLevel);
    }

    @NotNull
    public static final RealmInstant currentTime() {
        Instant jtInstant = Clock.systemUTC().instant();
        return new RealmInstantImpl(jtInstant.getEpochSecond(), jtInstant.getNano());
    }

    static {
        String string = System.getProperty("java.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        RUNTIME_VERSION = string;
        String string2 = System.getProperty("os.arch");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
        CPU_ARCH = string2;
        String string3 = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getProperty(...)");
        OS_NAME = string3;
        String string4 = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getProperty(...)");
        OS_VERSION = string4;
        DEVICE_MANUFACTURER = "";
        DEVICE_MODEL = "";
    }
}

