/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal;

import io.realm.kotlin.ext.BaseRealmObjectExtKt;
import io.realm.kotlin.internal.ObjectBoundRealmResults;
import io.realm.kotlin.internal.RealmObjectHelper;
import io.realm.kotlin.internal.RealmObjectReference;
import io.realm.kotlin.internal.RealmObjectUtilKt;
import io.realm.kotlin.internal.RealmResultsImpl;
import io.realm.kotlin.internal.schema.ClassMetadata;
import io.realm.kotlin.internal.schema.PropertyMetadata;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.types.BacklinksDelegate;
import io.realm.kotlin.types.BaseRealmObject;
import io.realm.kotlin.types.EmbeddedBacklinksDelegate;
import io.realm.kotlin.types.EmbeddedRealmObject;
import io.realm.kotlin.types.RealmObject;
import io.realm.kotlin.types.TypedRealmObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\"\u0010\r\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000e2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ#\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00020\u00102\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0096\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/internal/BacklinksDelegateImpl;", "T", "Lio/realm/kotlin/types/TypedRealmObject;", "Lio/realm/kotlin/types/EmbeddedBacklinksDelegate;", "Lio/realm/kotlin/types/BacklinksDelegate;", "sourceClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "createBacklinks", "Lio/realm/kotlin/query/RealmResults;", "reference", "targetProperty", "Lkotlin/reflect/KProperty;", "getValue", "Lio/realm/kotlin/types/EmbeddedRealmObject;", "(Lio/realm/kotlin/types/EmbeddedRealmObject;Lkotlin/reflect/KProperty;)Lio/realm/kotlin/types/TypedRealmObject;", "Lio/realm/kotlin/types/RealmObject;", "io.realm.kotlin.library"})
public final class BacklinksDelegateImpl<T extends TypedRealmObject>
implements EmbeddedBacklinksDelegate<T>,
BacklinksDelegate<T> {
    @NotNull
    private final KClass<T> sourceClass;

    public BacklinksDelegateImpl(@NotNull KClass<T> sourceClass) {
        Intrinsics.checkNotNullParameter(sourceClass, (String)"sourceClass");
        this.sourceClass = sourceClass;
    }

    private final RealmResults<T> createBacklinks(TypedRealmObject reference, KProperty<?> targetProperty) {
        if (!BaseRealmObjectExtKt.isManaged(reference)) {
            throw new IllegalStateException("Unmanaged objects don't support backlinks.");
        }
        RealmObjectReference<BaseRealmObject> realmObjectReference = RealmObjectUtilKt.getRealmObjectReference((BaseRealmObject)reference);
        Intrinsics.checkNotNull(realmObjectReference);
        RealmObjectReference<BaseRealmObject> objectReference = realmObjectReference;
        PropertyMetadata propertyMetadata = objectReference.getMetadata().get(targetProperty);
        if (propertyMetadata == null) {
            throw new IllegalArgumentException("Target property '" + targetProperty.getName() + "' not defined in '" + Reflection.getOrCreateKotlinClass(reference.getClass()).getSimpleName() + "'.");
        }
        PropertyMetadata targetPropertyMetadata = propertyMetadata;
        CharSequence charSequence = targetPropertyMetadata.getLinkOriginPropertyName();
        if (charSequence.length() == 0) {
            boolean bl = false;
            throw new IllegalArgumentException("Target property '" + targetProperty.getName() + "' is not a backlink property.");
        }
        ClassMetadata sourceClassMetadata = objectReference.getOwner().getSchemaMetadata().getOrThrow(targetPropertyMetadata.getLinkTarget());
        if (!Intrinsics.areEqual(this.sourceClass, sourceClassMetadata.getClazz())) {
            StringBuilder stringBuilder = new StringBuilder().append("Target property type '");
            KClass<? extends TypedRealmObject> kClass = sourceClassMetadata.getClazz();
            Intrinsics.checkNotNull(kClass);
            throw new IllegalArgumentException(stringBuilder.append(kClass.getSimpleName()).append("' does not match backlink type '").append(this.sourceClass.getSimpleName()).append("'.").toString());
        }
        PropertyMetadata propertyMetadata2 = sourceClassMetadata.get(targetPropertyMetadata.getLinkOriginPropertyName());
        Intrinsics.checkNotNull((Object)propertyMetadata2);
        PropertyMetadata sourcePropertyKey = propertyMetadata2;
        RealmObjectHelper realmObjectHelper = RealmObjectHelper.INSTANCE;
        long l = sourcePropertyKey.getKey--EmY2nY();
        long l2 = sourceClassMetadata.getClassKey-QNRHIEo();
        KClass<T> kClass = this.sourceClass;
        RealmResultsImpl<T> linkingObjects = realmObjectHelper.getBacklinks-JlhGzT4$io_realm_kotlin_library(objectReference, l2, l, kClass);
        return new ObjectBoundRealmResults(objectReference, linkingObjects);
    }

    @Override
    @NotNull
    public T getValue(@NotNull EmbeddedRealmObject reference, @NotNull KProperty<?> targetProperty) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(targetProperty, (String)"targetProperty");
        TypedRealmObject typedRealmObject = (TypedRealmObject)CollectionsKt.firstOrNull((List)this.createBacklinks(reference, targetProperty));
        if (typedRealmObject == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Backlink '").append(targetProperty.getName()).append("' is not an instance of target property type '");
            KClass<T> kClass = this.sourceClass;
            Intrinsics.checkNotNull(kClass);
            throw new IllegalStateException(stringBuilder.append(kClass.getSimpleName()).append("'.").toString());
        }
        return (T)typedRealmObject;
    }

    @Override
    @NotNull
    public RealmResults<T> getValue(@NotNull RealmObject reference, @NotNull KProperty<?> targetProperty) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(targetProperty, (String)"targetProperty");
        return this.createBacklinks(reference, targetProperty);
    }
}

