/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J-\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\t\u0010\u0014\u001a\u00020\u0003H\u0082\bJA\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J9\u0010\u0019\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0016\u0010\r\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000f0\u000e\"\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lio/realm/kotlin/internal/platform/StdOutLogger;", "Lio/realm/kotlin/log/RealmLogger;", "tag", "", "level", "Lio/realm/kotlin/log/LogLevel;", "(Ljava/lang/String;Lio/realm/kotlin/log/LogLevel;)V", "getLevel", "()Lio/realm/kotlin/log/LogLevel;", "getTag", "()Ljava/lang/String;", "formatMessage", "message", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "t", "", "getTimestamp", "log", "", "throwable", "(Lio/realm/kotlin/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "prepareLogMessage", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Companion", "io.realm.kotlin.library"})
@SourceDebugExtension(value={"SMAP\nStdOutLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StdOutLogger.kt\nio/realm/kotlin/internal/platform/StdOutLogger\n*L\n1#1,93:1\n50#1:94\n*S KotlinDebug\n*F\n+ 1 StdOutLogger.kt\nio/realm/kotlin/internal/platform/StdOutLogger\n*L\n37#1:94\n*E\n"})
public final class StdOutLogger
implements RealmLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private final LogLevel level;
    public static final int INITIAL_BUFFER_SIZE = 256;
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MMM-dd hh:mm:ss,SSS");

    public StdOutLogger(@NotNull String tag, @NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.tag = tag;
        this.level = level;
    }

    public /* synthetic */ StdOutLogger(String string, LogLevel logLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "REALM";
        }
        this(string, logLevel);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public void log(@NotNull LogLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String logMessage = this.prepareLogMessage(throwable, message, Arrays.copyOf(args, args.length));
        StdOutLogger this_$iv = this;
        boolean $i$f$getTimestamp = false;
        String string = Companion.getTIMESTAMP_FORMATTER().format(Instant.now().atZone(ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TIMESTAMP_FORMATTER.form\u2026(ZoneId.systemDefault()))");
        String timestamp = string;
        System.out.println((Object)(timestamp + ' ' + level.name() + ": [" + this.getTag() + "] " + logMessage));
    }

    private final String getTimestamp() {
        boolean $i$f$getTimestamp = false;
        String string = Companion.getTIMESTAMP_FORMATTER().format(Instant.now().atZone(ZoneId.systemDefault()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TIMESTAMP_FORMATTER.form\u2026(ZoneId.systemDefault()))");
        return string;
    }

    private final String prepareLogMessage(Throwable throwable, String message, Object ... args) {
        String messageToLog = message;
        CharSequence charSequence = messageToLog;
        if (charSequence == null || charSequence.length() == 0) {
            if (throwable == null) {
                return "";
            }
            messageToLog = this.getStackTraceString(throwable);
        } else {
            if (!(args.length == 0)) {
                messageToLog = this.formatMessage(messageToLog, Arrays.copyOf(args, args.length));
            }
            if (throwable != null) {
                messageToLog = messageToLog + '\n' + this.getStackTraceString(throwable);
            }
        }
        return messageToLog;
    }

    private final String formatMessage(String message, Object ... args) {
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(message, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(this, *args)");
        return string;
    }

    private final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    @Override
    public void log(@NotNull LogLevel level, @NotNull String message) {
        RealmLogger.DefaultImpls.log(this, level, message);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/realm/kotlin/internal/platform/StdOutLogger$Companion;", "", "()V", "INITIAL_BUFFER_SIZE", "", "TIMESTAMP_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getTIMESTAMP_FORMATTER$annotations", "getTIMESTAMP_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "io.realm.kotlin.library"})
    public static final class Companion {
        private Companion() {
        }

        public final DateTimeFormatter getTIMESTAMP_FORMATTER() {
            return TIMESTAMP_FORMATTER;
        }

        public static /* synthetic */ void getTIMESTAMP_FORMATTER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

