/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.query;

import io.realm.kotlin.internal.CoreExceptionConverter;
import io.realm.kotlin.internal.Flowable;
import io.realm.kotlin.internal.InternalDeleteable;
import io.realm.kotlin.internal.InternalDeleteableKt;
import io.realm.kotlin.internal.Mediator;
import io.realm.kotlin.internal.Observable;
import io.realm.kotlin.internal.RealmReference;
import io.realm.kotlin.internal.RealmResultsImpl;
import io.realm.kotlin.internal.RealmValueArgumentConverter;
import io.realm.kotlin.internal.Thawable;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmCoreException;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.RealmQueryT;
import io.realm.kotlin.internal.interop.RealmResultsT;
import io.realm.kotlin.internal.query.AggregatorQueryType;
import io.realm.kotlin.internal.query.CountQuery;
import io.realm.kotlin.internal.query.MinMaxQuery;
import io.realm.kotlin.internal.query.ObjectQuery;
import io.realm.kotlin.internal.query.QueryUtilsKt;
import io.realm.kotlin.internal.query.SingleQuery;
import io.realm.kotlin.internal.query.SumQuery;
import io.realm.kotlin.notifications.ResultsChange;
import io.realm.kotlin.query.RealmQuery;
import io.realm.kotlin.query.RealmResults;
import io.realm.kotlin.query.RealmScalarNullableQuery;
import io.realm.kotlin.query.RealmScalarQuery;
import io.realm.kotlin.query.RealmSingleQuery;
import io.realm.kotlin.query.Sort;
import io.realm.kotlin.types.BaseRealmObject;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\b0\u00060\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\b0\tB+\b\u0010\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000fBf\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0016J\b\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u00020\u0019H\u0016J/\u00101\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00102\u001a\u00020\u00192\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001b\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u00104J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00028\u000006H\u0016J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00028\u000008H\u0016J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00109\u001a\u00020:H\u0016J.\u0010;\u001a\b\u0012\u0004\u0012\u0002H=0<\"\b\b\u0001\u0010=*\u00020\u001c2\u0006\u00102\u001a\u00020\u00192\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H=0\u0015H\u0016J.\u0010?\u001a\b\u0012\u0004\u0012\u0002H=0<\"\b\b\u0001\u0010=*\u00020\u001c2\u0006\u00102\u001a\u00020\u00192\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H=0\u0015H\u0016J\u0012\u0010@\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0002J3\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010B\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010CJS\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020G0F2*\u0010H\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020G0F0\u001b\"\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020G0FH\u0016\u00a2\u0006\u0002\u0010IJ\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00102\u001a\u00020\u00192\u0006\u0010J\u001a\u00020GH\u0016J.\u0010K\u001a\b\u0012\u0004\u0012\u0002H=0,\"\b\b\u0001\u0010=*\u00020\u001c2\u0006\u00102\u001a\u00020\u00192\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H=0\u0015H\u0016J\u0016\u0010L\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010M\u001a\u00020\u0011H\u0016J*\u0010N\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0016\u0010O\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0PH\u0002R\u001a\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0019\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010#\u001a\f\u0012\u0004\u0012\u00020$0\u000bj\u0002`%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b&\u0010\"\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006Q"}, d2={"Lio/realm/kotlin/internal/query/ObjectQuery;", "E", "Lio/realm/kotlin/types/BaseRealmObject;", "Lio/realm/kotlin/query/RealmQuery;", "Lio/realm/kotlin/internal/InternalDeleteable;", "Lio/realm/kotlin/internal/Thawable;", "Lio/realm/kotlin/internal/Observable;", "Lio/realm/kotlin/internal/RealmResultsImpl;", "Lio/realm/kotlin/notifications/ResultsChange;", "Lio/realm/kotlin/internal/Flowable;", "composedQueryPointer", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/RealmQueryT;", "Lio/realm/kotlin/internal/interop/RealmQueryPointer;", "objectQuery", "(Lio/realm/kotlin/internal/interop/NativePointer;Lio/realm/kotlin/internal/query/ObjectQuery;)V", "realmReference", "Lio/realm/kotlin/internal/RealmReference;", "classKey", "Lio/realm/kotlin/internal/interop/ClassKey;", "clazz", "Lkotlin/reflect/KClass;", "mediator", "Lio/realm/kotlin/internal/Mediator;", "filter", "", "args", "", "", "(Lio/realm/kotlin/internal/RealmReference;JLkotlin/reflect/KClass;Lio/realm/kotlin/internal/Mediator;Lio/realm/kotlin/internal/interop/NativePointer;Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "[Ljava/lang/Object;", "J", "queryPointer", "getQueryPointer$io_realm_kotlin_library", "()Lio/realm/kotlin/internal/interop/NativePointer;", "resultsPointer", "Lio/realm/kotlin/internal/interop/RealmResultsT;", "Lio/realm/kotlin/internal/interop/RealmResultsPointer;", "getResultsPointer", "resultsPointer$delegate", "Lkotlin/Lazy;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "count", "Lio/realm/kotlin/query/RealmScalarQuery;", "", "delete", "", "description", "distinct", "property", "extraProperties", "(Ljava/lang/String;[Ljava/lang/String;)Lio/realm/kotlin/query/RealmQuery;", "find", "Lio/realm/kotlin/query/RealmResults;", "first", "Lio/realm/kotlin/query/RealmSingleQuery;", "limit", "", "max", "Lio/realm/kotlin/query/RealmScalarNullableQuery;", "T", "type", "min", "parseQuery", "query", "arguments", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/kotlin/query/RealmQuery;", "sort", "propertyAndSortOrder", "Lkotlin/Pair;", "Lio/realm/kotlin/query/Sort;", "additionalPropertiesAndOrders", "(Lkotlin/Pair;[Lkotlin/Pair;)Lio/realm/kotlin/query/RealmQuery;", "sortOrder", "sum", "thaw", "liveRealm", "tryCatchCoreException", "block", "Lkotlin/Function0;", "io.realm.kotlin.library"})
public final class ObjectQuery<E extends BaseRealmObject>
implements RealmQuery<E>,
InternalDeleteable,
Thawable<Observable<RealmResultsImpl<E>, ResultsChange<E>>>,
Flowable<ResultsChange<E>> {
    @NotNull
    private final RealmReference realmReference;
    private final long classKey;
    @NotNull
    private final KClass<E> clazz;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final String filter;
    @NotNull
    private final Object[] args;
    @NotNull
    private final NativePointer<RealmQueryT> queryPointer;
    @NotNull
    private final Lazy resultsPointer$delegate;

    private ObjectQuery(RealmReference realmReference2, long classKey, KClass<E> clazz, Mediator mediator, NativePointer<RealmQueryT> composedQueryPointer, String filter2, Object ... args) {
        this.realmReference = realmReference2;
        this.classKey = classKey;
        this.clazz = clazz;
        this.mediator = mediator;
        this.filter = filter2;
        this.args = args;
        this.queryPointer = composedQueryPointer != null ? composedQueryPointer : this.parseQuery();
        this.resultsPointer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativePointer<RealmResultsT>>(this){
            final /* synthetic */ ObjectQuery<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer<RealmResultsT> invoke() {
                return RealmInterop.INSTANCE.realm_query_find_all(this.this$0.getQueryPointer$io_realm_kotlin_library());
            }
        }));
    }

    public /* synthetic */ ObjectQuery(RealmReference realmReference2, long l, KClass kClass, Mediator mediator, NativePointer nativePointer, String string, Object[] objectArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            nativePointer = null;
        }
        this(realmReference2, l, kClass, mediator, nativePointer, string, objectArray, null);
    }

    @NotNull
    public final NativePointer<RealmQueryT> getQueryPointer$io_realm_kotlin_library() {
        return this.queryPointer;
    }

    private final NativePointer<RealmResultsT> getResultsPointer() {
        Lazy lazy = this.resultsPointer$delegate;
        return (NativePointer)lazy.getValue();
    }

    public ObjectQuery(@Nullable NativePointer<RealmQueryT> composedQueryPointer, @NotNull ObjectQuery<E> objectQuery) {
        Intrinsics.checkNotNullParameter(objectQuery, (String)"objectQuery");
        Object[] objectArray = objectQuery.args;
        this(objectQuery.realmReference, objectQuery.classKey, objectQuery.clazz, objectQuery.mediator, composedQueryPointer, objectQuery.filter, Arrays.copyOf(objectArray, objectArray.length), null);
    }

    @Override
    @NotNull
    public RealmResults<E> find() {
        return new RealmResultsImpl(this.realmReference, this.getResultsPointer(), this.classKey, this.clazz, this.mediator, null, 32, null);
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String filter2, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        NativePointer<RealmQueryT> appendedQuery2 = this.tryCatchCoreException((Function0<NativePointer<RealmQueryT>>)((Function0)new Function0<NativePointer<RealmQueryT>>(this, filter2, arguments){
            final /* synthetic */ ObjectQuery<E> this$0;
            final /* synthetic */ String $filter;
            final /* synthetic */ Object[] $arguments;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$arguments = $arguments;
                super(0);
            }

            @NotNull
            public final NativePointer<RealmQueryT> invoke() {
                return RealmInterop.INSTANCE.realm_query_append_query(this.this$0.getQueryPointer$io_realm_kotlin_library(), this.$filter, RealmValueArgumentConverter.INSTANCE.convertArgs(this.$arguments));
            }
        }));
        return new ObjectQuery<E>(appendedQuery2, this);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull String property, @NotNull Sort sortOrder) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.query("TRUEPREDICATE SORT(" + property + ' ' + sortOrder.name() + ')', new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull Pair<String, ? extends Sort> propertyAndSortOrder, Pair<String, ? extends Sort> ... additionalPropertiesAndOrders) {
        Intrinsics.checkNotNullParameter(propertyAndSortOrder, (String)"propertyAndSortOrder");
        Intrinsics.checkNotNullParameter(additionalPropertiesAndOrders, (String)"additionalPropertiesAndOrders");
        String property = (String)propertyAndSortOrder.component1();
        Sort order = (Sort)((Object)propertyAndSortOrder.component2());
        StringBuilder stringBuilder = new StringBuilder().append("TRUEPREDICATE SORT(" + property + ' ' + (Object)((Object)order));
        Pair<String, ? extends Sort>[] $this$forEach$iv = additionalPropertiesAndOrders;
        boolean $i$f$forEach = false;
        for (Pair<String, ? extends Sort> element$iv : $this$forEach$iv) {
            Pair<String, ? extends Sort> $dstr$extraProperty$extraOrder = element$iv;
            boolean bl = false;
            String extraProperty = (String)$dstr$extraProperty$extraOrder.component1();
            Sort extraOrder = (Sort)((Object)$dstr$extraProperty$extraOrder.component2());
            stringBuilder.append(", " + extraProperty + ' ' + (Object)((Object)extraOrder));
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return this.query(string, new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> distinct(@NotNull String property, String ... extraProperties) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)extraProperties, (String)"extraProperties");
        StringBuilder stringBuilder = new StringBuilder().append(Intrinsics.stringPlus((String)"TRUEPREDICATE DISTINCT(", (Object)property));
        String[] $this$forEach$iv = extraProperties;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String extraProperty = element$iv;
            boolean bl = false;
            stringBuilder.append(Intrinsics.stringPlus((String)", ", (Object)extraProperty));
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return this.query(string, new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> limit(int limit) {
        return this.query("TRUEPREDICATE LIMIT(" + limit + ')', new Object[0]);
    }

    @Override
    @NotNull
    public RealmSingleQuery<E> first() {
        return new SingleQuery(this.realmReference, this.queryPointer, this.classKey, this.clazz, this.mediator, null);
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> min(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new MinMaxQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, property, type, AggregatorQueryType.MIN, null);
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> max(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new MinMaxQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, property, type, AggregatorQueryType.MAX, null);
    }

    @Override
    @NotNull
    public <T> RealmScalarQuery<T> sum(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new SumQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, property, type, null);
    }

    @Override
    @NotNull
    public RealmScalarQuery<Long> count() {
        return new CountQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, null);
    }

    @Override
    @NotNull
    public RealmResultsImpl<E> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        return QueryUtilsKt.thawResults-7ThTuWM(liveRealm, this.getResultsPointer(), this.classKey, this.clazz, this.mediator);
    }

    @Override
    @NotNull
    public Flow<ResultsChange<E>> asFlow() {
        this.realmReference.checkClosed();
        return this.realmReference.getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    public void delete() {
        InternalDeleteableKt.asInternalDeleteable(this.find()).delete();
    }

    private final NativePointer<RealmQueryT> parseQuery() {
        return this.tryCatchCoreException((Function0<NativePointer<RealmQueryT>>)((Function0)new Function0<NativePointer<RealmQueryT>>(this){
            final /* synthetic */ ObjectQuery<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer<RealmQueryT> invoke() {
                return RealmInterop.INSTANCE.realm_query_parse-6CC_B8E(ObjectQuery.access$getRealmReference$p(this.this$0).getDbPointer(), ObjectQuery.access$getClassKey$p(this.this$0), ObjectQuery.access$getFilter$p(this.this$0), RealmValueArgumentConverter.INSTANCE.convertArgs(ObjectQuery.access$getArgs$p(this.this$0)));
            }
        }));
    }

    private final NativePointer<RealmQueryT> tryCatchCoreException(Function0<? extends NativePointer<RealmQueryT>> block) {
        NativePointer nativePointer;
        try {
            nativePointer = (NativePointer)block.invoke();
        }
        catch (Throwable exception) {
            throw CoreExceptionConverter.INSTANCE.convertToPublicException(exception, Intrinsics.stringPlus((String)"Invalid syntax in query: ", (Object)exception.getMessage()), (Function1<? super RealmCoreException, ? extends Throwable>)((Function1)tryCatchCoreException.1.INSTANCE));
        }
        return nativePointer;
    }

    @Override
    @NotNull
    public String description() {
        return RealmInterop.INSTANCE.realm_query_get_description(this.queryPointer);
    }

    public /* synthetic */ ObjectQuery(RealmReference realmReference2, long classKey, KClass clazz, Mediator mediator, NativePointer composedQueryPointer, String filter2, Object[] args, DefaultConstructorMarker $constructor_marker) {
        this(realmReference2, classKey, clazz, mediator, (NativePointer<RealmQueryT>)composedQueryPointer, filter2, args);
    }

    public static final /* synthetic */ RealmReference access$getRealmReference$p(ObjectQuery $this) {
        return $this.realmReference;
    }

    public static final /* synthetic */ long access$getClassKey$p(ObjectQuery $this) {
        return $this.classKey;
    }

    public static final /* synthetic */ String access$getFilter$p(ObjectQuery $this) {
        return $this.filter;
    }

    public static final /* synthetic */ Object[] access$getArgs$p(ObjectQuery $this) {
        return $this.args;
    }
}

