/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.platform;

import io.realm.kotlin.internal.platform.StdOutLogger;
import io.realm.kotlin.log.LogLevel;
import io.realm.kotlin.log.RealmLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\f"}, d2={"OS_NAME", "", "getOS_NAME", "()Ljava/lang/String;", "OS_VERSION", "getOS_VERSION", "appFilesDirectory", "createDefaultSystemLogger", "Lio/realm/kotlin/log/RealmLogger;", "tag", "logLevel", "Lio/realm/kotlin/log/LogLevel;", "io.realm.kotlin.library"})
public final class SystemUtilsJvmKt {
    @NotNull
    private static final String OS_NAME;
    @NotNull
    private static final String OS_VERSION;

    @NotNull
    public static final String getOS_NAME() {
        return OS_NAME;
    }

    @NotNull
    public static final String getOS_VERSION() {
        return OS_VERSION;
    }

    @NotNull
    public static final String appFilesDirectory() {
        String string = System.getProperty("user.dir");
        if (string == null) {
            string = ".";
        }
        return string;
    }

    @NotNull
    public static final RealmLogger createDefaultSystemLogger(@NotNull String tag, @NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        return new StdOutLogger(tag, logLevel);
    }

    public static /* synthetic */ RealmLogger createDefaultSystemLogger$default(String string, LogLevel logLevel, int n, Object object) {
        if ((n & 2) != 0) {
            logLevel = LogLevel.NONE;
        }
        return SystemUtilsJvmKt.createDefaultSystemLogger(string, logLevel);
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        OS_NAME = string;
        string = System.getProperty("os.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.version\")");
        OS_VERSION = string;
    }
}

