/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.query;

import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.internal.Mediator;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.Thawable;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmCoreIndexOutOfBoundsException;
import io.realm.internal.interop.RealmCoreInvalidQueryException;
import io.realm.internal.interop.RealmCoreInvalidQueryStringException;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.query.AggregatorQueryType;
import io.realm.internal.query.CountQuery;
import io.realm.internal.query.MinMaxQuery;
import io.realm.internal.query.QueryUtilsKt;
import io.realm.internal.query.SingleQuery;
import io.realm.internal.query.SumQuery;
import io.realm.query.RealmQuery;
import io.realm.query.RealmScalarNullableQuery;
import io.realm.query.RealmScalarQuery;
import io.realm.query.RealmSingleQuery;
import io.realm.query.Sort;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0004B\u001f\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\tBO\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001f0\u001eH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J/\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010$\u001a\u00020\u00112\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013\"\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010&J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000)H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010*\u001a\u00020+H\u0016J.\u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\b\b\u0001\u0010.*\u00020\u00142\u0006\u0010$\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.0\rH\u0016J.\u00100\u001a\b\u0012\u0004\u0012\u0002H.0-\"\b\b\u0001\u0010.*\u00020\u00142\u0006\u0010$\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.0\rH\u0016J\b\u00101\u001a\u00020\u0007H\u0002J3\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013\"\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u00104JS\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u000208072*\u00109\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u000208070\u0013\"\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020807H\u0016\u00a2\u0006\u0002\u0010:J\u001e\u00105\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010$\u001a\u00020\u00112\u0006\u0010;\u001a\u000208H\u0016J.\u0010<\u001a\b\u0012\u0004\u0012\u0002H.0!\"\b\b\u0001\u0010.*\u00020\u00142\u0006\u0010$\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.0\rH\u0016J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010>\u001a\u00020\u000bH\u0016J\u0016\u0010?\u001a\u00020\u00072\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00070AH\u0002R\u001a\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006B"}, d2={"Lio/realm/internal/query/ObjectQuery;", "E", "Lio/realm/RealmObject;", "Lio/realm/query/RealmQuery;", "Lio/realm/internal/Thawable;", "Lio/realm/internal/RealmResultsImpl;", "composedQueryPointer", "Lio/realm/internal/interop/NativePointer;", "objectQuery", "(Lio/realm/internal/interop/NativePointer;Lio/realm/internal/query/ObjectQuery;)V", "realmReference", "Lio/realm/internal/RealmReference;", "clazz", "Lkotlin/reflect/KClass;", "mediator", "Lio/realm/internal/Mediator;", "filter", "", "args", "", "", "(Lio/realm/internal/RealmReference;Lkotlin/reflect/KClass;Lio/realm/internal/Mediator;Lio/realm/internal/interop/NativePointer;Ljava/lang/String;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "queryPointer", "resultsPointer", "getResultsPointer", "()Lio/realm/internal/interop/NativePointer;", "resultsPointer$delegate", "Lkotlin/Lazy;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/RealmResults;", "count", "Lio/realm/query/RealmScalarQuery;", "", "distinct", "property", "extraProperties", "(Ljava/lang/String;[Ljava/lang/String;)Lio/realm/query/RealmQuery;", "find", "first", "Lio/realm/query/RealmSingleQuery;", "limit", "", "max", "Lio/realm/query/RealmScalarNullableQuery;", "T", "type", "min", "parseQuery", "query", "arguments", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/query/RealmQuery;", "sort", "propertyAndSortOrder", "Lkotlin/Pair;", "Lio/realm/query/Sort;", "additionalPropertiesAndOrders", "(Lkotlin/Pair;[Lkotlin/Pair;)Lio/realm/query/RealmQuery;", "sortOrder", "sum", "thaw", "liveRealm", "tryCatchCoreException", "block", "Lkotlin/Function0;", "io.realm.kotlin.library"})
public final class ObjectQuery<E extends RealmObject>
implements RealmQuery<E>,
Thawable<RealmResultsImpl<E>> {
    @NotNull
    private final RealmReference realmReference;
    @NotNull
    private final KClass<E> clazz;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final String filter;
    @NotNull
    private final Object[] args;
    @NotNull
    private final NativePointer queryPointer;
    @NotNull
    private final Lazy resultsPointer$delegate;

    public ObjectQuery(@NotNull RealmReference realmReference, @NotNull KClass<E> clazz, @NotNull Mediator mediator, @Nullable NativePointer composedQueryPointer, @NotNull String filter, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)realmReference, (String)"realmReference");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.realmReference = realmReference;
        this.clazz = clazz;
        this.mediator = mediator;
        this.filter = filter;
        this.args = args;
        this.queryPointer = composedQueryPointer != null ? composedQueryPointer : this.parseQuery();
        this.resultsPointer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativePointer>(this){
            final /* synthetic */ ObjectQuery<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                return RealmInterop.INSTANCE.realm_query_find_all(ObjectQuery.access$getQueryPointer$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ ObjectQuery(RealmReference realmReference, KClass kClass, Mediator mediator, NativePointer nativePointer, String string, Object[] objectArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            nativePointer = null;
        }
        this(realmReference, kClass, mediator, nativePointer, string, objectArray);
    }

    private final NativePointer getResultsPointer() {
        Lazy lazy = this.resultsPointer$delegate;
        return (NativePointer)lazy.getValue();
    }

    public ObjectQuery(@Nullable NativePointer composedQueryPointer, @NotNull ObjectQuery<E> objectQuery) {
        Intrinsics.checkNotNullParameter(objectQuery, (String)"objectQuery");
        Object[] objectArray = objectQuery.args;
        this(objectQuery.realmReference, objectQuery.clazz, objectQuery.mediator, composedQueryPointer, objectQuery.filter, Arrays.copyOf(objectArray, objectArray.length));
    }

    @Override
    @NotNull
    public RealmResults<E> find() {
        return new RealmResultsImpl(this.realmReference, this.getResultsPointer(), this.clazz, this.mediator, null, 16, null);
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String filter, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        NativePointer appendedQuery2 = this.tryCatchCoreException((Function0<NativePointer>)((Function0)new Function0<NativePointer>(this, filter, arguments){
            final /* synthetic */ ObjectQuery<E> this$0;
            final /* synthetic */ String $filter;
            final /* synthetic */ Object[] $arguments;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$arguments = $arguments;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                return RealmInterop.INSTANCE.realm_query_append_query(ObjectQuery.access$getQueryPointer$p(this.this$0), this.$filter, Arrays.copyOf(this.$arguments, this.$arguments.length));
            }
        }));
        return new ObjectQuery<E>(appendedQuery2, this);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull String property, @NotNull Sort sortOrder) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.query("TRUEPREDICATE SORT(" + property + ' ' + sortOrder.name() + ')', new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull Pair<String, ? extends Sort> propertyAndSortOrder, Pair<String, ? extends Sort> ... additionalPropertiesAndOrders) {
        Intrinsics.checkNotNullParameter(propertyAndSortOrder, (String)"propertyAndSortOrder");
        Intrinsics.checkNotNullParameter(additionalPropertiesAndOrders, (String)"additionalPropertiesAndOrders");
        String property = (String)propertyAndSortOrder.component1();
        Sort order = (Sort)((Object)propertyAndSortOrder.component2());
        StringBuilder stringBuilder = new StringBuilder().append("TRUEPREDICATE SORT(" + property + ' ' + (Object)((Object)order));
        Pair<String, ? extends Sort>[] $this$forEach$iv = additionalPropertiesAndOrders;
        boolean $i$f$forEach = false;
        for (Pair<String, ? extends Sort> element$iv : $this$forEach$iv) {
            Pair<String, ? extends Sort> $dstr$extraProperty$extraOrder = element$iv;
            boolean bl = false;
            String extraProperty = (String)$dstr$extraProperty$extraOrder.component1();
            Sort extraOrder = (Sort)((Object)$dstr$extraProperty$extraOrder.component2());
            stringBuilder.append(", " + extraProperty + ' ' + (Object)((Object)extraOrder));
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return this.query(string, new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> distinct(@NotNull String property, String ... extraProperties) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)extraProperties, (String)"extraProperties");
        StringBuilder stringBuilder = new StringBuilder().append(Intrinsics.stringPlus((String)"TRUEPREDICATE DISTINCT(", (Object)property));
        String[] $this$forEach$iv = extraProperties;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String extraProperty = element$iv;
            boolean bl = false;
            stringBuilder.append(Intrinsics.stringPlus((String)", ", (Object)extraProperty));
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return this.query(string, new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> limit(int limit) {
        return this.query("TRUEPREDICATE LIMIT(" + limit + ')', new Object[0]);
    }

    @Override
    @NotNull
    public RealmSingleQuery<E> first() {
        return new SingleQuery<E>(this.realmReference, this.queryPointer, this.clazz, this.mediator);
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> min(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new MinMaxQuery<E, T>(this.realmReference, this.queryPointer, this.mediator, this.clazz, property, type, AggregatorQueryType.MIN);
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> max(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new MinMaxQuery<E, T>(this.realmReference, this.queryPointer, this.mediator, this.clazz, property, type, AggregatorQueryType.MAX);
    }

    @Override
    @NotNull
    public <T> RealmScalarQuery<T> sum(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new SumQuery<E, T>(this.realmReference, this.queryPointer, this.mediator, this.clazz, property, type);
    }

    @Override
    @NotNull
    public RealmScalarQuery<Long> count() {
        return new CountQuery<E>(this.realmReference, this.queryPointer, this.mediator, this.clazz);
    }

    @Override
    @NotNull
    public RealmResultsImpl<E> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        return QueryUtilsKt.thawResults(liveRealm, this.getResultsPointer(), this.clazz, this.mediator);
    }

    @Override
    @NotNull
    public Flow<RealmResults<E>> asFlow() {
        RealmReference this_$iv = this.realmReference;
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return this.realmReference.getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    private final NativePointer parseQuery() {
        return this.tryCatchCoreException((Function0<NativePointer>)((Function0)new Function0<NativePointer>(this){
            final /* synthetic */ ObjectQuery<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer invoke() {
                NativePointer nativePointer = ObjectQuery.access$getRealmReference$p(this.this$0).getDbPointer();
                String string = ObjectQuery.access$getClazz$p(this.this$0).getSimpleName();
                Intrinsics.checkNotNull((Object)string);
                Object[] objectArray = ObjectQuery.access$getArgs$p(this.this$0);
                return RealmInterop.INSTANCE.realm_query_parse(nativePointer, string, ObjectQuery.access$getFilter$p(this.this$0), Arrays.copyOf(objectArray, objectArray.length));
            }
        }));
    }

    private final NativePointer tryCatchCoreException(Function0<? extends NativePointer> block) {
        NativePointer nativePointer;
        try {
            nativePointer = (NativePointer)block.invoke();
        }
        catch (RealmCoreException exception) {
            RealmCoreException realmCoreException = exception;
            throw realmCoreException instanceof RealmCoreInvalidQueryStringException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Wrong query string: ", (Object)exception.getMessage())) : (realmCoreException instanceof RealmCoreInvalidQueryException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Wrong query field provided or malformed syntax in query: ", (Object)exception.getMessage())) : (realmCoreException instanceof RealmCoreIndexOutOfBoundsException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Have you specified all parameters in your query?: ", (Object)exception.getMessage())) : RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Invalid syntax in query: ", (Object)exception.getMessage()), exception)));
        }
        return nativePointer;
    }

    public static final /* synthetic */ NativePointer access$getQueryPointer$p(ObjectQuery $this) {
        return $this.queryPointer;
    }

    public static final /* synthetic */ RealmReference access$getRealmReference$p(ObjectQuery $this) {
        return $this.realmReference;
    }

    public static final /* synthetic */ KClass access$getClazz$p(ObjectQuery $this) {
        return $this.clazz;
    }

    public static final /* synthetic */ String access$getFilter$p(ObjectQuery $this) {
        return $this.filter;
    }

    public static final /* synthetic */ Object[] access$getArgs$p(ObjectQuery $this) {
        return $this.args;
    }
}

