/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.query;

import io.realm.RealmInstant;
import io.realm.RealmObject;
import io.realm.internal.Mediator;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.Thawable;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmCoreLogicException;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.interop.Timestamp;
import io.realm.internal.query.AggregatorQueryType;
import io.realm.internal.query.BaseScalarQuery;
import io.realm.internal.query.MinMaxQuery$asFlow$;
import io.realm.query.RealmScalarNullableQuery;
import java.lang.constant.Constable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u00052\b\u0012\u0004\u0012\u0002H\u00030\u00062\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\b0\u0007BI\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0018H\u0016J\u001f\u0010\u0019\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u000f\u0010\u001e\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0017\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010!R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/realm/internal/query/MinMaxQuery;", "E", "Lio/realm/RealmObject;", "T", "", "Lio/realm/internal/query/BaseScalarQuery;", "Lio/realm/query/RealmScalarNullableQuery;", "Lio/realm/internal/Thawable;", "Lio/realm/internal/RealmResultsImpl;", "realmReference", "Lio/realm/internal/RealmReference;", "queryPointer", "Lio/realm/internal/interop/NativePointer;", "mediator", "Lio/realm/internal/Mediator;", "clazz", "Lkotlin/reflect/KClass;", "property", "", "type", "queryType", "Lio/realm/internal/query/AggregatorQueryType;", "(Lio/realm/internal/RealmReference;Lio/realm/internal/interop/NativePointer;Lio/realm/internal/Mediator;Lkotlin/reflect/KClass;Ljava/lang/String;Lkotlin/reflect/KClass;Lio/realm/internal/query/AggregatorQueryType;)V", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "computeAggregatedValue", "resultsPointer", "colKey", "", "(Lio/realm/internal/interop/NativePointer;J)Ljava/lang/Object;", "find", "()Ljava/lang/Object;", "findFromResults", "(Lio/realm/internal/interop/NativePointer;)Ljava/lang/Object;", "io.realm.kotlin.library"})
public final class MinMaxQuery<E extends RealmObject, T>
extends BaseScalarQuery<E>
implements RealmScalarNullableQuery<T>,
Thawable<RealmResultsImpl<E>> {
    @NotNull
    private final String property;
    @NotNull
    private final KClass<T> type;
    @NotNull
    private final AggregatorQueryType queryType;

    public MinMaxQuery(@NotNull RealmReference realmReference, @NotNull NativePointer queryPointer, @NotNull Mediator mediator, @NotNull KClass<E> clazz, @NotNull String property, @NotNull KClass<T> type, @NotNull AggregatorQueryType queryType) {
        Intrinsics.checkNotNullParameter((Object)realmReference, (String)"realmReference");
        Intrinsics.checkNotNullParameter((Object)queryPointer, (String)"queryPointer");
        Intrinsics.checkNotNullParameter((Object)mediator, (String)"mediator");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)queryType), (String)"queryType");
        super(realmReference, queryPointer, mediator, clazz);
        this.property = property;
        this.type = type;
        this.queryType = queryType;
    }

    @Override
    @Nullable
    public T find() {
        return this.findFromResults(RealmInterop.INSTANCE.realm_query_find_all(this.getQueryPointer()));
    }

    @Override
    @NotNull
    public Flow<T> asFlow() {
        RealmReference this_$iv = this.getRealmReference();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        Flow $this$map$iv = this.getRealmReference().getOwner().registerObserver$io_realm_kotlin_library(this);
        boolean $i$f$map = false;
        Flow $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return FlowKt.distinctUntilChanged((Flow)new Flow<T>($this$unsafeTransform$iv$iv, this){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ MinMaxQuery this$0;
            {
                this.$this_unsafeTransform$inlined = flow;
                this.this$0 = minMaxQuery;
            }

            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u2d0 = collector;
                boolean bl = false;
                Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u2d0, this.this$0){
                    final /* synthetic */ FlowCollector $this_unsafeFlow;
                    final /* synthetic */ MinMaxQuery this$0;
                    {
                        this.$this_unsafeFlow = $receiver;
                        this.this$0 = minMaxQuery;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof asFlow$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ asFlow$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                var6_6 = value;
                                $this$map_u24lambda_u2d4 = this.$this_unsafeFlow;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var9_10 = $this$map_u24lambda_u2d4;
                                (Continuation)$continuation;
                                it = (RealmResultsImpl)value;
                                $i$a$-map-MinMaxQuery$asFlow$1 = false;
                                $continuation.label = 1;
                                v0 = var9_10.emit(MinMaxQuery.access$findFromResults(this.this$0, it.getNativePointer$io_realm_kotlin_library()), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl29
                            }
                            case 1: {
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl29:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        });
    }

    private final T findFromResults(NativePointer resultsPointer2) {
        T t;
        try {
            long colKey = this.getPropertyKey-etEp7E8(this.getClazz(), this.property);
            t = this.computeAggregatedValue(resultsPointer2, colKey);
        }
        catch (RealmCoreException exception) {
            throw exception instanceof RealmCoreLogicException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid query formulation: ", (Object)exception.getMessage()), exception) : RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Invalid query formulation: ", (Object)exception.getMessage()), exception);
        }
        return t;
    }

    private final T computeAggregatedValue(NativePointer resultsPointer2, long colKey) {
        Comparable comparable;
        Object result;
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.queryType.ordinal()]) {
            case 1: {
                object = RealmInterop.INSTANCE.realm_results_min(resultsPointer2, colKey);
                break;
            }
            case 2: {
                object = RealmInterop.INSTANCE.realm_results_max(resultsPointer2, colKey);
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Use SumQuery instead.");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object object2 = result = object;
        if (object2 == null) {
            comparable = null;
        } else if (object2 instanceof Timestamp) {
            comparable = RealmInstant.Companion.fromEpochSeconds(((Timestamp)result).getSeconds(), ((Timestamp)result).getNanoSeconds());
        } else if (object2 instanceof Number) {
            Constable constable;
            KClass<T> kClass = this.type;
            if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                constable = ((Number)result).intValue();
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
                constable = ((Number)result).shortValue();
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                constable = ((Number)result).longValue();
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                constable = Float.valueOf(((Number)result).floatValue());
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                constable = ((Number)result).doubleValue();
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
                constable = ((Number)result).byteValue();
            } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Character.TYPE))) {
                constable = Character.valueOf((char)((Number)result).intValue());
            } else {
                throw new IllegalArgumentException("Invalid numeric type for '" + this.property + "', it is not a '" + this.type.getSimpleName() + "' or cannot be represented by it.");
            }
            comparable = constable;
        } else {
            throw new IllegalArgumentException("Invalid property type for '" + this.property + "', only Int, Long, Short, Double, Float and RealmInstant (except for 'SUM') properties can be aggregated.");
        }
        return (T)comparable;
    }

    public static final /* synthetic */ Object access$findFromResults(MinMaxQuery $this, NativePointer resultsPointer2) {
        return $this.findFromResults(resultsPointer2);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AggregatorQueryType.values().length];
            nArray[AggregatorQueryType.MIN.ordinal()] = 1;
            nArray[AggregatorQueryType.MAX.ordinal()] = 2;
            nArray[AggregatorQueryType.SUM.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

