/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.VersionId;
import io.realm.internal.BaseRealmImpl;
import io.realm.internal.RealmState;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\fH\u0086\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lio/realm/internal/RealmReference;", "Lio/realm/internal/RealmState;", "owner", "Lio/realm/internal/BaseRealmImpl;", "dbPointer", "Lio/realm/internal/interop/NativePointer;", "(Lio/realm/internal/BaseRealmImpl;Lio/realm/internal/interop/NativePointer;)V", "getDbPointer", "()Lio/realm/internal/interop/NativePointer;", "getOwner", "()Lio/realm/internal/BaseRealmImpl;", "checkClosed", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "isClosed", "isFrozen", "toString", "", "version", "Lio/realm/VersionId;", "library-base"})
public final class RealmReference
implements RealmState {
    @NotNull
    private final BaseRealmImpl owner;
    @NotNull
    private final NativePointer dbPointer;

    public RealmReference(@NotNull BaseRealmImpl owner, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        this.owner = owner;
        this.dbPointer = dbPointer;
    }

    @NotNull
    public final BaseRealmImpl getOwner() {
        return this.owner;
    }

    @NotNull
    public final NativePointer getDbPointer() {
        return this.dbPointer;
    }

    @Override
    @NotNull
    public VersionId version() {
        RealmReference this_$iv = this;
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return new VersionId(RealmInterop.INSTANCE.realm_get_version_id(this.dbPointer));
    }

    @Override
    public boolean isFrozen() {
        RealmReference this_$iv = this;
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return RealmInterop.INSTANCE.realm_is_frozen(this.dbPointer);
    }

    @Override
    public boolean isClosed() {
        return RealmInterop.INSTANCE.realm_is_closed(this.dbPointer);
    }

    public final void checkClosed() {
        boolean $i$f$checkClosed = false;
        if (this.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this.getOwner().getConfiguration().getPath()));
        }
    }

    @NotNull
    public final BaseRealmImpl component1() {
        return this.owner;
    }

    @NotNull
    public final NativePointer component2() {
        return this.dbPointer;
    }

    @NotNull
    public final RealmReference copy(@NotNull BaseRealmImpl owner, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        return new RealmReference(owner, dbPointer);
    }

    public static /* synthetic */ RealmReference copy$default(RealmReference realmReference, BaseRealmImpl baseRealmImpl, NativePointer nativePointer, int n, Object object) {
        if ((n & 1) != 0) {
            baseRealmImpl = realmReference.owner;
        }
        if ((n & 2) != 0) {
            nativePointer = realmReference.dbPointer;
        }
        return realmReference.copy(baseRealmImpl, nativePointer);
    }

    @NotNull
    public String toString() {
        return "RealmReference(owner=" + this.owner + ", dbPointer=" + this.dbPointer + ')';
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = result * 31 + this.dbPointer.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RealmReference)) {
            return false;
        }
        RealmReference realmReference = (RealmReference)other;
        if (!Intrinsics.areEqual((Object)this.owner, (Object)realmReference.owner)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dbPointer, (Object)realmReference.dbPointer);
    }
}

