/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.LogConfiguration;
import io.realm.log.LogLevel;
import io.realm.log.RealmLogger;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J+\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J5\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJA\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J+\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010!\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J5\u0010!\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\"\u001a\u00020#H\u0016J+\u0010$\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010$\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J5\u0010$\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ+\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010%\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J5\u0010%\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ+\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010&\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J5\u0010&\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aJ+\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010'\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J5\u0010'\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0016\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006("}, d2={"Lio/realm/internal/RealmLog;", "", "tag", "", "configuration", "Lio/realm/LogConfiguration;", "(Ljava/lang/String;Lio/realm/LogConfiguration;)V", "getConfiguration", "()Lio/realm/LogConfiguration;", "logLevel", "Lio/realm/log/LogLevel;", "getLogLevel", "()Lio/realm/log/LogLevel;", "loggers", "", "Lio/realm/log/RealmLogger;", "getTag", "()Ljava/lang/String;", "debug", "", "message", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "throwable", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "doLog", "level", "(Lio/realm/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "equals", "", "other", "error", "hashCode", "", "info", "trace", "warn", "wtf", "library-base"})
public final class RealmLog {
    @NotNull
    private final String tag;
    @NotNull
    private final LogConfiguration configuration;
    @NotNull
    private final LogLevel logLevel;
    @NotNull
    private final List<RealmLogger> loggers;

    public RealmLog(@NotNull String tag, @NotNull LogConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.tag = tag;
        this.configuration = configuration;
        this.logLevel = this.configuration.getLevel();
        this.loggers = this.configuration.getLoggers();
    }

    public /* synthetic */ RealmLog(String string, LogConfiguration logConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "REALM";
        }
        this(string, logConfiguration);
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final LogConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    public final void trace(@Nullable Throwable throwable) {
        this.doLog(LogLevel.TRACE, throwable, null, new Object[0]);
    }

    public final void trace(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.TRACE, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void trace(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.TRACE, null, message, Arrays.copyOf(args, args.length));
    }

    public final void debug(@Nullable Throwable throwable) {
        this.doLog(LogLevel.DEBUG, throwable, null, new Object[0]);
    }

    public final void debug(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.DEBUG, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void debug(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.DEBUG, null, message, Arrays.copyOf(args, args.length));
    }

    public final void info(@Nullable Throwable throwable) {
        this.doLog(LogLevel.INFO, throwable, null, new Object[0]);
    }

    public final void info(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.INFO, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void info(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.INFO, null, message, Arrays.copyOf(args, args.length));
    }

    public final void warn(@Nullable Throwable throwable) {
        this.doLog(LogLevel.WARN, throwable, null, new Object[0]);
    }

    public final void warn(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WARN, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void warn(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WARN, null, message, Arrays.copyOf(args, args.length));
    }

    public final void error(@Nullable Throwable throwable) {
        this.doLog(LogLevel.ERROR, throwable, null, new Object[0]);
    }

    public final void error(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.ERROR, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void error(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.ERROR, null, message, Arrays.copyOf(args, args.length));
    }

    public final void wtf(@Nullable Throwable throwable) {
        this.doLog(LogLevel.WTF, throwable, null, new Object[0]);
    }

    public final void wtf(@Nullable Throwable throwable, @NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WTF, throwable, message, Arrays.copyOf(args, args.length));
    }

    public final void wtf(@NotNull String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.doLog(LogLevel.WTF, null, message, Arrays.copyOf(args, args.length));
    }

    private final void doLog(LogLevel level, Throwable throwable, String message, Object ... args) {
        if (level.getPriority() >= this.logLevel.getPriority()) {
            Iterable $this$forEach$iv = this.loggers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RealmLogger it = (RealmLogger)element$iv;
                boolean bl = false;
                it.log(level, throwable, message, Arrays.copyOf(args, args.length));
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        RealmLog cfr_ignored_0 = (RealmLog)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)((RealmLog)other).tag)) {
            return false;
        }
        if (this.logLevel != ((RealmLog)other).logLevel) {
            return false;
        }
        return this.configuration.getLevel() == ((RealmLog)other).configuration.getLevel();
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = 31 * result + this.configuration.getLevel().hashCode();
        result = 31 * result + this.logLevel.hashCode();
        return result;
    }
}

