/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.BaseRealm;
import io.realm.Callback;
import io.realm.Cancellable;
import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.VersionId;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.Observable;
import io.realm.internal.RealmLog;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmState;
import io.realm.internal.RealmStateHolder;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 82\u00020\u00012\u00020\u0002:\u00018B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\r\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J&\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001e0\u001d\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001e0!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J9\u0010$\u001a\u00020%\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u001e0'2\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e0'0)H\u0010\u00a2\u0006\u0002\b*J1\u0010+\u001a\u00020%\"\b\b\u0000\u0010\u001e*\u00020\u001f2\u0006\u0010,\u001a\u0002H\u001e2\u000e\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001e0)H\u0010\u00a2\u0006\u0004\b-\u0010.J'\u0010/\u001a\b\u0012\u0004\u0012\u0002H\u001e00\"\u0004\b\u0000\u0010\u001e2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H\u001e02H\u0010\u00a2\u0006\u0002\b3J9\u00104\u001a\u00020%\"\b\b\u0000\u0010\u001e*\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u001e062\u0012\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001e060)H\u0010\u00a2\u0006\u0002\b7R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@PX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u00069"}, d2={"Lio/realm/internal/BaseRealmImpl;", "Lio/realm/BaseRealm;", "Lio/realm/internal/RealmStateHolder;", "configuration", "Lio/realm/internal/InternalConfiguration;", "dbPointer", "Lio/realm/internal/interop/NativePointer;", "(Lio/realm/internal/InternalConfiguration;Lio/realm/internal/interop/NativePointer;)V", "getConfiguration", "()Lio/realm/internal/InternalConfiguration;", "log", "Lio/realm/internal/RealmLog;", "getLog$library_base", "()Lio/realm/internal/RealmLog;", "_", "Lio/realm/internal/RealmReference;", "realmReference", "getRealmReference$library_base", "()Lio/realm/internal/RealmReference;", "setRealmReference$library_base", "(Lio/realm/internal/RealmReference;)V", "close", "", "close$library_base", "getNumberOfActiveVersions", "", "isClosed", "", "objects", "Lio/realm/RealmResults;", "T", "Lio/realm/RealmObject;", "clazz", "Lkotlin/reflect/KClass;", "realmState", "Lio/realm/internal/RealmState;", "registerListChangeListener", "Lio/realm/Cancellable;", "list", "", "callback", "Lio/realm/Callback;", "registerListChangeListener$library_base", "registerObjectChangeListener", "obj", "registerObjectChangeListener$library_base", "(Lio/realm/RealmObject;Lio/realm/Callback;)Lio/realm/Cancellable;", "registerObserver", "Lkotlinx/coroutines/flow/Flow;", "t", "Lio/realm/internal/Observable;", "registerObserver$library_base", "registerResultsChangeListener", "results", "Lio/realm/internal/RealmResultsImpl;", "registerResultsChangeListener$library_base", "Companion", "library-base"})
public abstract class BaseRealmImpl
implements BaseRealm,
RealmStateHolder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalConfiguration configuration;
    @NotNull
    private RealmReference realmReference;
    @NotNull
    private final RealmLog log;
    @Deprecated
    @NotNull
    private static final String OBSERVABLE_NOT_SUPPORTED_MESSAGE = "Observing changes are not supported by this Realm.";

    public BaseRealmImpl(@NotNull InternalConfiguration configuration, @NotNull NativePointer dbPointer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)dbPointer, (String)"dbPointer");
        this.configuration = configuration;
        this.realmReference = new RealmReference(this, dbPointer);
        this.log = new RealmLog(null, this.configuration.getLog(), 1, null);
        this.log.info(Intrinsics.stringPlus((String)"Realm opened: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @Override
    @NotNull
    public final InternalConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public RealmReference getRealmReference$library_base() {
        return this.realmReference;
    }

    public void setRealmReference$library_base(@NotNull RealmReference $noName_0) {
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        throw new UnsupportedOperationException("BaseRealm reference should never be updated");
    }

    @Override
    @NotNull
    public RealmState realmState() {
        return this.getRealmReference$library_base();
    }

    @Override
    public boolean isClosed() {
        return RealmStateHolder.DefaultImpls.isClosed(this);
    }

    @NotNull
    public final RealmLog getLog$library_base() {
        return this.log;
    }

    @NotNull
    public <T extends RealmObject> RealmResults<T> objects(@NotNull KClass<T> clazz) {
        RealmReference realmReference;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        RealmReference this_$iv = realmReference = this.getRealmReference$library_base();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        NativePointer nativePointer = realmReference.getDbPointer();
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return RealmResultsImpl.Companion.fromQuery$library_base(realmReference, RealmInterop.INSTANCE.realm_query_parse(nativePointer, string, "TRUEPREDICATE", new Object[0]), clazz, this.configuration.getMediator());
    }

    @NotNull
    public <T> Flow<T> registerObserver$library_base(@NotNull Observable<T> t) {
        Intrinsics.checkNotNullParameter(t, (String)"t");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerResultsChangeListener$library_base(@NotNull RealmResultsImpl<T> results, @NotNull Callback<RealmResultsImpl<T>> callback) {
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerListChangeListener$library_base(@NotNull List<? extends T> list, @NotNull Callback<List<T>> callback) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @NotNull
    public <T extends RealmObject> Cancellable registerObjectChangeListener$library_base(@NotNull T obj, @NotNull Callback<T> callback) {
        Intrinsics.checkNotNullParameter(obj, (String)"obj");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        throw new NotImplementedError(OBSERVABLE_NOT_SUPPORTED_MESSAGE);
    }

    @Override
    public long getNumberOfActiveVersions() {
        RealmReference reference;
        RealmReference this_$iv = reference = this.getRealmReference$library_base();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        return RealmInterop.INSTANCE.realm_get_num_versions(reference.getDbPointer());
    }

    public void close$library_base() {
        RealmReference reference;
        RealmReference this_$iv = reference = this.getRealmReference$library_base();
        boolean $i$f$checkClosed = false;
        if (this_$iv.isClosed()) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Realm has been closed and is no longer accessible: ", (Object)this_$iv.getOwner().getConfiguration().getPath()));
        }
        RealmInterop.INSTANCE.realm_close(reference.getDbPointer());
        this.log.info(Intrinsics.stringPlus((String)"Realm closed: ", (Object)this.configuration.getPath()), new Object[0]);
    }

    @Override
    @NotNull
    public VersionId version() {
        return RealmStateHolder.DefaultImpls.version(this);
    }

    @Override
    public boolean isFrozen() {
        return RealmStateHolder.DefaultImpls.isFrozen(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/internal/BaseRealmImpl$Companion;", "", "()V", "OBSERVABLE_NOT_SUPPORTED_MESSAGE", "", "library-base"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

