/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.platform;

import io.realm.log.LogLevel;
import io.realm.log.RealmLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\n\"\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JA\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\n\"\u0004\u0018\u00010\u000bH\u0016\u00a2\u0006\u0002\u0010\u0015J9\u0010\u0016\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u00032\u0016\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\n\"\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lio/realm/internal/platform/StdOutLogger;", "Lio/realm/log/RealmLogger;", "tag", "", "(Ljava/lang/String;)V", "getTag", "()Ljava/lang/String;", "formatMessage", "message", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getStackTraceString", "t", "", "log", "", "level", "Lio/realm/log/LogLevel;", "throwable", "(Lio/realm/log/LogLevel;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "prepareLogMessage", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Companion", "library-base"})
public final class StdOutLogger
implements RealmLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    public static final int INITIAL_BUFFER_SIZE = 256;

    public StdOutLogger(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
    }

    public /* synthetic */ StdOutLogger(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "REALM";
        }
        this(string);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public void log(@NotNull LogLevel level, @Nullable Throwable throwable, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String logMessage = this.prepareLogMessage(throwable, message, Arrays.copyOf(args, args.length));
        String string = level.name() + ": [" + this.getTag() + "] " + logMessage;
        boolean bl = false;
        System.out.println((Object)string);
    }

    private final String prepareLogMessage(Throwable throwable, String message, Object ... args) {
        String message2 = message;
        Object[] objectArray = (Object[])message2;
        boolean bl = false;
        boolean bl2 = false;
        if (objectArray == null || objectArray.length() == 0) {
            if (throwable == null) {
                return "";
            }
            message2 = this.getStackTraceString(throwable);
        } else {
            objectArray = args;
            bl = false;
            Object[] objectArray2 = objectArray;
            boolean bl3 = false;
            if (!(objectArray2.length == 0)) {
                message2 = this.formatMessage(message2, Arrays.copyOf(args, args.length));
            }
            if (throwable != null) {
                message2 = message2 + '\n' + this.getStackTraceString(throwable);
            }
        }
        return message2;
    }

    private final String formatMessage(String message, Object ... args) {
        String string = message;
        Object[] objectArray = Arrays.copyOf(args, args.length);
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    private final String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter((Writer)sw, false);
        t.printStackTrace(pw);
        pw.flush();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        return string;
    }

    @Override
    public void log(short level, @NotNull String message) {
        RealmLogger.DefaultImpls.log(this, level, message);
    }

    @Override
    public void log(@NotNull String message) {
        RealmLogger.DefaultImpls.log(this, message);
    }

    public StdOutLogger() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/realm/internal/platform/StdOutLogger$Companion;", "", "()V", "INITIAL_BUFFER_SIZE", "", "library-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

