/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.LogConfiguration;
import io.realm.RealmObject;
import io.realm.internal.RealmConfigurationImpl;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.platform.CoroutineUtilsJvmKt;
import io.realm.internal.platform.SystemUtilsJvmKt;
import io.realm.log.LogLevel;
import io.realm.log.RealmLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u0000 !2\u00020\u0001:\u0003 !\"R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R \u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006#"}, d2={"Lio/realm/RealmConfiguration;", "", "deleteRealmIfMigrationNeeded", "", "getDeleteRealmIfMigrationNeeded", "()Z", "encryptionKey", "", "getEncryptionKey", "()[B", "log", "Lio/realm/LogConfiguration;", "getLog", "()Lio/realm/LogConfiguration;", "maxNumberOfActiveVersions", "", "getMaxNumberOfActiveVersions", "()J", "name", "", "getName", "()Ljava/lang/String;", "path", "getPath", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "getSchema", "()Ljava/util/Set;", "schemaVersion", "getSchemaVersion", "Builder", "Companion", "SharedBuilder", "library-base"})
public interface RealmConfiguration {
    @NotNull
    public static final Companion Companion = io.realm.RealmConfiguration$Companion.$$INSTANCE;

    @NotNull
    public String getPath();

    @NotNull
    public String getName();

    @NotNull
    public Set<KClass<? extends RealmObject>> getSchema();

    @NotNull
    public LogConfiguration getLog();

    public long getMaxNumberOfActiveVersions();

    public long getSchemaVersion();

    public boolean getDeleteRealmIfMigrationNeeded();

    @Nullable
    public byte[] getEncryptionKey();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a8\u0006\t"}, d2={"Lio/realm/RealmConfiguration$Companion;", "", "()V", "with", "Lio/realm/RealmConfiguration;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "library-base"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final RealmConfiguration with(@NotNull Set<? extends KClass<? extends RealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            String message$iv = "This code should have been replaced by the Realm Compiler Plugin. Has the `realm-kotlin` Gradle plugin been applied to the project?";
            boolean $i$f$REPLACED_BY_IR = false;
            throw new AssertionError((Object)message$iv);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0011\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u00020\u0003B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u000b\u0010C\u001a\u00028\u0000\u00a2\u0006\u0002\u0010DJ\u000b\u0010\t\u001a\u00028\u0001\u00a2\u0006\u0002\u0010EJ\u0013\u0010\u000f\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010FJ%\u0010G\u001a\u00028\u00012\b\b\u0002\u0010H\u001a\u00020\u00162\u000e\b\u0002\u0010I\u001a\b\u0012\u0004\u0012\u00020;0:\u00a2\u0006\u0002\u0010JJ\u0015\u0010\u001b\u001a\u00028\u00012\b\b\u0002\u0010K\u001a\u00020\u001c\u00a2\u0006\u0002\u0010LJ\u0013\u0010!\u001a\u00028\u00012\u0006\u0010!\u001a\u00020\"\u00a2\u0006\u0002\u0010MJ\u0017\u0010'\u001a\u00028\u00012\u0006\u0010N\u001a\u00020(H\u0000\u00a2\u0006\u0004\bO\u0010PJ\u0015\u0010-\u001a\u00028\u00012\b\u0010-\u001a\u0004\u0018\u00010\"\u00a2\u0006\u0002\u0010MJ\u000f\u00100\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\bQ\u0010EJ/\u0010\u0004\u001a\u00028\u00012\"\u0010R\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060S\"\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010TJ!\u0010\u0004\u001a\u00028\u00012\u0014\u0010R\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010UJ\u0013\u00106\u001a\u00028\u00012\u0006\u00106\u001a\u00020\u001c\u00a2\u0006\u0002\u0010LJ\u0010\u0010V\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0017\u0010@\u001a\u00028\u00012\u0006\u0010N\u001a\u00020(H\u0000\u00a2\u0006\u0004\bW\u0010PR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&R\u001a\u00100\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\f\"\u0004\b2\u0010\u000eR(\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u0010\bR\u001a\u00106\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001e\"\u0004\b8\u0010 R \u00109\u001a\b\u0012\u0004\u0012\u00020;0:X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010(X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010*\"\u0004\bB\u0010,\u00a8\u0006X"}, d2={"Lio/realm/RealmConfiguration$SharedBuilder;", "T", "S", "", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "(Ljava/util/Set;)V", "deleteRealmIfMigrationNeeded", "", "getDeleteRealmIfMigrationNeeded", "()Z", "setDeleteRealmIfMigrationNeeded", "(Z)V", "encryptionKey", "", "getEncryptionKey", "()[B", "setEncryptionKey", "([B)V", "logLevel", "Lio/realm/log/LogLevel;", "getLogLevel", "()Lio/realm/log/LogLevel;", "setLogLevel", "(Lio/realm/log/LogLevel;)V", "maxNumberOfActiveVersions", "", "getMaxNumberOfActiveVersions", "()J", "setMaxNumberOfActiveVersions", "(J)V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "notificationDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getNotificationDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "setNotificationDispatcher", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "path", "getPath", "setPath", "removeSystemLogger", "getRemoveSystemLogger", "setRemoveSystemLogger", "getSchema", "()Ljava/util/Set;", "setSchema", "schemaVersion", "getSchemaVersion", "setSchemaVersion", "userLoggers", "", "Lio/realm/log/RealmLogger;", "getUserLoggers", "()Ljava/util/List;", "setUserLoggers", "(Ljava/util/List;)V", "writeDispatcher", "getWriteDispatcher", "setWriteDispatcher", "build", "()Ljava/lang/Object;", "()Lio/realm/RealmConfiguration$SharedBuilder;", "([B)Lio/realm/RealmConfiguration$SharedBuilder;", "log", "level", "customLoggers", "(Lio/realm/log/LogLevel;Ljava/util/List;)Lio/realm/RealmConfiguration$SharedBuilder;", "maxVersions", "(J)Lio/realm/RealmConfiguration$SharedBuilder;", "(Ljava/lang/String;)Lio/realm/RealmConfiguration$SharedBuilder;", "dispatcher", "notificationDispatcher$library_base", "(Lkotlinx/coroutines/CoroutineDispatcher;)Lio/realm/RealmConfiguration$SharedBuilder;", "removeSystemLogger$library_base", "classes", "", "([Lkotlin/reflect/KClass;)Lio/realm/RealmConfiguration$SharedBuilder;", "(Ljava/util/Set;)Lio/realm/RealmConfiguration$SharedBuilder;", "validateEncryptionKey", "writeDispatcher$library_base", "library-base"})
    public static abstract class SharedBuilder<T, S extends SharedBuilder<T, S>> {
        @NotNull
        private Set<? extends KClass<? extends RealmObject>> schema;
        @Nullable
        private String path;
        @NotNull
        private String name;
        @NotNull
        private LogLevel logLevel;
        private boolean removeSystemLogger;
        @NotNull
        private List<? extends RealmLogger> userLoggers;
        private long maxNumberOfActiveVersions;
        @Nullable
        private CoroutineDispatcher notificationDispatcher;
        @Nullable
        private CoroutineDispatcher writeDispatcher;
        private boolean deleteRealmIfMigrationNeeded;
        private long schemaVersion;
        @Nullable
        private byte[] encryptionKey;

        public SharedBuilder(@NotNull Set<? extends KClass<? extends RealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.schema = schema;
            this.name = "default.realm";
            this.logLevel = LogLevel.WARN;
            boolean bl = false;
            this.userLoggers = CollectionsKt.emptyList();
            this.maxNumberOfActiveVersions = Long.MAX_VALUE;
        }

        public /* synthetic */ SharedBuilder(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                set = SetsKt.emptySet();
            }
            this(set);
        }

        @NotNull
        public final Set<KClass<? extends RealmObject>> getSchema() {
            return this.schema;
        }

        public final void setSchema(@NotNull Set<? extends KClass<? extends RealmObject>> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.schema = set;
        }

        @Nullable
        protected final String getPath() {
            return this.path;
        }

        protected final void setPath(@Nullable String string) {
            this.path = string;
        }

        @NotNull
        protected final String getName() {
            return this.name;
        }

        protected final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        protected final LogLevel getLogLevel() {
            return this.logLevel;
        }

        protected final void setLogLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
            this.logLevel = logLevel;
        }

        protected final boolean getRemoveSystemLogger() {
            return this.removeSystemLogger;
        }

        protected final void setRemoveSystemLogger(boolean bl) {
            this.removeSystemLogger = bl;
        }

        @NotNull
        protected final List<RealmLogger> getUserLoggers() {
            return this.userLoggers;
        }

        protected final void setUserLoggers(@NotNull List<? extends RealmLogger> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.userLoggers = list;
        }

        protected final long getMaxNumberOfActiveVersions() {
            return this.maxNumberOfActiveVersions;
        }

        protected final void setMaxNumberOfActiveVersions(long l) {
            this.maxNumberOfActiveVersions = l;
        }

        @Nullable
        protected final CoroutineDispatcher getNotificationDispatcher() {
            return this.notificationDispatcher;
        }

        protected final void setNotificationDispatcher(@Nullable CoroutineDispatcher coroutineDispatcher) {
            this.notificationDispatcher = coroutineDispatcher;
        }

        @Nullable
        protected final CoroutineDispatcher getWriteDispatcher() {
            return this.writeDispatcher;
        }

        protected final void setWriteDispatcher(@Nullable CoroutineDispatcher coroutineDispatcher) {
            this.writeDispatcher = coroutineDispatcher;
        }

        protected final boolean getDeleteRealmIfMigrationNeeded() {
            return this.deleteRealmIfMigrationNeeded;
        }

        protected final void setDeleteRealmIfMigrationNeeded(boolean bl) {
            this.deleteRealmIfMigrationNeeded = bl;
        }

        protected final long getSchemaVersion() {
            return this.schemaVersion;
        }

        protected final void setSchemaVersion(long l) {
            this.schemaVersion = l;
        }

        @Nullable
        protected final byte[] getEncryptionKey() {
            return this.encryptionKey;
        }

        protected final void setEncryptionKey(@Nullable byte[] byArray) {
            this.encryptionKey = byArray;
        }

        public final T build() {
            String message$iv = "This code should have been replaced by the Realm Compiler Plugin. Has the `realm-kotlin` Gradle plugin been applied to the project?";
            boolean $i$f$REPLACED_BY_IR = false;
            throw new AssertionError((Object)message$iv);
        }

        @NotNull
        public final S path(@Nullable String path) {
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$path_u24lambda_u2d0 = sharedBuilder;
            boolean bl3 = false;
            $this$path_u24lambda_u2d0.setPath(path);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S name(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$name_u24lambda_u2d1 = sharedBuilder;
            boolean bl3 = false;
            $this$name_u24lambda_u2d1.setName(name);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S schema(@NotNull Set<? extends KClass<? extends RealmObject>> classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$schema_u24lambda_u2d2 = sharedBuilder;
            boolean bl3 = false;
            $this$schema_u24lambda_u2d2.setSchema(classes);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S schema(KClass<? extends RealmObject> ... classes) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$schema_u24lambda_u2d3 = sharedBuilder;
            boolean bl3 = false;
            $this$schema_u24lambda_u2d3.setSchema(SetsKt.setOf((Object[])Arrays.copyOf(classes, classes.length)));
            return (S)sharedBuilder;
        }

        @NotNull
        public final S maxNumberOfActiveVersions(long maxVersions) {
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$maxNumberOfActiveVersions_u24lambda_u2d4 = sharedBuilder;
            boolean bl3 = false;
            if (maxVersions < 1L) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Only positive numbers above 0 are allowed. Yours was: ", (Object)maxVersions));
            }
            $this$maxNumberOfActiveVersions_u24lambda_u2d4.setMaxNumberOfActiveVersions(maxVersions);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder maxNumberOfActiveVersions$default(SharedBuilder sharedBuilder, long l, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maxNumberOfActiveVersions");
            }
            if ((n & 1) != 0) {
                l = 8L;
            }
            return sharedBuilder.maxNumberOfActiveVersions(l);
        }

        @NotNull
        public final S log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$log_u24lambda_u2d5 = sharedBuilder;
            boolean bl3 = false;
            $this$log_u24lambda_u2d5.setLogLevel(level);
            $this$log_u24lambda_u2d5.setUserLoggers(customLoggers);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder log$default(SharedBuilder sharedBuilder, LogLevel logLevel, List list, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
            }
            if ((n & 1) != 0) {
                logLevel = LogLevel.WARN;
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return sharedBuilder.log(logLevel, list);
        }

        @NotNull
        public final S notificationDispatcher$library_base(@NotNull CoroutineDispatcher dispatcher) {
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$notificationDispatcher_u24lambda_u2d6 = sharedBuilder;
            boolean bl3 = false;
            $this$notificationDispatcher_u24lambda_u2d6.setNotificationDispatcher(dispatcher);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S writeDispatcher$library_base(@NotNull CoroutineDispatcher dispatcher) {
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$writeDispatcher_u24lambda_u2d7 = sharedBuilder;
            boolean bl3 = false;
            $this$writeDispatcher_u24lambda_u2d7.setWriteDispatcher(dispatcher);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S deleteRealmIfMigrationNeeded() {
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$deleteRealmIfMigrationNeeded_u24lambda_u2d8 = sharedBuilder;
            boolean bl3 = false;
            $this$deleteRealmIfMigrationNeeded_u24lambda_u2d8.setDeleteRealmIfMigrationNeeded(true);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S schemaVersion(long schemaVersion) {
            if (schemaVersion < 0L) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Realm schema version numbers must be 0 (zero) or higher. Yours was: ", (Object)schemaVersion));
            }
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$schemaVersion_u24lambda_u2d9 = sharedBuilder;
            boolean bl3 = false;
            $this$schemaVersion_u24lambda_u2d9.setSchemaVersion(schemaVersion);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S encryptionKey(@NotNull byte[] encryptionKey) {
            Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$encryptionKey_u24lambda_u2d10 = sharedBuilder;
            boolean bl3 = false;
            $this$encryptionKey_u24lambda_u2d10.setEncryptionKey($this$encryptionKey_u24lambda_u2d10.validateEncryptionKey(encryptionKey));
            return (S)sharedBuilder;
        }

        @NotNull
        public final S removeSystemLogger$library_base() {
            SharedBuilder sharedBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            SharedBuilder $this$removeSystemLogger_u24lambda_u2d11 = sharedBuilder;
            boolean bl3 = false;
            $this$removeSystemLogger_u24lambda_u2d11.setRemoveSystemLogger(true);
            return (S)sharedBuilder;
        }

        @NotNull
        protected final byte[] validateEncryptionKey(@NotNull byte[] encryptionKey) {
            Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
            if (encryptionKey.length != 64) {
                throw new IllegalArgumentException("The provided key must be 64 bytes. The provided key was " + encryptionKey.length + " bytes.");
            }
            return encryptionKey;
        }

        public SharedBuilder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J)\u0010\b\u001a\u00020\u00022\u001a\u0010\t\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lio/realm/RealmConfiguration$Builder;", "Lio/realm/RealmConfiguration$SharedBuilder;", "Lio/realm/RealmConfiguration;", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "(Ljava/util/Set;)V", "build", "companionMap", "", "Lio/realm/internal/RealmObjectCompanion;", "build$library_base", "library-base"})
    public static final class Builder
    extends SharedBuilder<RealmConfiguration, Builder> {
        public Builder(@NotNull Set<? extends KClass<? extends RealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            super(schema);
        }

        public /* synthetic */ Builder(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                set = SetsKt.emptySet();
            }
            this(set);
        }

        @NotNull
        public final RealmConfiguration build$library_base(@NotNull Map<KClass<? extends RealmObject>, ? extends RealmObjectCompanion> companionMap) {
            Intrinsics.checkNotNullParameter(companionMap, (String)"companionMap");
            boolean bl = false;
            List allLoggers = new ArrayList();
            if (!this.getRemoveSystemLogger()) {
                allLoggers.add(SystemUtilsJvmKt.createDefaultSystemLogger("REALM"));
            }
            allLoggers.addAll((Collection)this.getUserLoggers());
            CoroutineDispatcher coroutineDispatcher = this.getNotificationDispatcher();
            CoroutineDispatcher coroutineDispatcher2 = coroutineDispatcher == null ? CoroutineUtilsJvmKt.singleThreadDispatcher(this.getName()) : coroutineDispatcher;
            coroutineDispatcher = this.getWriteDispatcher();
            return new RealmConfigurationImpl(companionMap, this.getPath(), this.getName(), this.getSchema(), new LogConfiguration(this.getLogLevel(), allLoggers), this.getMaxNumberOfActiveVersions(), coroutineDispatcher2, coroutineDispatcher == null ? CoroutineUtilsJvmKt.singleThreadDispatcher(this.getName()) : coroutineDispatcher, this.getSchemaVersion(), this.getDeleteRealmIfMigrationNeeded(), this.getEncryptionKey());
        }

        public Builder() {
            this(null, 1, null);
        }
    }
}

