/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.query;

import io.realm.RealmObject;
import io.realm.RealmResults;
import io.realm.internal.Flowable;
import io.realm.internal.InternalDeleteable;
import io.realm.internal.InternalDeleteableKt;
import io.realm.internal.Mediator;
import io.realm.internal.Observable;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmResultsImpl;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.RealmValueArgumentConverter;
import io.realm.internal.Thawable;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmCoreIndexOutOfBoundsException;
import io.realm.internal.interop.RealmCoreInvalidQueryException;
import io.realm.internal.interop.RealmCoreInvalidQueryStringException;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.interop.RealmQueryT;
import io.realm.internal.interop.RealmResultsT;
import io.realm.internal.query.AggregatorQueryType;
import io.realm.internal.query.CountQuery;
import io.realm.internal.query.MinMaxQuery;
import io.realm.internal.query.QueryUtilsKt;
import io.realm.internal.query.SingleQuery;
import io.realm.internal.query.SumQuery;
import io.realm.notifications.ResultsChange;
import io.realm.query.RealmQuery;
import io.realm.query.RealmScalarNullableQuery;
import io.realm.query.RealmScalarQuery;
import io.realm.query.RealmSingleQuery;
import io.realm.query.Sort;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042 \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\b0\u00060\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\b0\tB+\b\u0016\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000fBf\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bj\u0004\u0018\u0001`\r\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0016\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0014\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0)H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0016J\b\u0010-\u001a\u00020.H\u0016J/\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00100\u001a\u00020\u00192\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u001b\"\u00020\u0019H\u0016\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00028\u000004H\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00028\u000006H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00107\u001a\u000208H\u0016J.\u00109\u001a\b\u0012\u0004\u0012\u0002H;0:\"\b\b\u0001\u0010;*\u00020\u001c2\u0006\u00100\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0\u0015H\u0016J.\u0010=\u001a\b\u0012\u0004\u0012\u0002H;0:\"\b\b\u0001\u0010;*\u00020\u001c2\u0006\u00100\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0\u0015H\u0016J\u0012\u0010>\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rH\u0002J3\u0010?\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010@\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001b\"\u0004\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010AJS\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020E0D2*\u0010F\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020E0D0\u001b\"\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020E0DH\u0016\u00a2\u0006\u0002\u0010GJ\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\u0006\u00100\u001a\u00020\u00192\u0006\u0010H\u001a\u00020EH\u0016J.\u0010I\u001a\b\u0012\u0004\u0012\u0002H;0+\"\b\b\u0001\u0010;*\u00020\u001c2\u0006\u00100\u001a\u00020\u00192\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0\u0015H\u0016J\u0016\u0010J\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010K\u001a\u00020\u0011H\u0016J*\u0010L\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0016\u0010M\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r0NH\u0002R\u001a\u0010\u001a\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u0019\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010!\u001a\f\u0012\u0004\u0012\u00020\"0\u000bj\u0002`#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b$\u0010%\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006O"}, d2={"Lio/realm/internal/query/ObjectQuery;", "E", "Lio/realm/RealmObject;", "Lio/realm/query/RealmQuery;", "Lio/realm/internal/InternalDeleteable;", "Lio/realm/internal/Thawable;", "Lio/realm/internal/Observable;", "Lio/realm/internal/RealmResultsImpl;", "Lio/realm/notifications/ResultsChange;", "Lio/realm/internal/Flowable;", "composedQueryPointer", "Lio/realm/internal/interop/NativePointer;", "Lio/realm/internal/interop/RealmQueryT;", "Lio/realm/internal/interop/RealmQueryPointer;", "objectQuery", "(Lio/realm/internal/interop/NativePointer;Lio/realm/internal/query/ObjectQuery;)V", "realmReference", "Lio/realm/internal/RealmReference;", "classKey", "Lio/realm/internal/interop/ClassKey;", "clazz", "Lkotlin/reflect/KClass;", "mediator", "Lio/realm/internal/Mediator;", "filter", "", "args", "", "", "(Lio/realm/internal/RealmReference;JLkotlin/reflect/KClass;Lio/realm/internal/Mediator;Lio/realm/internal/interop/NativePointer;Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "[Ljava/lang/Object;", "J", "queryPointer", "resultsPointer", "Lio/realm/internal/interop/RealmResultsT;", "Lio/realm/internal/interop/RealmResultsPointer;", "getResultsPointer", "()Lio/realm/internal/interop/NativePointer;", "resultsPointer$delegate", "Lkotlin/Lazy;", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "count", "Lio/realm/query/RealmScalarQuery;", "", "delete", "", "distinct", "property", "extraProperties", "(Ljava/lang/String;[Ljava/lang/String;)Lio/realm/query/RealmQuery;", "find", "Lio/realm/RealmResults;", "first", "Lio/realm/query/RealmSingleQuery;", "limit", "", "max", "Lio/realm/query/RealmScalarNullableQuery;", "T", "type", "min", "parseQuery", "query", "arguments", "(Ljava/lang/String;[Ljava/lang/Object;)Lio/realm/query/RealmQuery;", "sort", "propertyAndSortOrder", "Lkotlin/Pair;", "Lio/realm/query/Sort;", "additionalPropertiesAndOrders", "(Lkotlin/Pair;[Lkotlin/Pair;)Lio/realm/query/RealmQuery;", "sortOrder", "sum", "thaw", "liveRealm", "tryCatchCoreException", "block", "Lkotlin/Function0;", "io.realm.kotlin.library"})
public final class ObjectQuery<E extends RealmObject>
implements RealmQuery<E>,
InternalDeleteable,
Thawable<Observable<RealmResultsImpl<E>, ResultsChange<E>>>,
Flowable<ResultsChange<E>> {
    @NotNull
    private final RealmReference realmReference;
    private final long classKey;
    @NotNull
    private final KClass<E> clazz;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final String filter;
    @NotNull
    private final Object[] args;
    @NotNull
    private final NativePointer<RealmQueryT> queryPointer;
    @NotNull
    private final Lazy resultsPointer$delegate;

    private ObjectQuery(RealmReference realmReference2, long classKey, KClass<E> clazz, Mediator mediator, NativePointer<RealmQueryT> composedQueryPointer, String filter2, Object ... args) {
        this.realmReference = realmReference2;
        this.classKey = classKey;
        this.clazz = clazz;
        this.mediator = mediator;
        this.filter = filter2;
        this.args = args;
        this.queryPointer = composedQueryPointer != null ? composedQueryPointer : this.parseQuery();
        this.resultsPointer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NativePointer<RealmResultsT>>(this){
            final /* synthetic */ ObjectQuery<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer<RealmResultsT> invoke() {
                return RealmInterop.INSTANCE.realm_query_find_all(ObjectQuery.access$getQueryPointer$p(this.this$0));
            }
        }));
    }

    public /* synthetic */ ObjectQuery(RealmReference realmReference2, long l, KClass kClass, Mediator mediator, NativePointer nativePointer, String string, Object[] objectArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            nativePointer = null;
        }
        this(realmReference2, l, kClass, mediator, nativePointer, string, objectArray, null);
    }

    private final NativePointer<RealmResultsT> getResultsPointer() {
        Lazy lazy = this.resultsPointer$delegate;
        return (NativePointer)lazy.getValue();
    }

    public ObjectQuery(@Nullable NativePointer<RealmQueryT> composedQueryPointer, @NotNull ObjectQuery<E> objectQuery) {
        Intrinsics.checkNotNullParameter(objectQuery, (String)"objectQuery");
        Object[] objectArray = objectQuery.args;
        this(objectQuery.realmReference, objectQuery.classKey, objectQuery.clazz, objectQuery.mediator, composedQueryPointer, objectQuery.filter, Arrays.copyOf(objectArray, objectArray.length), null);
    }

    @Override
    @NotNull
    public RealmResults<E> find() {
        return new RealmResultsImpl(this.realmReference, this.getResultsPointer(), this.classKey, this.clazz, this.mediator, null, 32, null);
    }

    @Override
    @NotNull
    public RealmQuery<E> query(@NotNull String filter2, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        NativePointer<RealmQueryT> appendedQuery2 = this.tryCatchCoreException((Function0<NativePointer<RealmQueryT>>)((Function0)new Function0<NativePointer<RealmQueryT>>(this, filter2, arguments){
            final /* synthetic */ ObjectQuery<E> this$0;
            final /* synthetic */ String $filter;
            final /* synthetic */ Object[] $arguments;
            {
                this.this$0 = $receiver;
                this.$filter = $filter;
                this.$arguments = $arguments;
                super(0);
            }

            @NotNull
            public final NativePointer<RealmQueryT> invoke() {
                return RealmInterop.INSTANCE.realm_query_append_query(ObjectQuery.access$getQueryPointer$p(this.this$0), this.$filter, RealmValueArgumentConverter.INSTANCE.convertArgs(this.$arguments));
            }
        }));
        return new ObjectQuery<E>(appendedQuery2, this);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull String property, @NotNull Sort sortOrder) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        return this.query("TRUEPREDICATE SORT(" + property + ' ' + sortOrder.name() + ')', new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> sort(@NotNull Pair<String, ? extends Sort> propertyAndSortOrder, Pair<String, ? extends Sort> ... additionalPropertiesAndOrders) {
        Intrinsics.checkNotNullParameter(propertyAndSortOrder, (String)"propertyAndSortOrder");
        Intrinsics.checkNotNullParameter(additionalPropertiesAndOrders, (String)"additionalPropertiesAndOrders");
        String property = (String)propertyAndSortOrder.component1();
        Sort order = (Sort)((Object)propertyAndSortOrder.component2());
        StringBuilder stringBuilder = new StringBuilder().append("TRUEPREDICATE SORT(" + property + ' ' + (Object)((Object)order));
        Pair<String, ? extends Sort>[] $this$forEach$iv = additionalPropertiesAndOrders;
        boolean $i$f$forEach = false;
        for (Pair<String, ? extends Sort> element$iv : $this$forEach$iv) {
            Pair<String, ? extends Sort> $dstr$extraProperty$extraOrder = element$iv;
            boolean bl = false;
            String extraProperty = (String)$dstr$extraProperty$extraOrder.component1();
            Sort extraOrder = (Sort)((Object)$dstr$extraProperty$extraOrder.component2());
            stringBuilder.append(", " + extraProperty + ' ' + (Object)((Object)extraOrder));
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return this.query(string, new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> distinct(@NotNull String property, String ... extraProperties) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)extraProperties, (String)"extraProperties");
        StringBuilder stringBuilder = new StringBuilder().append(Intrinsics.stringPlus((String)"TRUEPREDICATE DISTINCT(", (Object)property));
        String[] $this$forEach$iv = extraProperties;
        boolean $i$f$forEach = false;
        for (String element$iv : $this$forEach$iv) {
            String extraProperty = element$iv;
            boolean bl = false;
            stringBuilder.append(Intrinsics.stringPlus((String)", ", (Object)extraProperty));
        }
        stringBuilder.append(")");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return this.query(string, new Object[0]);
    }

    @Override
    @NotNull
    public RealmQuery<E> limit(int limit) {
        return this.query("TRUEPREDICATE LIMIT(" + limit + ')', new Object[0]);
    }

    @Override
    @NotNull
    public RealmSingleQuery<E> first() {
        return new SingleQuery(this.realmReference, this.queryPointer, this.classKey, this.clazz, this.mediator, null);
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> min(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new MinMaxQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, property, type, AggregatorQueryType.MIN, null);
    }

    @Override
    @NotNull
    public <T> RealmScalarNullableQuery<T> max(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new MinMaxQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, property, type, AggregatorQueryType.MAX, null);
    }

    @Override
    @NotNull
    public <T> RealmScalarQuery<T> sum(@NotNull String property, @NotNull KClass<T> type) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return new SumQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, property, type, null);
    }

    @Override
    @NotNull
    public RealmScalarQuery<Long> count() {
        return new CountQuery(this.realmReference, this.queryPointer, this.mediator, this.classKey, this.clazz, null);
    }

    @Override
    @NotNull
    public RealmResultsImpl<E> thaw(@NotNull RealmReference liveRealm) {
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        return QueryUtilsKt.thawResults-2UCwr2U(liveRealm, this.getResultsPointer(), this.classKey, this.clazz, this.mediator);
    }

    @Override
    @NotNull
    public Flow<ResultsChange<E>> asFlow() {
        this.realmReference.checkClosed();
        return this.realmReference.getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    public void delete() {
        InternalDeleteableKt.asInternalDeleteable(this.find()).delete();
    }

    private final NativePointer<RealmQueryT> parseQuery() {
        return this.tryCatchCoreException((Function0<NativePointer<RealmQueryT>>)((Function0)new Function0<NativePointer<RealmQueryT>>(this){
            final /* synthetic */ ObjectQuery<E> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NativePointer<RealmQueryT> invoke() {
                return RealmInterop.INSTANCE.realm_query_parse-PJ50JmE(ObjectQuery.access$getRealmReference$p(this.this$0).getDbPointer(), ObjectQuery.access$getClassKey$p(this.this$0), ObjectQuery.access$getFilter$p(this.this$0), RealmValueArgumentConverter.INSTANCE.convertArgs(ObjectQuery.access$getArgs$p(this.this$0)));
            }
        }));
    }

    private final NativePointer<RealmQueryT> tryCatchCoreException(Function0<? extends NativePointer<RealmQueryT>> block) {
        NativePointer nativePointer;
        try {
            nativePointer = (NativePointer)block.invoke();
        }
        catch (RealmCoreException exception) {
            RealmCoreException realmCoreException = exception;
            throw realmCoreException instanceof RealmCoreInvalidQueryStringException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Wrong query string: ", (Object)exception.getMessage())) : (realmCoreException instanceof RealmCoreInvalidQueryException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Wrong query field provided or malformed syntax in query: ", (Object)exception.getMessage())) : (realmCoreException instanceof RealmCoreIndexOutOfBoundsException ? (Throwable)new IllegalArgumentException(Intrinsics.stringPlus((String)"Have you specified all parameters in your query?: ", (Object)exception.getMessage())) : RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Invalid syntax in query: ", (Object)exception.getMessage()), exception)));
        }
        return nativePointer;
    }

    public /* synthetic */ ObjectQuery(RealmReference realmReference2, long classKey, KClass clazz, Mediator mediator, NativePointer composedQueryPointer, String filter2, Object[] args, DefaultConstructorMarker $constructor_marker) {
        this(realmReference2, classKey, clazz, mediator, (NativePointer<RealmQueryT>)composedQueryPointer, filter2, args);
    }

    public static final /* synthetic */ NativePointer access$getQueryPointer$p(ObjectQuery $this) {
        return $this.queryPointer;
    }

    public static final /* synthetic */ RealmReference access$getRealmReference$p(ObjectQuery $this) {
        return $this.realmReference;
    }

    public static final /* synthetic */ long access$getClassKey$p(ObjectQuery $this) {
        return $this.classKey;
    }

    public static final /* synthetic */ String access$getFilter$p(ObjectQuery $this) {
        return $this.filter;
    }

    public static final /* synthetic */ Object[] access$getArgs$p(ObjectQuery $this) {
        return $this.args;
    }
}

