/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.CompactOnLaunchCallback;
import io.realm.LogConfiguration;
import io.realm.RealmObject;
import io.realm.dynamic.DynamicMutableRealm;
import io.realm.dynamic.DynamicMutableRealmObject;
import io.realm.dynamic.DynamicRealm;
import io.realm.dynamic.DynamicRealmObject;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.Mediator;
import io.realm.internal.RealmObjectCompanion;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.dynamic.DynamicMutableRealmImpl;
import io.realm.internal.dynamic.DynamicMutableRealmObjectImpl;
import io.realm.internal.dynamic.DynamicRealmImpl;
import io.realm.internal.dynamic.DynamicRealmObjectImpl;
import io.realm.internal.interop.FrozenRealmT;
import io.realm.internal.interop.LiveRealmT;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmConfigT;
import io.realm.internal.interop.RealmInterop;
import io.realm.internal.interop.SchemaMode;
import io.realm.internal.platform.RealmObjectKt;
import io.realm.internal.platform.SystemUtilsJvmKt;
import io.realm.internal.platform.SystemUtilsKt;
import io.realm.internal.schema.RealmClassImpl;
import io.realm.migration.AutomaticSchemaMigration;
import io.realm.migration.RealmMigration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010>\u001a\u00020\u00032\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u0003H\u0002R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R(\u0010!\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020#0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001e\u0010.\u001a\f\u0012\u0004\u0012\u0002000/j\u0002`1X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010-R\"\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010\u0010\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010'R\u0014\u0010\u000f\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00105\u00a8\u0006A"}, d2={"Lio/realm/internal/ConfigurationImpl;", "Lio/realm/internal/InternalConfiguration;", "directory", "", "name", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "logConfig", "Lio/realm/LogConfiguration;", "maxNumberOfActiveVersions", "", "notificationDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "writeDispatcher", "schemaVersion", "schemaMode", "Lio/realm/internal/interop/SchemaMode;", "encryptionKey", "", "compactOnLaunchCallback", "Lio/realm/CompactOnLaunchCallback;", "migration", "Lio/realm/migration/RealmMigration;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lio/realm/LogConfiguration;JLkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;JLio/realm/internal/interop/SchemaMode;[BLio/realm/CompactOnLaunchCallback;Lio/realm/migration/RealmMigration;)V", "getCompactOnLaunchCallback", "()Lio/realm/CompactOnLaunchCallback;", "getEncryptionKey", "()[B", "log", "getLog", "()Lio/realm/LogConfiguration;", "mapOfKClassWithCompanion", "", "Lio/realm/internal/RealmObjectCompanion;", "getMapOfKClassWithCompanion", "()Ljava/util/Map;", "getMaxNumberOfActiveVersions", "()J", "mediator", "Lio/realm/internal/Mediator;", "getMediator", "()Lio/realm/internal/Mediator;", "getName", "()Ljava/lang/String;", "nativeConfig", "Lio/realm/internal/interop/NativePointer;", "Lio/realm/internal/interop/RealmConfigT;", "Lio/realm/internal/interop/RealmConfigurationPointer;", "getNativeConfig", "()Lio/realm/internal/interop/NativePointer;", "getNotificationDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "path", "getPath", "getSchema", "()Ljava/util/Set;", "getSchemaMode", "()Lio/realm/internal/interop/SchemaMode;", "getSchemaVersion", "getWriteDispatcher", "normalizePath", "directoryPath", "fileName", "io.realm.kotlin.library"})
public class ConfigurationImpl
implements InternalConfiguration {
    @NotNull
    private final String path;
    @NotNull
    private final String name;
    @NotNull
    private final Set<KClass<? extends RealmObject>> schema;
    @NotNull
    private final LogConfiguration log;
    private final long maxNumberOfActiveVersions;
    private final long schemaVersion;
    @NotNull
    private final SchemaMode schemaMode;
    @NotNull
    private final Map<KClass<? extends RealmObject>, RealmObjectCompanion> mapOfKClassWithCompanion;
    @NotNull
    private final Mediator mediator;
    @NotNull
    private final NativePointer<RealmConfigT> nativeConfig;
    @NotNull
    private final CoroutineDispatcher notificationDispatcher;
    @NotNull
    private final CoroutineDispatcher writeDispatcher;
    @Nullable
    private final CompactOnLaunchCallback compactOnLaunchCallback;

    /*
     * WARNING - void declaration
     */
    public ConfigurationImpl(@NotNull String directory, @NotNull String name, @NotNull Set<? extends KClass<? extends RealmObject>> schema, @NotNull LogConfiguration logConfig, long maxNumberOfActiveVersions, @NotNull CoroutineDispatcher notificationDispatcher, @NotNull CoroutineDispatcher writeDispatcher, long schemaVersion, @NotNull SchemaMode schemaMode, @Nullable byte[] encryptionKey, @Nullable CompactOnLaunchCallback compactOnLaunchCallback, @Nullable RealmMigration migration) {
        Object it;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)logConfig, (String)"logConfig");
        Intrinsics.checkNotNullParameter((Object)notificationDispatcher, (String)"notificationDispatcher");
        Intrinsics.checkNotNullParameter((Object)writeDispatcher, (String)"writeDispatcher");
        Intrinsics.checkNotNullParameter((Object)schemaMode, (String)"schemaMode");
        this.nativeConfig = RealmInterop.INSTANCE.realm_config_new();
        this.path = this.normalizePath(directory, name);
        this.name = name;
        this.schema = schema;
        Iterable iterable = schema;
        ConfigurationImpl configurationImpl = this;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it2;
            KClass kClass = (KClass)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            RealmObjectCompanion realmObjectCompanion = RealmObjectKt.realmObjectCompanionOrThrow(it2);
            object.put(t, realmObjectCompanion);
        }
        configurationImpl.mapOfKClassWithCompanion = result$iv;
        this.log = logConfig;
        this.maxNumberOfActiveVersions = maxNumberOfActiveVersions;
        this.notificationDispatcher = notificationDispatcher;
        this.writeDispatcher = writeDispatcher;
        this.schemaVersion = schemaVersion;
        this.schemaMode = schemaMode;
        this.compactOnLaunchCallback = compactOnLaunchCallback;
        RealmInterop.INSTANCE.realm_config_set_path(this.getNativeConfig(), this.getPath());
        RealmInterop.INSTANCE.realm_config_set_schema_mode(this.getNativeConfig(), schemaMode);
        RealmInterop.INSTANCE.realm_config_set_schema_version(this.getNativeConfig(), schemaVersion);
        CompactOnLaunchCallback compactOnLaunchCallback2 = compactOnLaunchCallback;
        if (compactOnLaunchCallback2 != null) {
            CompactOnLaunchCallback callback = compactOnLaunchCallback2;
            boolean bl = false;
            RealmInterop.INSTANCE.realm_config_set_should_compact_on_launch_function(this.getNativeConfig(), new io.realm.internal.interop.CompactOnLaunchCallback(callback){
                final /* synthetic */ CompactOnLaunchCallback $callback;
                {
                    this.$callback = $callback;
                }

                public boolean invoke(long totalBytes, long usedBytes) {
                    return this.$callback.shouldCompact(totalBytes, usedBytes);
                }
            });
        }
        Iterable $i$f$associateWith22 = this.getMapOfKClassWithCompanion().values();
        configurationImpl = RealmInterop.INSTANCE;
        boolean $i$f$map = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            RealmObjectCompanion bl2 = (RealmObjectCompanion)item$iv$iv;
            object = destination$iv$iv;
            boolean bl3 = false;
            RealmClassImpl it4 = it3.io_realm_kotlin_schema();
            boolean bl4 = false;
            object.add(TuplesKt.to((Object)it4.getCinteropClass(), it4.getCinteropProperties()));
        }
        NativePointer nativeSchema = configurationImpl.realm_schema_new((List)destination$iv$iv);
        RealmInterop.INSTANCE.realm_config_set_schema(this.getNativeConfig(), nativeSchema);
        RealmInterop.INSTANCE.realm_config_set_max_number_of_active_versions(this.getNativeConfig(), maxNumberOfActiveVersions);
        RealmMigration realmMigration = migration;
        if (realmMigration != null) {
            it = realmMigration;
            boolean bl5 = false;
            if (it instanceof AutomaticSchemaMigration) {
                RealmInterop.INSTANCE.realm_config_set_migration_function(this.getNativeConfig(), (arg_0, arg_1, arg_2) -> ConfigurationImpl.lambda-5$lambda-4(this, (RealmMigration)it, arg_0, arg_1, arg_2));
            }
        }
        if (encryptionKey != null) {
            it = encryptionKey;
            boolean bl6 = false;
            RealmInterop.INSTANCE.realm_config_set_encryption_key(this.getNativeConfig(), (byte[])it);
        }
        this.mediator = new Mediator(){

            @Override
            @NotNull
            public RealmObjectInternal createInstanceOf(@NotNull KClass<? extends RealmObject> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                KClass<? extends RealmObject> kClass = clazz;
                return Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(DynamicRealmObject.class)) ? (RealmObjectInternal)new DynamicRealmObjectImpl() : (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(DynamicMutableRealmObject.class)) ? (RealmObjectInternal)new DynamicMutableRealmObjectImpl() : (RealmObjectInternal)this.companionOf(clazz).io_realm_kotlin_newInstance());
            }

            @Override
            @NotNull
            public RealmObjectCompanion companionOf(@NotNull KClass<? extends RealmObject> clazz) {
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                RealmObjectCompanion realmObjectCompanion = this.getMapOfKClassWithCompanion().get(clazz);
                if (realmObjectCompanion == null) {
                    throw new IllegalStateException((clazz + " not part of this configuration schema").toString());
                }
                return realmObjectCompanion;
            }
        };
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Set<KClass<? extends RealmObject>> getSchema() {
        return this.schema;
    }

    @Override
    @NotNull
    public LogConfiguration getLog() {
        return this.log;
    }

    @Override
    public long getMaxNumberOfActiveVersions() {
        return this.maxNumberOfActiveVersions;
    }

    @Override
    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    @NotNull
    public SchemaMode getSchemaMode() {
        return this.schemaMode;
    }

    @Override
    @Nullable
    public byte[] getEncryptionKey() {
        return RealmInterop.INSTANCE.realm_config_get_encryption_key(this.getNativeConfig());
    }

    @Override
    @NotNull
    public Map<KClass<? extends RealmObject>, RealmObjectCompanion> getMapOfKClassWithCompanion() {
        return this.mapOfKClassWithCompanion;
    }

    @Override
    @NotNull
    public Mediator getMediator() {
        return this.mediator;
    }

    @Override
    @NotNull
    public NativePointer<RealmConfigT> getNativeConfig() {
        return this.nativeConfig;
    }

    @Override
    @NotNull
    public CoroutineDispatcher getNotificationDispatcher() {
        return this.notificationDispatcher;
    }

    @Override
    @NotNull
    public CoroutineDispatcher getWriteDispatcher() {
        return this.writeDispatcher;
    }

    @Override
    @Nullable
    public CompactOnLaunchCallback getCompactOnLaunchCallback() {
        return this.compactOnLaunchCallback;
    }

    private final String normalizePath(String directoryPath, String fileName) {
        CharSequence charSequence;
        CharSequence charSequence2 = directoryPath;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = SystemUtilsJvmKt.appFilesDirectory();
        } else {
            charSequence = charSequence2;
        }
        String dir = (String)charSequence;
        if (StringsKt.startsWith$default((String)dir, (String)"./", (boolean)false, (int)2, null)) {
            dir = StringsKt.replaceFirst$default((String)dir, (String)"./", (String)Intrinsics.stringPlus((String)SystemUtilsJvmKt.appFilesDirectory(), (Object)"/"), (boolean)false, (int)4, null);
        }
        return SystemUtilsKt.prepareRealmFilePath(dir, fileName);
    }

    @Override
    @NotNull
    public String debug() {
        return InternalConfiguration.DefaultImpls.debug(this);
    }

    private static final boolean lambda-5$lambda-4(ConfigurationImpl this$0, RealmMigration $it, NativePointer oldRealm, NativePointer newRealm, NativePointer schema) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)oldRealm, (String)"oldRealm");
        Intrinsics.checkNotNullParameter((Object)newRealm, (String)"newRealm");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        RealmInterop.INSTANCE.realm_begin_read(oldRealm);
        RealmInterop.INSTANCE.realm_begin_read(newRealm);
        DynamicRealmImpl old = new DynamicRealmImpl(this$0, (NativePointer<FrozenRealmT>)oldRealm);
        DynamicMutableRealmImpl dynamicMutableRealmImpl = new DynamicMutableRealmImpl(this$0, (NativePointer<LiveRealmT>)newRealm);
        try {
            ((AutomaticSchemaMigration)$it).migrate(new AutomaticSchemaMigration.MigrationContext(old, dynamicMutableRealmImpl){
                @NotNull
                private final DynamicRealm oldRealm;
                @NotNull
                private final DynamicMutableRealm newRealm;
                final /* synthetic */ DynamicRealmImpl $old;
                final /* synthetic */ DynamicMutableRealmImpl $new;
                {
                    this.$old = $old;
                    this.$new = $new;
                    this.oldRealm = this.$old;
                    this.newRealm = this.$new;
                }

                @NotNull
                public DynamicRealm getOldRealm() {
                    return this.oldRealm;
                }

                @NotNull
                public DynamicMutableRealm getNewRealm() {
                    return this.newRealm;
                }

                public void enumerate(@NotNull String className, @NotNull Function2<? super DynamicRealmObject, ? super DynamicMutableRealmObject, Unit> block) {
                    AutomaticSchemaMigration.MigrationContext.DefaultImpls.enumerate(this, className, block);
                }
            });
            bl = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

