/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.RealmObject;
import io.realm.VersionId;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmObjectInternalKt;
import io.realm.internal.RealmReference;
import io.realm.internal.Thawable;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmInterop;
import io.realm.notifications.ObjectChange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a5\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00030\u00020\u0001\"\b\b\u0000\u0010\u0003*\u00020\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u0002H\u0003\u00a2\u0006\u0002\u0010\u0006\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0004H\u0002\u001a\u0016\u0010\t\u001a\u00020\n*\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\n\u0010\f\u001a\u00020\n*\u00020\u0004\u001a\n\u0010\r\u001a\u00020\n*\u00020\u0004\u001a\n\u0010\u000e\u001a\u00020\n*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0004\u00a8\u0006\u0011"}, d2={"asFlow", "Lkotlinx/coroutines/flow/Flow;", "Lio/realm/notifications/ObjectChange;", "T", "Lio/realm/RealmObject;", "C", "(Lio/realm/RealmObject;)Lkotlinx/coroutines/flow/Flow;", "checkNotificationsAvailable", "", "hasSameObjectKey", "", "other", "isFrozen", "isManaged", "isValid", "version", "Lio/realm/VersionId;", "io.realm.kotlin.library"})
public final class RealmObjectKt {
    public static final boolean isFrozen(@NotNull RealmObject $this$isFrozen) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrozen, (String)"<this>");
        return RealmObjectInternalKt.realmObjectInternal($this$isFrozen).isFrozen();
    }

    @NotNull
    public static final VersionId version(@NotNull RealmObject $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"<this>");
        return RealmObjectInternalKt.realmObjectInternal($this$version).version();
    }

    public static final boolean isManaged(@NotNull RealmObject $this$isManaged) {
        Intrinsics.checkNotNullParameter((Object)$this$isManaged, (String)"<this>");
        return RealmObjectInternalKt.realmObjectInternal($this$isManaged).get$realm$IsManaged();
    }

    public static final boolean hasSameObjectKey(@NotNull RealmObject $this$hasSameObjectKey, @Nullable RealmObject other) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSameObjectKey, (String)"<this>");
        if (other == null || !(other instanceof RealmObjectInternal)) {
            return false;
        }
        if (!RealmObjectKt.isManaged($this$hasSameObjectKey) || !RealmObjectKt.isManaged(other)) {
            throw new IllegalStateException("Cannot compare unmanaged objects.");
        }
        NativePointer nativePointer = RealmObjectInternalKt.realmObjectInternal($this$hasSameObjectKey).get$realm$ObjectPointer();
        Intrinsics.checkNotNull((Object)nativePointer);
        long thisKey = RealmInterop.INSTANCE.realm_object_get_key(nativePointer);
        NativePointer nativePointer2 = RealmObjectInternalKt.realmObjectInternal(other).get$realm$ObjectPointer();
        Intrinsics.checkNotNull((Object)nativePointer2);
        long otherKey = RealmInterop.INSTANCE.realm_object_get_key(nativePointer2);
        return thisKey == otherKey;
    }

    public static final boolean isValid(@NotNull RealmObject $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        if (RealmObjectKt.isManaged($this$isValid)) {
            RealmObjectInternal internalObject = (RealmObjectInternal)$this$isValid;
            NativePointer ptr = internalObject.get$realm$ObjectPointer();
            return ptr != null ? RealmInterop.INSTANCE.realm_object_is_valid(ptr) : false;
        }
        return true;
    }

    @NotNull
    public static final <T extends RealmObject, C extends ObjectChange<T>> Flow<ObjectChange<T>> asFlow(@NotNull T $this$asFlow) {
        Intrinsics.checkNotNullParameter($this$asFlow, (String)"<this>");
        RealmObjectKt.checkNotificationsAvailable($this$asFlow);
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$asFlow;
        RealmReference realmReference2 = internalObject.get$realm$Owner();
        Intrinsics.checkNotNull((Object)realmReference2);
        return realmReference2.getOwner().registerObserver$io_realm_kotlin_library((Thawable)((Object)$this$asFlow));
    }

    private static final void checkNotificationsAvailable(RealmObject $this$checkNotificationsAvailable) {
        RealmObjectInternal internalObject = (RealmObjectInternal)$this$checkNotificationsAvailable;
        RealmReference realm = internalObject.get$realm$Owner();
        if (!RealmObjectKt.isManaged($this$checkNotificationsAvailable)) {
            throw new IllegalStateException("Changes cannot be observed on unmanaged objects.");
        }
        if (realm != null && RealmInterop.INSTANCE.realm_is_closed(realm.getDbPointer())) {
            throw new IllegalStateException("Changes cannot be observed when the Realm has been closed.");
        }
        if (!RealmObjectKt.isValid($this$checkNotificationsAvailable)) {
            throw new IllegalStateException("Changes cannot be observed on objects that have been deleted from the Realm.");
        }
    }
}

