/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.CompactOnLaunchCallback;
import io.realm.LogConfiguration;
import io.realm.Realm;
import io.realm.RealmObject;
import io.realm.internal.platform.SystemUtilsKt;
import io.realm.log.LogLevel;
import io.realm.log.RealmLogger;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001:\u0001 R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R \u0010\u0018\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0011\u00a8\u0006!"}, d2={"Lio/realm/Configuration;", "", "compactOnLaunchCallback", "Lio/realm/CompactOnLaunchCallback;", "getCompactOnLaunchCallback", "()Lio/realm/CompactOnLaunchCallback;", "encryptionKey", "", "getEncryptionKey", "()[B", "log", "Lio/realm/LogConfiguration;", "getLog", "()Lio/realm/LogConfiguration;", "maxNumberOfActiveVersions", "", "getMaxNumberOfActiveVersions", "()J", "name", "", "getName", "()Ljava/lang/String;", "path", "getPath", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "getSchema", "()Ljava/util/Set;", "schemaVersion", "getSchemaVersion", "SharedBuilder", "io.realm.kotlin.library"})
public interface Configuration {
    @NotNull
    public String getPath();

    @NotNull
    public String getName();

    @NotNull
    public Set<KClass<? extends RealmObject>> getSchema();

    @NotNull
    public LogConfiguration getLog();

    public long getMaxNumberOfActiveVersions();

    public long getSchemaVersion();

    @Nullable
    public byte[] getEncryptionKey();

    @Nullable
    public CompactOnLaunchCallback getCompactOnLaunchCallback();

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u001d\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u00020\u0003B\u001d\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\r\u0010F\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010GJ\u0015\u0010H\u001a\u00028\u00012\b\b\u0002\u0010I\u001a\u00020\n\u00a2\u0006\u0002\u0010JJ\u0015\u0010\u000f\u001a\u00028\u00012\b\u0010K\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010LJ\u0013\u0010\u0015\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010MJ'\u0010N\u001a\u00028\u00012\b\b\u0002\u0010O\u001a\u00020\u001c2\u000e\b\u0002\u0010P\u001a\b\u0012\u0004\u0012\u00020>0=H\u0016\u00a2\u0006\u0002\u0010QJ\u0015\u0010!\u001a\u00028\u00012\b\b\u0002\u0010R\u001a\u00020\"\u00a2\u0006\u0002\u0010SJ\u0013\u0010'\u001a\u00028\u00012\u0006\u0010'\u001a\u00020\u0010\u00a2\u0006\u0002\u0010LJ\u0017\u0010*\u001a\u00028\u00012\u0006\u0010T\u001a\u00020+H\u0000\u00a2\u0006\u0004\bU\u0010VJ\u000f\u00100\u001a\u00028\u0001H\u0000\u00a2\u0006\u0004\bW\u0010XJ\u0013\u00109\u001a\u00028\u00012\u0006\u00109\u001a\u00020\"\u00a2\u0006\u0002\u0010SJ\u0010\u0010Y\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0017\u0010C\u001a\u00028\u00012\u0006\u0010T\u001a\u00020+H\u0000\u00a2\u0006\u0004\bZ\u0010VR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0012\"\u0004\b)\u0010\u0014R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R(\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u0010\bR\u001a\u00109\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010$\"\u0004\b;\u0010&R \u0010<\u001a\b\u0012\u0004\u0012\u00020>0=X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001c\u0010C\u001a\u0004\u0018\u00010+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010-\"\u0004\bE\u0010/\u00a8\u0006["}, d2={"Lio/realm/Configuration$SharedBuilder;", "T", "S", "", "schema", "", "Lkotlin/reflect/KClass;", "Lio/realm/RealmObject;", "(Ljava/util/Set;)V", "compactOnLaunchCallback", "Lio/realm/CompactOnLaunchCallback;", "getCompactOnLaunchCallback", "()Lio/realm/CompactOnLaunchCallback;", "setCompactOnLaunchCallback", "(Lio/realm/CompactOnLaunchCallback;)V", "directory", "", "getDirectory", "()Ljava/lang/String;", "setDirectory", "(Ljava/lang/String;)V", "encryptionKey", "", "getEncryptionKey", "()[B", "setEncryptionKey", "([B)V", "logLevel", "Lio/realm/log/LogLevel;", "getLogLevel", "()Lio/realm/log/LogLevel;", "setLogLevel", "(Lio/realm/log/LogLevel;)V", "maxNumberOfActiveVersions", "", "getMaxNumberOfActiveVersions", "()J", "setMaxNumberOfActiveVersions", "(J)V", "name", "getName", "setName", "notificationDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getNotificationDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "setNotificationDispatcher", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "removeSystemLogger", "", "getRemoveSystemLogger", "()Z", "setRemoveSystemLogger", "(Z)V", "getSchema", "()Ljava/util/Set;", "setSchema", "schemaVersion", "getSchemaVersion", "setSchemaVersion", "userLoggers", "", "Lio/realm/log/RealmLogger;", "getUserLoggers", "()Ljava/util/List;", "setUserLoggers", "(Ljava/util/List;)V", "writeDispatcher", "getWriteDispatcher", "setWriteDispatcher", "build", "()Ljava/lang/Object;", "compactOnLaunch", "callback", "(Lio/realm/CompactOnLaunchCallback;)Lio/realm/Configuration$SharedBuilder;", "directoryPath", "(Ljava/lang/String;)Lio/realm/Configuration$SharedBuilder;", "([B)Lio/realm/Configuration$SharedBuilder;", "log", "level", "customLoggers", "(Lio/realm/log/LogLevel;Ljava/util/List;)Lio/realm/Configuration$SharedBuilder;", "maxVersions", "(J)Lio/realm/Configuration$SharedBuilder;", "dispatcher", "notificationDispatcher$io_realm_kotlin_library", "(Lkotlinx/coroutines/CoroutineDispatcher;)Lio/realm/Configuration$SharedBuilder;", "removeSystemLogger$io_realm_kotlin_library", "()Lio/realm/Configuration$SharedBuilder;", "validateEncryptionKey", "writeDispatcher$io_realm_kotlin_library", "io.realm.kotlin.library"})
    public static abstract class SharedBuilder<T, S extends SharedBuilder<T, S>> {
        @NotNull
        private Set<? extends KClass<? extends RealmObject>> schema;
        @Nullable
        private String directory;
        @NotNull
        private String name;
        @NotNull
        private LogLevel logLevel;
        private boolean removeSystemLogger;
        @NotNull
        private List<? extends RealmLogger> userLoggers;
        private long maxNumberOfActiveVersions;
        @Nullable
        private CoroutineDispatcher notificationDispatcher;
        @Nullable
        private CoroutineDispatcher writeDispatcher;
        private long schemaVersion;
        @Nullable
        private byte[] encryptionKey;
        @Nullable
        private CompactOnLaunchCallback compactOnLaunchCallback;

        public SharedBuilder(@NotNull Set<? extends KClass<? extends RealmObject>> schema) {
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            this.schema = schema;
            this.name = "default.realm";
            this.logLevel = LogLevel.WARN;
            this.userLoggers = CollectionsKt.emptyList();
            this.maxNumberOfActiveVersions = Long.MAX_VALUE;
        }

        public /* synthetic */ SharedBuilder(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                set = SetsKt.emptySet();
            }
            this(set);
        }

        @NotNull
        protected final Set<KClass<? extends RealmObject>> getSchema() {
            return this.schema;
        }

        protected final void setSchema(@NotNull Set<? extends KClass<? extends RealmObject>> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.schema = set;
        }

        @Nullable
        protected final String getDirectory() {
            return this.directory;
        }

        protected final void setDirectory(@Nullable String string) {
            this.directory = string;
        }

        @NotNull
        protected final String getName() {
            return this.name;
        }

        protected final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        protected final LogLevel getLogLevel() {
            return this.logLevel;
        }

        protected final void setLogLevel(@NotNull LogLevel logLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
            this.logLevel = logLevel;
        }

        protected final boolean getRemoveSystemLogger() {
            return this.removeSystemLogger;
        }

        protected final void setRemoveSystemLogger(boolean bl) {
            this.removeSystemLogger = bl;
        }

        @NotNull
        protected final List<RealmLogger> getUserLoggers() {
            return this.userLoggers;
        }

        protected final void setUserLoggers(@NotNull List<? extends RealmLogger> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.userLoggers = list;
        }

        protected final long getMaxNumberOfActiveVersions() {
            return this.maxNumberOfActiveVersions;
        }

        protected final void setMaxNumberOfActiveVersions(long l) {
            this.maxNumberOfActiveVersions = l;
        }

        @Nullable
        protected final CoroutineDispatcher getNotificationDispatcher() {
            return this.notificationDispatcher;
        }

        protected final void setNotificationDispatcher(@Nullable CoroutineDispatcher coroutineDispatcher) {
            this.notificationDispatcher = coroutineDispatcher;
        }

        @Nullable
        protected final CoroutineDispatcher getWriteDispatcher() {
            return this.writeDispatcher;
        }

        protected final void setWriteDispatcher(@Nullable CoroutineDispatcher coroutineDispatcher) {
            this.writeDispatcher = coroutineDispatcher;
        }

        protected final long getSchemaVersion() {
            return this.schemaVersion;
        }

        protected final void setSchemaVersion(long l) {
            this.schemaVersion = l;
        }

        @Nullable
        protected final byte[] getEncryptionKey() {
            return this.encryptionKey;
        }

        protected final void setEncryptionKey(@Nullable byte[] byArray) {
            this.encryptionKey = byArray;
        }

        @Nullable
        protected final CompactOnLaunchCallback getCompactOnLaunchCallback() {
            return this.compactOnLaunchCallback;
        }

        protected final void setCompactOnLaunchCallback(@Nullable CompactOnLaunchCallback compactOnLaunchCallback) {
            this.compactOnLaunchCallback = compactOnLaunchCallback;
        }

        public abstract T build();

        @NotNull
        public final S directory(@Nullable String directoryPath) {
            SharedBuilder sharedBuilder;
            SharedBuilder $this$directory_u24lambda_u2d0 = sharedBuilder = this;
            boolean bl = false;
            $this$directory_u24lambda_u2d0.setDirectory(directoryPath);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S name(@NotNull String name) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            SharedBuilder $this$name_u24lambda_u2d1 = sharedBuilder = this;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)name, (CharSequence)SystemUtilsKt.getPATH_SEPARATOR(), (boolean)false, (int)2, null)) {
                throw new IllegalArgumentException("Name cannot contain path separator '" + SystemUtilsKt.getPATH_SEPARATOR() + "': '" + name + '\'');
            }
            $this$name_u24lambda_u2d1.setName(name);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S maxNumberOfActiveVersions(long maxVersions) {
            SharedBuilder sharedBuilder;
            SharedBuilder $this$maxNumberOfActiveVersions_u24lambda_u2d2 = sharedBuilder = this;
            boolean bl = false;
            if (maxVersions < 1L) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Only positive numbers above 0 are allowed. Yours was: ", (Object)maxVersions));
            }
            $this$maxNumberOfActiveVersions_u24lambda_u2d2.setMaxNumberOfActiveVersions(maxVersions);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder maxNumberOfActiveVersions$default(SharedBuilder sharedBuilder, long l, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: maxNumberOfActiveVersions");
            }
            if ((n & 1) != 0) {
                l = 8L;
            }
            return sharedBuilder.maxNumberOfActiveVersions(l);
        }

        @NotNull
        public S log(@NotNull LogLevel level, @NotNull List<? extends RealmLogger> customLoggers) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
            Intrinsics.checkNotNullParameter(customLoggers, (String)"customLoggers");
            SharedBuilder $this$log_u24lambda_u2d3 = sharedBuilder = this;
            boolean bl = false;
            $this$log_u24lambda_u2d3.setLogLevel(level);
            $this$log_u24lambda_u2d3.setUserLoggers(customLoggers);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder log$default(SharedBuilder sharedBuilder, LogLevel logLevel, List list, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
            }
            if ((n & 1) != 0) {
                logLevel = LogLevel.WARN;
            }
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            return sharedBuilder.log(logLevel, list);
        }

        @NotNull
        public final S notificationDispatcher$io_realm_kotlin_library(@NotNull CoroutineDispatcher dispatcher) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            SharedBuilder $this$notificationDispatcher_u24lambda_u2d4 = sharedBuilder = this;
            boolean bl = false;
            $this$notificationDispatcher_u24lambda_u2d4.setNotificationDispatcher(dispatcher);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S writeDispatcher$io_realm_kotlin_library(@NotNull CoroutineDispatcher dispatcher) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
            SharedBuilder $this$writeDispatcher_u24lambda_u2d5 = sharedBuilder = this;
            boolean bl = false;
            $this$writeDispatcher_u24lambda_u2d5.setWriteDispatcher(dispatcher);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S schemaVersion(long schemaVersion) {
            SharedBuilder sharedBuilder;
            if (schemaVersion < 0L) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Realm schema version numbers must be 0 (zero) or higher. Yours was: ", (Object)schemaVersion));
            }
            SharedBuilder $this$schemaVersion_u24lambda_u2d6 = sharedBuilder = this;
            boolean bl = false;
            $this$schemaVersion_u24lambda_u2d6.setSchemaVersion(schemaVersion);
            return (S)sharedBuilder;
        }

        @NotNull
        public final S encryptionKey(@NotNull byte[] encryptionKey) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
            SharedBuilder $this$encryptionKey_u24lambda_u2d7 = sharedBuilder = this;
            boolean bl = false;
            $this$encryptionKey_u24lambda_u2d7.setEncryptionKey($this$encryptionKey_u24lambda_u2d7.validateEncryptionKey(encryptionKey));
            return (S)sharedBuilder;
        }

        @NotNull
        public final S compactOnLaunch(@NotNull CompactOnLaunchCallback callback) {
            SharedBuilder sharedBuilder;
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            SharedBuilder $this$compactOnLaunch_u24lambda_u2d8 = sharedBuilder = this;
            boolean bl = false;
            $this$compactOnLaunch_u24lambda_u2d8.setCompactOnLaunchCallback(callback);
            return (S)sharedBuilder;
        }

        public static /* synthetic */ SharedBuilder compactOnLaunch$default(SharedBuilder sharedBuilder, CompactOnLaunchCallback compactOnLaunchCallback, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: compactOnLaunch");
            }
            if ((n & 1) != 0) {
                compactOnLaunchCallback = Realm.Companion.getDEFAULT_COMPACT_ON_LAUNCH_CALLBACK();
            }
            return sharedBuilder.compactOnLaunch(compactOnLaunchCallback);
        }

        @NotNull
        public final S removeSystemLogger$io_realm_kotlin_library() {
            SharedBuilder sharedBuilder;
            SharedBuilder $this$removeSystemLogger_u24lambda_u2d9 = sharedBuilder = this;
            boolean bl = false;
            $this$removeSystemLogger_u24lambda_u2d9.setRemoveSystemLogger(true);
            return (S)sharedBuilder;
        }

        @NotNull
        protected final byte[] validateEncryptionKey(@NotNull byte[] encryptionKey) {
            Intrinsics.checkNotNullParameter((Object)encryptionKey, (String)"encryptionKey");
            if (encryptionKey.length != 64) {
                throw new IllegalArgumentException("The provided key must be 64 bytes. The provided key was " + encryptionKey.length + " bytes.");
            }
            return encryptionKey;
        }

        public SharedBuilder() {
            this(null, 1, null);
        }
    }
}

