/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.Deleteable;
import io.realm.MutableRealm;
import io.realm.RealmObject;
import io.realm.RealmObjectKt;
import io.realm.internal.InternalConfiguration;
import io.realm.internal.InternalDeleteableKt;
import io.realm.internal.LiveRealmReference;
import io.realm.internal.RealmObjectInternal;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.Thawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J'\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J!\u0010\u0015\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\u0016\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0019\"\u0004\b\u0000\u0010\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u001bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001c"}, d2={"Lio/realm/internal/InternalMutableRealm;", "Lio/realm/MutableRealm;", "configuration", "Lio/realm/internal/InternalConfiguration;", "getConfiguration", "()Lio/realm/internal/InternalConfiguration;", "realmReference", "Lio/realm/internal/LiveRealmReference;", "getRealmReference", "()Lio/realm/internal/LiveRealmReference;", "copyToRealm", "T", "Lio/realm/RealmObject;", "instance", "updatePolicy", "Lio/realm/MutableRealm$UpdatePolicy;", "(Lio/realm/RealmObject;Lio/realm/MutableRealm$UpdatePolicy;)Lio/realm/RealmObject;", "delete", "", "deleteable", "Lio/realm/Deleteable;", "findLatest", "obj", "(Lio/realm/RealmObject;)Lio/realm/RealmObject;", "registerObserver", "Lkotlinx/coroutines/flow/Flow;", "t", "Lio/realm/internal/Thawable;", "io.realm.kotlin.library"})
public interface InternalMutableRealm
extends MutableRealm {
    @Override
    @NotNull
    public InternalConfiguration getConfiguration();

    @NotNull
    public LiveRealmReference getRealmReference();

    @Override
    @Nullable
    public <T extends RealmObject> T findLatest(@NotNull T var1);

    @Override
    @NotNull
    public <T extends RealmObject> T copyToRealm(@NotNull T var1, @NotNull MutableRealm.UpdatePolicy var2);

    @NotNull
    public <T> Flow<T> registerObserver(@NotNull Thawable<T> var1);

    @Override
    public void delete(@NotNull Deleteable var1);

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static <T extends RealmObject> T findLatest(@NotNull InternalMutableRealm this_, @NotNull T obj) {
            RealmObject realmObject;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(obj, (String)"obj");
            if (!RealmObjectKt.isValid(obj)) {
                realmObject = null;
            } else {
                if (!RealmObjectKt.isManaged(obj)) {
                    throw new IllegalArgumentException("Unmanaged objects must be part of the Realm, before they can be queried this way. Use `MutableRealm.copyToRealm()` to turn it into a managed object.");
                }
                realmObject = Intrinsics.areEqual((Object)((RealmObjectInternal)obj).get$realm$Owner(), (Object)this_.getRealmReference()) ? obj : (RealmObject)((RealmObjectInternal)obj).thaw(this_.getRealmReference());
            }
            return (T)realmObject;
        }

        @NotNull
        public static <T extends RealmObject> T copyToRealm(@NotNull InternalMutableRealm this_, @NotNull T instance, @NotNull MutableRealm.UpdatePolicy updatePolicy) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(instance, (String)"instance");
            Intrinsics.checkNotNullParameter((Object)((Object)updatePolicy), (String)"updatePolicy");
            return (T)((RealmObject)RealmUtilsKt.copyToRealm$default(this_.getConfiguration().getMediator(), this_.getRealmReference(), instance, updatePolicy, null, 16, null));
        }

        @NotNull
        public static <T> Flow<T> registerObserver(@NotNull InternalMutableRealm this_, @NotNull Thawable<T> t) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(t, (String)"t");
            throw new IllegalStateException("Changes to RealmResults cannot be observed during a write.");
        }

        public static void delete(@NotNull InternalMutableRealm this_, @NotNull Deleteable deleteable) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)deleteable, (String)"deleteable");
            InternalDeleteableKt.asInternalDeleteable(deleteable).delete();
        }
    }
}

