/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal;

import io.realm.RealmList;
import io.realm.internal.Flowable;
import io.realm.internal.InternalDeleteable;
import io.realm.internal.ListChangeSetBuilderImpl;
import io.realm.internal.ListOperatorMetadata;
import io.realm.internal.Observable;
import io.realm.internal.RealmReference;
import io.realm.internal.RealmUtilsKt;
import io.realm.internal.UnmanagedRealmList;
import io.realm.internal.interop.Callback;
import io.realm.internal.interop.NativePointer;
import io.realm.internal.interop.RealmCoreException;
import io.realm.internal.interop.RealmInterop;
import io.realm.notifications.ListChange;
import io.realm.notifications.internal.DeletedListImpl;
import io.realm.notifications.internal.InitialListImpl;
import io.realm.notifications.internal.UpdatedListImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractMutableList;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u00042\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u00052\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0007B\u001b\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0017H\u0016J\u0017\u0010\u0018\u001a\u00028\u00002\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016JB\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\t2\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060$H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0002\b%J\u0018\u0010&\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u0010 \u001a\u00020!H\u0016J\u0016\u0010'\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010(J\r\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0016J\u0015\u0010/\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010(J\u001e\u00100\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00002\u0006\u00103\u001a\u00020!H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u00064"}, d2={"Lio/realm/internal/ManagedRealmList;", "E", "Lkotlin/collections/AbstractMutableList;", "Lio/realm/RealmList;", "Lio/realm/internal/InternalDeleteable;", "Lio/realm/internal/Observable;", "Lio/realm/notifications/ListChange;", "Lio/realm/internal/Flowable;", "nativePointer", "Lio/realm/internal/interop/NativePointer;", "metadata", "Lio/realm/internal/ListOperatorMetadata;", "(Lio/realm/internal/interop/NativePointer;Lio/realm/internal/ListOperatorMetadata;)V", "size", "", "getSize", "()I", "add", "", "index", "element", "(ILjava/lang/Object;)V", "asFlow", "Lkotlinx/coroutines/flow/Flow;", "cinteropObjectToUserObject", "value", "", "(Ljava/lang/Object;)Ljava/lang/Object;", "clear", "delete", "emitFrozenUpdate", "Lkotlinx/coroutines/channels/ChannelResult;", "frozenRealm", "Lio/realm/internal/RealmReference;", "change", "channel", "Lkotlinx/coroutines/channels/SendChannel;", "emitFrozenUpdate-t11v4CI", "freeze", "get", "(I)Ljava/lang/Object;", "isValid", "", "isValid$io_realm_kotlin_library", "registerForNotification", "callback", "Lio/realm/internal/interop/Callback;", "removeAt", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "thaw", "liveRealm", "io.realm.kotlin.library"})
public final class ManagedRealmList<E>
extends AbstractMutableList<E>
implements RealmList<E>,
InternalDeleteable,
Observable<ManagedRealmList<E>, ListChange<E>>,
Flowable<ListChange<E>> {
    @NotNull
    private final NativePointer nativePointer;
    @NotNull
    private final ListOperatorMetadata<E> metadata;

    public ManagedRealmList(@NotNull NativePointer nativePointer, @NotNull ListOperatorMetadata<E> metadata) {
        Intrinsics.checkNotNullParameter((Object)nativePointer, (String)"nativePointer");
        Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
        this.nativePointer = nativePointer;
        this.metadata = metadata;
    }

    public int getSize() {
        this.metadata.getRealm().checkClosed();
        return (int)RealmInterop.INSTANCE.realm_list_size(this.nativePointer);
    }

    @Override
    public E get(int index) {
        this.metadata.getRealm().checkClosed();
        try {
            return this.cinteropObjectToUserObject(RealmInterop.INSTANCE.realm_list_get(this.nativePointer, (long)index));
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not get element at list index ", (Object)index), exception);
        }
    }

    @Override
    public void add(int index, E element) {
        this.metadata.getRealm().checkClosed();
        try {
            RealmInterop.INSTANCE.realm_list_add(this.nativePointer, (long)index, RealmUtilsKt.copyToRealm$default(this.metadata.getMediator(), this.metadata.getRealm(), element, null, null, 24, null));
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not add element at list index ", (Object)index), exception);
        }
    }

    @Override
    public void clear() {
        this.metadata.getRealm().checkClosed();
        RealmInterop.INSTANCE.realm_list_clear(this.nativePointer);
    }

    public E removeAt(int index) {
        E e;
        E it = e = this.get(index);
        boolean bl = false;
        this.metadata.getRealm().checkClosed();
        try {
            RealmInterop.INSTANCE.realm_list_erase(this.nativePointer, (long)index);
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not remove element at list index ", (Object)index), exception);
        }
        return e;
    }

    private final E cinteropObjectToUserObject(Object value) {
        E e;
        Object object = value;
        if (object == null) {
            e = null;
        } else {
            Object it = object;
            boolean bl = false;
            e = this.metadata.getConverter().convert(value);
        }
        return e;
    }

    @Override
    public E set(int index, E element) {
        this.metadata.getRealm().checkClosed();
        try {
            return this.cinteropObjectToUserObject(RealmInterop.INSTANCE.realm_list_set(this.nativePointer, (long)index, RealmUtilsKt.copyToRealm$default(this.metadata.getMediator(), this.metadata.getRealm(), element, null, null, 24, null)));
        }
        catch (RealmCoreException exception) {
            throw RealmUtilsKt.genericRealmCoreExceptionHandler(Intrinsics.stringPlus((String)"Could not set list element at list index ", (Object)index), exception);
        }
    }

    @Override
    @NotNull
    public Flow<ListChange<E>> asFlow() {
        this.metadata.getRealm().checkClosed();
        return this.metadata.getRealm().getOwner().registerObserver$io_realm_kotlin_library(this);
    }

    @Override
    @Nullable
    public ManagedRealmList<E> freeze(@NotNull RealmReference frozenRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, frozenRealm.getDbPointer());
        if (nativePointer == null) {
            managedRealmList = null;
        } else {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>(it, ListOperatorMetadata.copy$default(this.metadata, null, frozenRealm, null, 5, null));
        }
        return managedRealmList;
    }

    @Override
    @Nullable
    public ManagedRealmList<E> thaw(@NotNull RealmReference liveRealm) {
        ManagedRealmList<E> managedRealmList;
        Intrinsics.checkNotNullParameter((Object)liveRealm, (String)"liveRealm");
        NativePointer nativePointer = RealmInterop.INSTANCE.realm_list_resolve_in(this.nativePointer, liveRealm.getDbPointer());
        if (nativePointer == null) {
            managedRealmList = null;
        } else {
            NativePointer it = nativePointer;
            boolean bl = false;
            managedRealmList = new ManagedRealmList<E>(it, ListOperatorMetadata.copy$default(this.metadata, null, liveRealm, null, 5, null));
        }
        return managedRealmList;
    }

    @Override
    @NotNull
    public NativePointer registerForNotification(@NotNull Callback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        return RealmInterop.INSTANCE.realm_list_add_notification_callback(this.nativePointer, callback);
    }

    @Override
    @Nullable
    public ChannelResult<Unit> emitFrozenUpdate-t11v4CI(@NotNull RealmReference frozenRealm, @NotNull NativePointer change, @NotNull SendChannel<? super ListChange<E>> channel) {
        ChannelResult channelResult;
        Intrinsics.checkNotNullParameter((Object)frozenRealm, (String)"frozenRealm");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        Intrinsics.checkNotNullParameter(channel, (String)"channel");
        Object frozenList = this.freeze(frozenRealm);
        if (frozenList != null) {
            ListChangeSetBuilderImpl builder = new ListChangeSetBuilderImpl(change);
            channelResult = ChannelResult.box-impl((Object)(builder.isEmpty() ? channel.trySend-JP2dKIU(new InitialListImpl((RealmList)frozenList)) : channel.trySend-JP2dKIU(new UpdatedListImpl((RealmList)frozenList, builder.build()))));
        } else {
            ChannelResult channelResult2 = ChannelResult.box-impl((Object)channel.trySend-JP2dKIU(new DeletedListImpl(new UnmanagedRealmList())));
            Object it = channelResult2.unbox-impl();
            boolean bl = false;
            SendChannel.DefaultImpls.close$default(channel, null, (int)1, null);
            channelResult = channelResult2;
        }
        return channelResult;
    }

    public final boolean isValid$io_realm_kotlin_library() {
        return RealmInterop.INSTANCE.realm_list_is_valid(this.nativePointer);
    }

    @Override
    public void delete() {
        RealmInterop.INSTANCE.realm_list_remove_all(this.nativePointer);
    }
}

