/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.interop;

import io.realm.internal.interop.realm_binary_t;
import io.realm.internal.interop.realm_decimal128_t;
import io.realm.internal.interop.realm_link_t;
import io.realm.internal.interop.realm_object_id_t;
import io.realm.internal.interop.realm_timestamp_t;
import io.realm.internal.interop.realm_uuid_t;
import io.realm.internal.interop.realmcJNI;

public class realm_value_t {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected realm_value_t(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(realm_value_t obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                realmcJNI.delete_realm_value_t(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setInteger(long value) {
        realmcJNI.realm_value_t_integer_set(this.swigCPtr, this, value);
    }

    public long getInteger() {
        return realmcJNI.realm_value_t_integer_get(this.swigCPtr, this);
    }

    public void set_boolean(boolean value) {
        realmcJNI.realm_value_t__boolean_set(this.swigCPtr, this, value);
    }

    public boolean get_boolean() {
        return realmcJNI.realm_value_t__boolean_get(this.swigCPtr, this);
    }

    public void setString(String value) {
        realmcJNI.realm_value_t_string_set(this.swigCPtr, this, value);
    }

    public String getString() {
        return realmcJNI.realm_value_t_string_get(this.swigCPtr, this);
    }

    public void setBinary(realm_binary_t value) {
        realmcJNI.realm_value_t_binary_set(this.swigCPtr, this, realm_binary_t.getCPtr(value), value);
    }

    public realm_binary_t getBinary() {
        long cPtr = realmcJNI.realm_value_t_binary_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new realm_binary_t(cPtr, false);
    }

    public void setTimestamp(realm_timestamp_t value) {
        realmcJNI.realm_value_t_timestamp_set(this.swigCPtr, this, realm_timestamp_t.getCPtr(value), value);
    }

    public realm_timestamp_t getTimestamp() {
        long cPtr = realmcJNI.realm_value_t_timestamp_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new realm_timestamp_t(cPtr, false);
    }

    public void setFnum(float value) {
        realmcJNI.realm_value_t_fnum_set(this.swigCPtr, this, value);
    }

    public float getFnum() {
        return realmcJNI.realm_value_t_fnum_get(this.swigCPtr, this);
    }

    public void setDnum(double value) {
        realmcJNI.realm_value_t_dnum_set(this.swigCPtr, this, value);
    }

    public double getDnum() {
        return realmcJNI.realm_value_t_dnum_get(this.swigCPtr, this);
    }

    public void setDecimal128(realm_decimal128_t value) {
        realmcJNI.realm_value_t_decimal128_set(this.swigCPtr, this, realm_decimal128_t.getCPtr(value), value);
    }

    public realm_decimal128_t getDecimal128() {
        long cPtr = realmcJNI.realm_value_t_decimal128_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new realm_decimal128_t(cPtr, false);
    }

    public void setObject_id(realm_object_id_t value) {
        realmcJNI.realm_value_t_object_id_set(this.swigCPtr, this, realm_object_id_t.getCPtr(value), value);
    }

    public realm_object_id_t getObject_id() {
        long cPtr = realmcJNI.realm_value_t_object_id_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new realm_object_id_t(cPtr, false);
    }

    public void setUuid(realm_uuid_t value) {
        realmcJNI.realm_value_t_uuid_set(this.swigCPtr, this, realm_uuid_t.getCPtr(value), value);
    }

    public realm_uuid_t getUuid() {
        long cPtr = realmcJNI.realm_value_t_uuid_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new realm_uuid_t(cPtr, false);
    }

    public void setLink(realm_link_t value) {
        realmcJNI.realm_value_t_link_set(this.swigCPtr, this, realm_link_t.getCPtr(value), value);
    }

    public realm_link_t getLink() {
        long cPtr = realmcJNI.realm_value_t_link_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new realm_link_t(cPtr, false);
    }

    public void setData(String value) {
        realmcJNI.realm_value_t_data_set(this.swigCPtr, this, value);
    }

    public String getData() {
        return realmcJNI.realm_value_t_data_get(this.swigCPtr, this);
    }

    public void setType(int value) {
        realmcJNI.realm_value_t_type_set(this.swigCPtr, this, value);
    }

    public int getType() {
        return realmcJNI.realm_value_t_type_get(this.swigCPtr, this);
    }

    public realm_value_t() {
        this(realmcJNI.new_realm_value_t(), true);
    }
}

