/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import io.realm.kotlin.gradle.analytics.AnalyticsService;
import io.realm.kotlin.gradle.analytics.AnalyticsServiceKt;
import io.realm.kotlin.gradle.analytics.HostIdentifier;
import java.io.File;
import java.net.NetworkInterface;
import java.nio.charset.Charset;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\r"}, d2={"Lio/realm/kotlin/gradle/analytics/ComputerId;", "Lio/realm/kotlin/gradle/analytics/HostIdentifier;", "<init>", "()V", "linuxIdentifier", "", "getLinuxIdentifier", "()Ljava/lang/String;", "macOsIdentifier", "getMacOsIdentifier", "windowsIdentifier", "getWindowsIdentifier", "obtain", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nAnalyticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsService.kt\nio/realm/kotlin/gradle/analytics/ComputerId\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,456:1\n107#2:457\n79#2,22:458\n*S KotlinDebug\n*F\n+ 1 AnalyticsService.kt\nio/realm/kotlin/gradle/analytics/ComputerId\n*L\n320#1:457\n320#1:458,22\n*E\n"})
public abstract class ComputerId
extends HostIdentifier {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getLinuxIdentifier() {
        void var3_3;
        File machineId = new File("/var/lib/dbus/machine-id");
        if (!machineId.exists()) {
            machineId = new File("/etc/machine-id");
        }
        if (!machineId.exists()) {
            throw new IllegalStateException("Cannot locate machine identifier in " + machineId.getAbsolutePath());
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(machineId);
            String id = scanner.useDelimiter("\\A").next();
            scanner.close();
        }
        catch (Throwable throwable) {
            Scanner scanner2 = scanner;
            if (scanner2 != null) {
                scanner2.close();
            }
            throw throwable;
        }
        return var3_3;
    }

    @Override
    @NotNull
    public String getMacOsIdentifier() {
        NetworkInterface networkInterface = NetworkInterface.getByName("en0");
        byte[] hardwareAddress = networkInterface.getHardwareAddress();
        Intrinsics.checkNotNull((Object)hardwareAddress);
        byte[] byArray = hardwareAddress;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset charset2 = charset;
        return new String(byArray, charset2);
    }

    @Override
    @NotNull
    public String getWindowsIdentifier() {
        Object[] objectArray = new String[]{"wmic", "csproduct", "get", "UUID"};
        String output = this.exec(CollectionsKt.listOf((Object[])objectArray));
        Scanner sc = new Scanner(output);
        String result = null;
        while (sc.hasNext()) {
            String next = sc.next();
            Intrinsics.checkNotNull((Object)next);
            if (!StringsKt.contains$default((CharSequence)next, (CharSequence)"UUID", (boolean)false, (int)2, null)) continue;
            String string = sc.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"next(...)");
            String $this$trim$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            result = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            break;
        }
        String string = result;
        Intrinsics.checkNotNull(string);
        return string;
    }

    @Nullable
    public String obtain() {
        return this.withDefaultOnError("ComputerId", AnalyticsService.Companion.unknown$gradle_plugin$default(AnalyticsService.Companion, null, 1, null), () -> ComputerId.obtain$lambda$1(this));
    }

    private static final String obtain$lambda$1(ComputerId this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.getIdentifier();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return AnalyticsServiceKt.hexStringify(AnalyticsServiceKt.sha256Hash(byArray));
    }
}

