/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import io.realm.kotlin.gradle.analytics.RealmAnalyticsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/realm/kotlin/gradle/analytics/ComputerIdentifierGenerator;", "", "()V", "OS", "", "UNKNOWN", "isLinux", "", "()Z", "isMac", "isWindows", "linuxMacAddress", "getLinuxMacAddress", "()Ljava/lang/String;", "macOsIdentifier", "getMacOsIdentifier", "windowsIdentifier", "getWindowsIdentifier", "get", "gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRealmAnalytics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealmAnalytics.kt\nio/realm/kotlin/gradle/analytics/ComputerIdentifierGenerator\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,331:1\n107#2:332\n79#2,22:333\n*S KotlinDebug\n*F\n+ 1 RealmAnalytics.kt\nio/realm/kotlin/gradle/analytics/ComputerIdentifierGenerator\n*L\n286#1:332\n286#1:333,22\n*E\n"})
public final class ComputerIdentifierGenerator {
    @NotNull
    public static final ComputerIdentifierGenerator INSTANCE = new ComputerIdentifierGenerator();
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String OS;

    private ComputerIdentifierGenerator() {
    }

    @NotNull
    public final String get() {
        String string;
        try {
            string = this.isWindows() ? this.getWindowsIdentifier() : (this.isMac() ? this.getMacOsIdentifier() : (this.isLinux() ? this.getLinuxMacAddress() : UNKNOWN));
        }
        catch (Exception e) {
            string = UNKNOWN;
        }
        return string;
    }

    private final boolean isWindows() {
        return StringsKt.contains$default((CharSequence)OS, (CharSequence)"win", (boolean)false, (int)2, null);
    }

    private final boolean isMac() {
        return StringsKt.contains$default((CharSequence)OS, (CharSequence)"mac", (boolean)false, (int)2, null);
    }

    private final boolean isLinux() {
        return StringsKt.contains$default((CharSequence)OS, (CharSequence)"inux", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getLinuxMacAddress() throws FileNotFoundException, NoSuchAlgorithmException {
        String string;
        File machineId = new File("/var/lib/dbus/machine-id");
        if (!machineId.exists()) {
            machineId = new File("/etc/machine-id");
        }
        if (!machineId.exists()) {
            return UNKNOWN;
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(machineId);
            String id = scanner.useDelimiter("\\A").next();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            String string2 = id;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            string = RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(byArray));
            scanner.close();
        }
        catch (Throwable throwable) {
            Scanner scanner2 = scanner;
            if (scanner2 != null) {
                scanner2.close();
            }
            throw throwable;
        }
        return string;
    }

    private final String getMacOsIdentifier() throws SocketException, NoSuchAlgorithmException {
        NetworkInterface networkInterface = NetworkInterface.getByName("en0");
        byte[] hardwareAddress = networkInterface.getHardwareAddress();
        return RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(hardwareAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final String getWindowsIdentifier() throws IOException, NoSuchAlgorithmException {
        String string;
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{"wmic", "csproduct", "get", "UUID"};
        Process process = runtime.exec(stringArray);
        Ref.ObjectRef result = new Ref.ObjectRef();
        InputStream is = process.getInputStream();
        Scanner sc = new Scanner(process.getInputStream());
        Object object = is;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)object;
            boolean bl = false;
            while (sc.hasNext()) {
                void $this$trim$iv;
                String next = sc.next();
                Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
                if (!StringsKt.contains$default((CharSequence)next, (CharSequence)"UUID", (boolean)false, (int)2, null)) continue;
                String string2 = sc.next();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sc.next()");
                String string3 = string2;
                Ref.ObjectRef objectRef = result;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                objectRef.element = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        if (result.element == null) {
            string = UNKNOWN;
        } else {
            Object object2 = result.element;
            Intrinsics.checkNotNull((Object)object2);
            object = (String)object2;
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            string = RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(byArray));
        }
        return string;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        OS = string2;
    }
}

