/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.builder.model.ApiVersion;
import io.realm.kotlin.gradle.analytics.ComputerIdentifierGenerator;
import io.realm.kotlin.gradle.analytics.RealmAnalyticsKt;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0010\u001a\u00020\u000bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/realm/kotlin/gradle/analytics/RealmAnalytics;", "", "()V", "jsonData", "", "logger", "Lorg/gradle/api/logging/Logger;", "anonymousAppId", "project", "Lorg/gradle/api/Project;", "gatherAnalyticsDataIfNeeded", "", "jsonPayload", "networkQuery", "sendAnalytics", "json", "sendAnalyticsData", "Companion", "gradle-plugin"})
public final class RealmAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @Nullable
    private String jsonData;
    private static volatile boolean METRIC_PROCESSED;

    public RealmAnalytics() {
        Logger logger = Logging.getLogger((String)"realm-analytics");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"realm-analytics\")");
        this.logger = logger;
    }

    public final void gatherAnalyticsDataIfNeeded(@NotNull Project project) {
        boolean disableAnalytics;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean bl = disableAnalytics = project.getGradle().getStartParameter().isOffline() || StringsKt.equals((String)"true", (String)System.getenv().get("REALM_DISABLE_ANALYTICS"), (boolean)true);
        if (!disableAnalytics) {
            this.jsonData = this.jsonPayload(project);
            METRIC_PROCESSED = false;
        }
    }

    public final synchronized void sendAnalyticsData() {
        if (!METRIC_PROCESSED) {
            String string = this.jsonData;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.logger.debug(Intrinsics.stringPlus((String)"Sending Realm analytics data: \n", (Object)this.jsonData));
                this.sendAnalytics(it, this.logger);
            }
            METRIC_PROCESSED = true;
        }
    }

    private final String jsonPayload(Project project) {
        String string;
        String string2;
        BaseExtension projectAndroidExtension;
        String userId = ComputerIdentifierGenerator.INSTANCE.get();
        String appId = this.anonymousAppId(project);
        String osType = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        BaseExtension baseExtension = projectAndroidExtension = (BaseExtension)project.getExtensions().findByName("android");
        if (baseExtension == null) {
            string2 = null;
        } else {
            DefaultConfig defaultConfig = baseExtension.getDefaultConfig();
            if (defaultConfig == null) {
                string2 = null;
            } else {
                ApiVersion apiVersion = defaultConfig.getMinSdkVersion();
                string2 = apiVersion == null ? null : apiVersion.getApiString();
            }
        }
        String minSDK = string2;
        BaseExtension baseExtension2 = projectAndroidExtension;
        if (baseExtension2 == null) {
            string = null;
        } else {
            DefaultConfig defaultConfig = baseExtension2.getDefaultConfig();
            if (defaultConfig == null) {
                string = null;
            } else {
                ApiVersion apiVersion = defaultConfig.getTargetSdkVersion();
                string = apiVersion == null ? null : apiVersion.getApiString();
            }
        }
        String targetSDK = string;
        boolean usesSync = false;
        block0: for (Configuration conf : project.getConfigurations()) {
            for (Dependency dependency : conf.getDependencies()) {
                if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"io.realm.kotlin") || !Intrinsics.areEqual((Object)dependency.getName(), (Object)"library-sync")) continue;
                usesSync = true;
                break block0;
            }
        }
        return "{\n                   \"event\": \"Run\",\n                   \"properties\": {\n                      \"token\": \"ce0fac19508f6c8f20066d345d360fd0\",\n                      \"distinct_id\": \"" + userId + "\",\n                      \"Anonymized MAC Address\": \"" + userId + "\",\n                      \"Anonymized Bundle ID\": \"" + appId + "\",\n                      \"Binding\": \"kotlin\",\n                      \"Language\": \"kotlin\",\n                      \"Realm Version\": \"1.2.0\",\n                      \"Sync Enabled\": " + (usesSync ? "true" : "false") + ",\n                      \"Host OS Type\": \"" + osType + "\",\n                      \"Host OS Version\": \"" + osVersion + "\",\n                      \"Target OS Minimum Version\": \"" + minSDK + "\",\n                      \"Target OS Version\": \"" + targetSDK + "\"\n                   }\n                }";
    }

    private final String anonymousAppId(Project project) {
        String packageName;
        String projectName;
        String string = projectName = project.getRootProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectName");
        if (((CharSequence)string).length() == 0) {
            projectName = project.getName();
        }
        if (((CharSequence)(packageName = project.getGroup().toString())).length() == 0) {
            packageName = project.getRootProject().getGroup().toString();
        }
        String string2 = packageName + '.' + projectName;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(byArray));
    }

    private final void sendAnalytics(String json, Logger logger) {
        try {
            logger.debug(Intrinsics.stringPlus((String)"Sending analytics payload\n", (Object)json));
            ExecutorService pool = Executors.newSingleThreadExecutor();
            try {
                pool.execute(() -> RealmAnalytics.sendAnalytics$lambda-1(this, json));
                pool.awaitTermination(6000L, TimeUnit.MILLISECONDS);
                logger.debug("Analytics sent.");
            }
            catch (InterruptedException e) {
                logger.debug("Sending analytics was interrupted.");
                pool.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.debug(Intrinsics.stringPlus((String)"Error when sending: ", (Object)e));
        }
    }

    private final void networkQuery(String jsonPayload) {
        try {
            URL url = new URL(Intrinsics.stringPlus((String)"https://data.mongodb-api.com/app/realmsdkmetrics-zmhtm/endpoint/metric_webhook/metric?data=", (Object)RealmAnalyticsKt.access$base64Encode(jsonPayload)));
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            connection.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void sendAnalytics$lambda-1(RealmAnalytics this$0, String $json) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$json, (String)"$json");
        this$0.networkQuery($json);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/realm/kotlin/gradle/analytics/RealmAnalytics$Companion;", "", "()V", "METRIC_PROCESSED", "", "getMETRIC_PROCESSED", "()Z", "setMETRIC_PROCESSED", "(Z)V", "gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getMETRIC_PROCESSED() {
            return METRIC_PROCESSED;
        }

        public final void setMETRIC_PROCESSED(boolean bl) {
            METRIC_PROCESSED = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

