/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import io.realm.kotlin.gradle.analytics.RealmAnalytics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/realm/kotlin/gradle/analytics/AnalyticsService;", "Lorg/gradle/api/services/BuildService;", "Lorg/gradle/api/services/BuildServiceParameters$None;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "analytics", "Lio/realm/kotlin/gradle/analytics/RealmAnalytics;", "logger", "Lorg/gradle/api/logging/Logger;", "collectAnalyticsData", "", "project", "Lorg/gradle/api/Project;", "filterResultAndSendAnalytics", "taskEvent", "Lorg/gradle/tooling/events/task/TaskFinishEvent;", "handleTaskResult", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "gradle-plugin"})
public abstract class AnalyticsService
implements BuildService<BuildServiceParameters.None>,
OperationCompletionListener {
    @NotNull
    private final Logger logger;
    @Nullable
    private RealmAnalytics analytics;

    public AnalyticsService() {
        Logger logger = Logging.getLogger((String)"realm-build-service");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\"realm-build-service\")");
        this.logger = logger;
    }

    public void onFinish(@Nullable FinishEvent event) {
        try {
            if (event == null) {
                this.logger.warn("Null event received. This should never happen.");
                return;
            }
            if (event instanceof TaskFinishEvent) {
                this.handleTaskResult((TaskFinishEvent)event);
            } else {
                this.logger.warn(Intrinsics.stringPlus((String)"Unknown event type: ", (Object)event.getClass().getName()));
            }
        }
        catch (Exception ex) {
            this.logger.warn(Intrinsics.stringPlus((String)"Unexpected error: ", (Object)ex));
        }
    }

    private final void handleTaskResult(TaskFinishEvent taskEvent) {
        TaskOperationResult taskOperationResult = taskEvent.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)taskOperationResult, (String)"taskEvent.result");
        TaskOperationResult result = taskOperationResult;
        if (!(result instanceof TaskSkippedResult)) {
            if (result instanceof TaskFailureResult) {
                this.filterResultAndSendAnalytics(taskEvent);
            } else if (result instanceof TaskSuccessResult) {
                this.filterResultAndSendAnalytics(taskEvent);
            } else {
                this.logger.warn(Intrinsics.stringPlus((String)"Unknown task type: ", (Object)result.getClass().getName()));
            }
        }
    }

    private final void filterResultAndSendAnalytics(TaskFinishEvent taskEvent) {
        String string = taskEvent.getDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskEvent.descriptor.name");
        if (StringsKt.contains((CharSequence)string, (CharSequence)"compile", (boolean)true)) {
            RealmAnalytics realmAnalytics = this.analytics;
            if (realmAnalytics != null) {
                realmAnalytics.sendAnalyticsData();
            }
        }
    }

    public final synchronized void collectAnalyticsData(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RealmAnalytics realmAnalytics = this.analytics = new RealmAnalytics();
        Intrinsics.checkNotNull((Object)realmAnalytics);
        realmAnalytics.gatherAnalyticsDataIfNeeded(project);
    }
}

