/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import io.realm.kotlin.gradle.analytics.AnalyticsService;
import io.realm.kotlin.gradle.analytics.Architecture;
import io.realm.kotlin.gradle.analytics.Host;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0011\u0010\t\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"EVENT_NAME", "", "HOST_ARCH_NAME", "getHOST_ARCH_NAME", "()Ljava/lang/String;", "HOST_OS", "Lio/realm/kotlin/gradle/analytics/Host;", "getHOST_OS", "()Lio/realm/kotlin/gradle/analytics/Host;", "HOST_OS_NAME", "getHOST_OS_NAME", "TOKEN", "URL_PREFIX", "base64Encode", "data", "", "hexStringify", "sha256Hash", "gradle-plugin"})
public final class AnalyticsServiceKt {
    @NotNull
    private static final String TOKEN = "ce0fac19508f6c8f20066d345d360fd0";
    @NotNull
    private static final String EVENT_NAME = "Run";
    @NotNull
    private static final String URL_PREFIX = "https://data.mongodb-api.com/app/realmsdkmetrics-zmhtm/endpoint/metric_webhook/metric?data=";

    @Nullable
    public static final String base64Encode(@NotNull String data) throws UnsupportedEncodingException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = data.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return AnalyticsServiceKt.base64Encode(byArray);
    }

    @Nullable
    public static final String base64Encode(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return DatatypeConverter.printBase64Binary((byte[])data);
    }

    @NotNull
    public static final byte[] sha256Hash(@Nullable byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = messageDigest.digest(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return byArray;
    }

    @NotNull
    public static final String hexStringify(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        StringBuilder stringBuilder = new StringBuilder();
        for (byte singleByte : data) {
            String string = Integer.toString((byte)(singleByte & (byte)255) + 256, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            stringBuilder.append(string2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final Host getHOST_OS() {
        Host host;
        String hostOs = System.getProperty("os.name");
        Intrinsics.checkNotNull((Object)hostOs);
        if (StringsKt.contains((CharSequence)hostOs, (CharSequence)"windows", (boolean)true)) {
            host = Host.WINDOWS;
        } else if (StringsKt.contains((CharSequence)hostOs, (CharSequence)"inux", (boolean)true)) {
            host = Host.LINUX;
        } else if (StringsKt.contains((CharSequence)hostOs, (CharSequence)"mac", (boolean)true)) {
            host = Host.MACOS;
        } else {
            throw new IllegalArgumentException(hostOs);
        }
        return host;
    }

    @NotNull
    public static final String getHOST_OS_NAME() {
        String string;
        try {
            string = AnalyticsServiceKt.getHOST_OS().getSerializedName();
        }
        catch (Throwable e) {
            string = AnalyticsService.Companion.unknown$gradle_plugin(System.getProperty("os.name"));
        }
        return string;
    }

    @NotNull
    public static final String getHOST_ARCH_NAME() {
        boolean bl = false;
        String hostArch = System.getProperty("os.arch");
        Intrinsics.checkNotNull((Object)hostArch);
        return StringsKt.contains$default((CharSequence)hostArch, (CharSequence)"x86", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)hostArch, (CharSequence)"64", (boolean)false, (int)2, null) ? Architecture.X64.getSerializedName() : (StringsKt.contains$default((CharSequence)hostArch, (CharSequence)"x86", (boolean)false, (int)2, null) ? Architecture.X64.getSerializedName() : (StringsKt.contains$default((CharSequence)hostArch, (CharSequence)"aarch", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)hostArch, (CharSequence)"64", (boolean)false, (int)2, null) ? Architecture.ARM64.getSerializedName() : (StringsKt.contains$default((CharSequence)hostArch, (CharSequence)"aarch", (boolean)false, (int)2, null) ? Architecture.ARM.getSerializedName() : AnalyticsService.Companion.unknown$gradle_plugin(hostArch))));
    }
}

