/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import io.realm.kotlin.gradle.analytics.AnalyticsService;
import io.realm.kotlin.gradle.analytics.AnalyticsServiceKt;
import io.realm.kotlin.gradle.analytics.HostIdentifier;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\f"}, d2={"Lio/realm/kotlin/gradle/analytics/BuilderId;", "Lio/realm/kotlin/gradle/analytics/HostIdentifier;", "()V", "linuxIdentifier", "", "getLinuxIdentifier", "()Ljava/lang/String;", "macOsIdentifier", "getMacOsIdentifier", "windowsIdentifier", "getWindowsIdentifier", "obtain", "gradle-plugin"})
public abstract class BuilderId
extends HostIdentifier {
    @Override
    @NotNull
    public String getLinuxIdentifier() {
        return ((Object)StringsKt.trim((CharSequence)ByteStreamsKt.readBytes((InputStream)new FileInputStream(new File("/etc/machine-id"))).toString())).toString();
    }

    @Override
    @NotNull
    public String getMacOsIdentifier() {
        Regex regEx = new Regex(".*\"IOPlatformUUID\"\\s=\\s\"(.+)\"");
        Object[] objectArray = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice"};
        String output = this.exec(CollectionsKt.listOf((Object[])objectArray));
        MatchResult find = Regex.find$default((Regex)regEx, (CharSequence)output, (int)0, (int)2, null);
        MatchResult matchResult = find;
        String string = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
        Intrinsics.checkNotNull(string);
        return string;
    }

    @Override
    @NotNull
    public String getWindowsIdentifier() {
        Regex regEx = new Regex("\\s*MachineGuid\\s*\\w*\\s*([A-Za-z0-9-]+)");
        Object[] objectArray = new String[]{"reg", "QUERY", "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Cryptography", "/v", "MachineGuid"};
        String output = this.exec(CollectionsKt.listOf((Object[])objectArray));
        MatchResult find = Regex.find$default((Regex)regEx, (CharSequence)output, (int)0, (int)2, null);
        MatchResult matchResult = find;
        String string = matchResult != null && (matchResult = matchResult.getGroups()) != null && (matchResult = matchResult.get(1)) != null ? matchResult.getValue() : null;
        Intrinsics.checkNotNull(string);
        return string;
    }

    @NotNull
    public String obtain() {
        return this.withDefaultOnError("BuilderID", AnalyticsService.Companion.unknown$gradle_plugin$default(AnalyticsService.Companion, null, 1, null), (Function0)new Function0<String>(this){
            final /* synthetic */ BuilderId this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String data;
                String id = this.this$0.getIdentifier();
                String string = data = "Realm is great" + id;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                String string2 = AnalyticsServiceKt.base64Encode(AnalyticsServiceKt.sha256Hash(byArray));
                Intrinsics.checkNotNull((Object)string2);
                return string2;
            }
        });
    }
}

