/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.gradle.analytics;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.bind.DatatypeConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u00020\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"EVENT_NAME", "", "TOKEN", "URL_PREFIX", "base64Encode", "data", "hexStringify", "", "sha256Hash", "gradle-plugin"})
public final class RealmAnalyticsKt {
    @NotNull
    private static final String TOKEN = "ce0fac19508f6c8f20066d345d360fd0";
    @NotNull
    private static final String EVENT_NAME = "Run";
    @NotNull
    private static final String URL_PREFIX = "https://data.mongodb-api.com/app/realmsdkmetrics-zmhtm/endpoint/metric_webhook/metric?data=";

    @Nullable
    public static final String base64Encode(@NotNull String data) throws UnsupportedEncodingException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = data.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return DatatypeConverter.printBase64Binary((byte[])byArray);
    }

    @NotNull
    public static final byte[] sha256Hash(@Nullable byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = messageDigest.digest(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"messageDigest.digest(data)");
        return byArray;
    }

    @NotNull
    public static final String hexStringify(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        StringBuilder stringBuilder = new StringBuilder();
        for (byte singleByte : data) {
            String string = Integer.toString((byte)(singleByte & (byte)255) + 256, CharsKt.checkRadix((int)16));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            stringBuilder.append(string2);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }
}

