/*
 * Decompiled with CFR 0.152.
 */
package io.realm.gradle;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.builder.model.ApiVersion;
import io.realm.gradle.ComputerIdentifierGenerator;
import io.realm.gradle.RealmAnalyticsKt;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskState;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0015"}, d2={"Lio/realm/gradle/RealmAnalytics;", "Lorg/gradle/api/execution/TaskExecutionAdapter;", "()V", "afterExecute", "", "task", "Lorg/gradle/api/Task;", "state", "Lorg/gradle/api/tasks/TaskState;", "anonymousAppId", "", "project", "Lorg/gradle/api/Project;", "jsonPayload", "networkQuery", "sendAnalytics", "json", "logger", "Lorg/gradle/api/logging/Logger;", "sendMetricIfNeeded", "Companion", "gradle-plugin"})
public final class RealmAnalytics
extends TaskExecutionAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static volatile boolean METRIC_PROCESSED;

    public void afterExecute(@NotNull Task task, @NotNull TaskState state) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!state.getSkipped()) {
            String string = task.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
            if (StringsKt.startsWith$default((String)string, (String)"compile", (boolean)false, (int)2, null)) {
                string = task.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.project");
                this.sendMetricIfNeeded((Project)string);
            }
        }
    }

    private final synchronized void sendMetricIfNeeded(Project project) {
        if (!METRIC_PROCESSED) {
            boolean disableAnalytics;
            boolean bl = disableAnalytics = project.getGradle().getStartParameter().isOffline() || StringsKt.equals((String)"true", (String)System.getenv().get("REALM_DISABLE_ANALYTICS"), (boolean)true);
            if (!disableAnalytics) {
                String json = this.jsonPayload(project);
                Logger logger = project.getLogger();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"project.logger");
                this.sendAnalytics(json, logger);
            }
            METRIC_PROCESSED = true;
        }
    }

    private final String jsonPayload(Project project) {
        String string;
        String string2;
        BaseExtension projectAndroidExtension;
        String userId = ComputerIdentifierGenerator.INSTANCE.get();
        String appId = this.anonymousAppId(project);
        String osType = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        BaseExtension baseExtension = projectAndroidExtension = (BaseExtension)project.getExtensions().findByName("android");
        if (baseExtension == null) {
            string2 = null;
        } else {
            DefaultConfig defaultConfig = baseExtension.getDefaultConfig();
            if (defaultConfig == null) {
                string2 = null;
            } else {
                ApiVersion apiVersion = defaultConfig.getMinSdkVersion();
                string2 = apiVersion == null ? null : apiVersion.getApiString();
            }
        }
        String minSDK = string2;
        BaseExtension baseExtension2 = projectAndroidExtension;
        if (baseExtension2 == null) {
            string = null;
        } else {
            DefaultConfig defaultConfig = baseExtension2.getDefaultConfig();
            if (defaultConfig == null) {
                string = null;
            } else {
                ApiVersion apiVersion = defaultConfig.getTargetSdkVersion();
                string = apiVersion == null ? null : apiVersion.getApiString();
            }
        }
        String targetSDK = string;
        boolean usesSync = false;
        block2: for (Configuration conf : project.getConfigurations()) {
            try {
                for (Object object : conf.getResolvedConfiguration().getResolvedArtifacts()) {
                    Intrinsics.checkNotNullExpressionValue(object, (String)"conf.resolvedConfiguration.resolvedArtifacts");
                    ResolvedArtifact artifact = (ResolvedArtifact)object;
                    object = artifact.getName();
                    Intrinsics.checkNotNullExpressionValue(object, (String)"artifact.name");
                    if (!StringsKt.startsWith$default(object, (String)"library-sync", (boolean)false, (int)2, null)) continue;
                    usesSync = true;
                    break block2;
                }
            }
            catch (Exception exception) {
            }
        }
        return "{\n                   \"event\": \"Run\",\n                   \"properties\": {\n                      \"token\": \"ce0fac19508f6c8f20066d345d360fd0\",\n                      \"distinct_id\": \"" + userId + "\",\n                      \"Anonymized MAC Address\": \"" + userId + "\",\n                      \"Anonymized Bundle ID\": \"" + appId + "\",\n                      \"Binding\": \"kotlin\",\n                      \"Language\": \"kotlin\",\n                      \"Realm Version\": \"0.8.2\",\n                      \"Sync Enabled\": " + (usesSync ? "true" : "false") + ",\n                      \"Host OS Type\": \"" + osType + "\",\n                      \"Host OS Version\": \"" + osVersion + "\",\n                      \"Target OS Minimum Version\": \"" + minSDK + "\",\n                      \"Target OS Version\": \"" + targetSDK + "\"\n                   }\n                }";
    }

    private final String anonymousAppId(Project project) {
        String packageName;
        String projectName;
        String string = projectName = project.getRootProject().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectName");
        if (((CharSequence)string).length() == 0) {
            projectName = project.getName();
        }
        if (((CharSequence)(packageName = project.getGroup().toString())).length() == 0) {
            packageName = project.getRootProject().getGroup().toString();
        }
        String string2 = packageName + '.' + projectName;
        Charset charset = Charsets.UTF_8;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(byArray));
    }

    private final void sendAnalytics(String json, Logger logger) {
        try {
            logger.log(LogLevel.DEBUG, Intrinsics.stringPlus((String)"REALM ANALYTICS: sending payload\n", (Object)json));
            ExecutorService pool = Executors.newSingleThreadExecutor();
            try {
                pool.execute(() -> RealmAnalytics.sendAnalytics$lambda-0(this, json));
                pool.awaitTermination(6000L, TimeUnit.MILLISECONDS);
                logger.log(LogLevel.DEBUG, "REALM ANALYTICS: transfer completed");
            }
            catch (InterruptedException e) {
                logger.log(LogLevel.DEBUG, "REALM ANALYTICS: transfer interrupted");
                pool.shutdownNow();
            }
        }
        catch (Exception e) {
            logger.log(LogLevel.DEBUG, "REALM ANALYTICS: transfer failed");
            System.err.println(Intrinsics.stringPlus((String)"Could not send analytics: ", (Object)e));
        }
    }

    private final void networkQuery(String jsonPayload) {
        try {
            URL url = new URL(Intrinsics.stringPlus((String)"https://webhooks.mongodb-realm.com/api/client/v2.0/app/realmsdkmetrics-zmhtm/service/metric_webhook/incoming_webhook/metric?data=", (Object)RealmAnalyticsKt.access$base64Encode(jsonPayload)));
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            connection.connect();
            connection.getResponseCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final void sendAnalytics$lambda-0(RealmAnalytics this$0, String $json) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$json, (String)"$json");
        this$0.networkQuery($json);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/realm/gradle/RealmAnalytics$Companion;", "", "()V", "METRIC_PROCESSED", "", "getMETRIC_PROCESSED", "()Z", "setMETRIC_PROCESSED", "(Z)V", "gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getMETRIC_PROCESSED() {
            return METRIC_PROCESSED;
        }

        public final void setMETRIC_PROCESSED(boolean bl) {
            METRIC_PROCESSED = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

