/*
 * Decompiled with CFR 0.152.
 */
package io.realm.gradle.analytics;

import io.realm.gradle.analytics.RealmAnalyticsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\t\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/realm/gradle/analytics/ComputerIdentifierGenerator;", "", "()V", "OS", "", "UNKNOWN", "isLinux", "", "()Z", "isMac", "isWindows", "linuxMacAddress", "getLinuxMacAddress", "()Ljava/lang/String;", "macOsIdentifier", "getMacOsIdentifier", "windowsIdentifier", "getWindowsIdentifier", "get", "gradle-plugin"})
public final class ComputerIdentifierGenerator {
    @NotNull
    public static final ComputerIdentifierGenerator INSTANCE = new ComputerIdentifierGenerator();
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String OS;

    private ComputerIdentifierGenerator() {
    }

    @NotNull
    public final String get() {
        String string;
        try {
            string = this.isWindows() ? this.getWindowsIdentifier() : (this.isMac() ? this.getMacOsIdentifier() : (this.isLinux() ? this.getLinuxMacAddress() : UNKNOWN));
        }
        catch (Exception e) {
            string = UNKNOWN;
        }
        return string;
    }

    private final boolean isWindows() {
        return StringsKt.contains$default((CharSequence)OS, (CharSequence)"win", (boolean)false, (int)2, null);
    }

    private final boolean isMac() {
        return StringsKt.contains$default((CharSequence)OS, (CharSequence)"mac", (boolean)false, (int)2, null);
    }

    private final boolean isLinux() {
        return StringsKt.contains$default((CharSequence)OS, (CharSequence)"inux", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getLinuxMacAddress() throws FileNotFoundException, NoSuchAlgorithmException {
        String string;
        File machineId = new File("/var/lib/dbus/machine-id");
        if (!machineId.exists()) {
            machineId = new File("/etc/machine-id");
        }
        if (!machineId.exists()) {
            return UNKNOWN;
        }
        Scanner scanner = null;
        try {
            scanner = new Scanner(machineId);
            String id = scanner.useDelimiter("\\A").next();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            Object object = id;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            string = RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(byArray));
            object = scanner;
            ((Scanner)object).close();
        }
        catch (Throwable throwable) {
            Scanner scanner2 = scanner;
            if (scanner2 != null) {
                scanner2.close();
            }
            throw throwable;
        }
        return string;
    }

    private final String getMacOsIdentifier() throws SocketException, NoSuchAlgorithmException {
        NetworkInterface networkInterface = NetworkInterface.getByName("en0");
        byte[] hardwareAddress = networkInterface.getHardwareAddress();
        return RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(hardwareAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getWindowsIdentifier() throws IOException, NoSuchAlgorithmException {
        String string;
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[]{"wmic", "csproduct", "get", "UUID"};
        Process process = runtime.exec(stringArray);
        String result = null;
        InputStream is = process.getInputStream();
        Scanner sc = new Scanner(process.getInputStream());
        Closeable closeable = is;
        Object object = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            while (sc.hasNext()) {
                String next = sc.next();
                Intrinsics.checkNotNullExpressionValue((Object)next, (String)"next");
                if (!StringsKt.contains$default((CharSequence)next, (CharSequence)"UUID", (boolean)false, (int)2, null)) continue;
                String string2 = sc.next();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sc.next()");
                String $this$trim$iv = string2;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it2 = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl2 = false;
                    boolean bl3 = match$iv$iv = Intrinsics.compare((int)it2, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                result = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        String string3 = result;
        if (string3 == null) {
            string = UNKNOWN;
        } else {
            closeable = string3;
            object = Charsets.UTF_8;
            byte[] byArray = ((String)((Object)closeable)).getBytes((Charset)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            string = RealmAnalyticsKt.access$hexStringify(RealmAnalyticsKt.access$sha256Hash(byArray));
        }
        return string;
    }

    static {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        OS = string2;
    }
}

