/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.interop.sync;

import io.realm.kotlin.internal.interop.CapiT;
import io.realm.kotlin.internal.interop.NativePointer;
import io.realm.kotlin.internal.interop.RealmInterop;
import io.realm.kotlin.internal.interop.sync.WebsocketErrorCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fR\u001a\u0010\u0002\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/realm/kotlin/internal/interop/sync/WebSocketObserver;", "", "webSocketObserverPointer", "Lio/realm/kotlin/internal/interop/RealmWebsocketProviderPointer;", "Lio/realm/kotlin/internal/interop/NativePointer;", "Lio/realm/kotlin/internal/interop/CapiT;", "<init>", "(Lio/realm/kotlin/internal/interop/NativePointer;)V", "Lio/realm/kotlin/internal/interop/NativePointer;", "onConnected", "", "protocol", "", "onError", "onNewMessage", "", "data", "", "onClose", "wasClean", "errorCode", "Lio/realm/kotlin/internal/interop/sync/WebsocketErrorCode;", "reason", "cinterop"})
public final class WebSocketObserver {
    @NotNull
    private final NativePointer<CapiT> webSocketObserverPointer;

    public WebSocketObserver(@NotNull NativePointer<CapiT> webSocketObserverPointer) {
        Intrinsics.checkNotNullParameter(webSocketObserverPointer, (String)"webSocketObserverPointer");
        this.webSocketObserverPointer = webSocketObserverPointer;
    }

    public final void onConnected(@NotNull String protocol) {
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        RealmInterop.INSTANCE.realm_sync_socket_websocket_connected(this.webSocketObserverPointer, protocol);
    }

    public final void onError() {
        RealmInterop.INSTANCE.realm_sync_socket_websocket_error(this.webSocketObserverPointer);
    }

    public final boolean onNewMessage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return RealmInterop.INSTANCE.realm_sync_socket_websocket_message(this.webSocketObserverPointer, data);
    }

    public final void onClose(boolean wasClean, @NotNull WebsocketErrorCode errorCode, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        RealmInterop.INSTANCE.realm_sync_socket_websocket_closed(this.webSocketObserverPointer, wasClean, errorCode, reason);
    }
}

