/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.interop.sync;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J=\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0013\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001a\u00a2\u0006\u0002\u0010\u001bJ\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u001e"}, d2={"Lio/realm/kotlin/internal/interop/sync/Response;", "", "httpResponseCode", "", "customResponseCode", "headers", "", "", "body", "(IILjava/util/Map;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getCustomResponseCode", "()I", "getHeaders", "()Ljava/util/Map;", "getHttpResponseCode", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getJNIFriendlyHeaders", "", "()[Ljava/lang/String;", "hashCode", "toString", "cinterop"})
public final class Response {
    private final int httpResponseCode;
    private final int customResponseCode;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final String body;

    public Response(int httpResponseCode, int customResponseCode, @NotNull Map<String, String> headers, @NotNull String body) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this.httpResponseCode = httpResponseCode;
        this.customResponseCode = customResponseCode;
        this.headers = headers;
        this.body = body;
    }

    public final int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public final int getCustomResponseCode() {
        return this.customResponseCode;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final String getBody() {
        return this.body;
    }

    @NotNull
    public final String[] getJNIFriendlyHeaders() {
        String[] jniHeaders = new String[this.headers.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            jniHeaders[i] = key;
            jniHeaders[i + 1] = value;
            i += 2;
        }
        return jniHeaders;
    }

    public final int component1() {
        return this.httpResponseCode;
    }

    public final int component2() {
        return this.customResponseCode;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @NotNull
    public final String component4() {
        return this.body;
    }

    @NotNull
    public final Response copy(int httpResponseCode, int customResponseCode, @NotNull Map<String, String> headers, @NotNull String body) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return new Response(httpResponseCode, customResponseCode, headers, body);
    }

    public static /* synthetic */ Response copy$default(Response response, int n, int n2, Map map, String string, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = response.httpResponseCode;
        }
        if ((n3 & 2) != 0) {
            n2 = response.customResponseCode;
        }
        if ((n3 & 4) != 0) {
            map = response.headers;
        }
        if ((n3 & 8) != 0) {
            string = response.body;
        }
        return response.copy(n, n2, map, string);
    }

    @NotNull
    public String toString() {
        return "Response(httpResponseCode=" + this.httpResponseCode + ", customResponseCode=" + this.customResponseCode + ", headers=" + this.headers + ", body=" + this.body + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.httpResponseCode);
        result = result * 31 + Integer.hashCode(this.customResponseCode);
        result = result * 31 + ((Object)this.headers).hashCode();
        result = result * 31 + this.body.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Response)) {
            return false;
        }
        Response response = (Response)other;
        if (this.httpResponseCode != response.httpResponseCode) {
            return false;
        }
        if (this.customResponseCode != response.customResponseCode) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, response.headers)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.body, (Object)response.body);
    }
}

