/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.jvm;

import io.realm.kotlin.jvm.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/realm/kotlin/jvm/SoLoader;", "", "()V", "libraryName", "", "platform", "Lio/realm/kotlin/jvm/Platform;", "defaultAbsolutePath", "Ljava/io/File;", "libPathInsideJar", "load", "", "unpackAndInstall", "absolutePath", "cinterop"})
public final class SoLoader {
    @NotNull
    private final Platform platform = Platform.Companion.currentOS();
    @NotNull
    private final String libraryName;

    public SoLoader() {
        this.libraryName = "realmc";
    }

    public final void load() {
        try {
            System.loadLibrary(this.libraryName);
        }
        catch (UnsatisfiedLinkError ex) {
            this.load(this.libraryName);
        }
    }

    private final void load(String libraryName) {
        File libraryInstallationLocation = this.defaultAbsolutePath(libraryName);
        if (!libraryInstallationLocation.exists()) {
            this.unpackAndInstall(libraryName, libraryInstallationLocation);
        }
        System.load(libraryInstallationLocation.getAbsolutePath());
    }

    private final File defaultAbsolutePath(String libraryName) {
        return new File(this.platform.getDefaultSystemLocation() + File.separator + "1.15.0" + File.separator + this.platform.getPrefix() + libraryName + '.' + this.platform.getSuffix());
    }

    private final String libPathInsideJar(String libraryName) {
        return this.platform.getShortName() + '/' + this.platform.getPrefix() + libraryName + '.' + this.platform.getSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unpackAndInstall(String libraryName, File absolutePath) {
        absolutePath.getParentFile().mkdirs();
        Closeable closeable = this.getClass().getResourceAsStream(this.libPathInsideJar(libraryName));
        Throwable throwable = null;
        try {
            long l;
            InputStream lib = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = Files.newOutputStream(absolutePath.toPath(), new OpenOption[0]);
            Throwable throwable2 = null;
            try {
                OutputStream it = (OutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)lib);
                Intrinsics.checkNotNull((Object)it);
                l = ByteStreamsKt.copyTo$default((InputStream)lib, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

