/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.interop.gc;

import io.realm.kotlin.internal.interop.LongPointerWrapper;
import io.realm.kotlin.internal.interop.gc.NativeObjectReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/realm/kotlin/internal/interop/gc/FinalizerRunnable;", "Ljava/lang/Runnable;", "referenceQueue", "Ljava/lang/ref/ReferenceQueue;", "Lio/realm/kotlin/internal/interop/LongPointerWrapper;", "(Ljava/lang/ref/ReferenceQueue;)V", "run", "", "cinterop"})
public final class FinalizerRunnable
implements Runnable {
    @NotNull
    private final ReferenceQueue<LongPointerWrapper<?>> referenceQueue;

    public FinalizerRunnable(@NotNull ReferenceQueue<LongPointerWrapper<?>> referenceQueue) {
        Intrinsics.checkNotNullParameter(referenceQueue, (String)"referenceQueue");
        this.referenceQueue = referenceQueue;
    }

    @Override
    public void run() {
        try {
            while (true) {
                Reference<LongPointerWrapper<?>> reference = this.referenceQueue.remove();
                Intrinsics.checkNotNull(reference, (String)"null cannot be cast to non-null type io.realm.kotlin.internal.interop.gc.NativeObjectReference");
                NativeObjectReference reference2 = (NativeObjectReference)reference;
                reference2.cleanup();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String string = "The FinalizerRunnable thread has been interrupted. Native resources cannot be freed anymore";
            System.out.println((Object)string);
            return;
        }
    }
}

