/*
 * Decompiled with CFR 0.152.
 */
package io.realm.kotlin.internal.interop;

import io.realm.kotlin.internal.interop.ErrorCategory;
import io.realm.kotlin.internal.interop.ErrorCode;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\r"}, d2={"Lio/realm/kotlin/internal/interop/CoreErrorConverter;", "", "()V", "asThrowable", "", "categoriesNativeValue", "", "errorCodeNativeValue", "messageNativeValue", "", "path", "userError", "CategoryFlag", "cinterop"})
public final class CoreErrorConverter {
    @NotNull
    public static final CoreErrorConverter INSTANCE = new CoreErrorConverter();

    private CoreErrorConverter() {
    }

    @JvmStatic
    @NotNull
    public static final Throwable asThrowable(int categoriesNativeValue, int errorCodeNativeValue, @Nullable String messageNativeValue, @Nullable String path, @Nullable Throwable userError) {
        CategoryFlag categories = new CategoryFlag(categoriesNativeValue);
        ErrorCode errorCode = ErrorCode.Companion.of(errorCodeNativeValue);
        String message = "" + '[' + errorCode + "]: " + messageNativeValue;
        Throwable throwable = userError;
        if (throwable == null) {
            throwable = ErrorCode.RLM_ERR_INDEX_OUT_OF_BOUNDS == errorCode ? (Throwable)new IndexOutOfBoundsException(message) : (categories.contains(ErrorCategory.RLM_ERR_CAT_INVALID_ARG) ? (Throwable)new IllegalArgumentException(message) : (categories.contains(ErrorCategory.RLM_ERR_CAT_LOGIC) || categories.contains(ErrorCategory.RLM_ERR_CAT_RUNTIME) ? (Throwable)new IllegalStateException(message) : (Throwable)new Error(message)));
        }
        return throwable;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/realm/kotlin/internal/interop/CoreErrorConverter$CategoryFlag;", "", "categoryCode", "", "(I)V", "getCategoryCode", "()I", "component1", "contains", "", "other", "Lio/realm/kotlin/internal/interop/ErrorCategory;", "copy", "equals", "hashCode", "toString", "", "cinterop"})
    public static final class CategoryFlag {
        private final int categoryCode;

        public CategoryFlag(int categoryCode) {
            this.categoryCode = categoryCode;
        }

        public final int getCategoryCode() {
            return this.categoryCode;
        }

        public final boolean contains(@NotNull ErrorCategory other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return (this.categoryCode & other.getNativeValue()) != 0;
        }

        public final int component1() {
            return this.categoryCode;
        }

        @NotNull
        public final CategoryFlag copy(int categoryCode) {
            return new CategoryFlag(categoryCode);
        }

        public static /* synthetic */ CategoryFlag copy$default(CategoryFlag categoryFlag, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = categoryFlag.categoryCode;
            }
            return categoryFlag.copy(n);
        }

        @NotNull
        public String toString() {
            return "CategoryFlag(categoryCode=" + this.categoryCode + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.categoryCode);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CategoryFlag)) {
                return false;
            }
            CategoryFlag categoryFlag = (CategoryFlag)other;
            return this.categoryCode == categoryFlag.categoryCode;
        }
    }
}

