/*
 * Decompiled with CFR 0.152.
 */
package io.realm.internal.interop.sync;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0014B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0011\b\u0002\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0003J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0007H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/realm/internal/interop/sync/PartitionValue;", "", "value", "", "(Ljava/lang/String;)V", "", "(Ljava/lang/Long;)V", "", "(Ljava/lang/Integer;)V", "bsonValue", "(Ljava/lang/Object;)V", "getBsonValue", "()Ljava/lang/Object;", "valueType", "Lio/realm/internal/interop/sync/PartitionValue$ValueType;", "asSyncPartition", "equals", "", "other", "hashCode", "ValueType", "cinterop"})
public final class PartitionValue {
    @Nullable
    private final Object bsonValue;
    @NotNull
    private final ValueType valueType;

    private PartitionValue(Object bsonValue) {
        ValueType valueType;
        this.bsonValue = bsonValue;
        Object object = this.bsonValue;
        if (object instanceof String) {
            valueType = ValueType.STRING;
        } else if (object instanceof Long) {
            valueType = ValueType.LONG;
        } else if (object instanceof Integer) {
            valueType = ValueType.INT;
        } else if (object == null) {
            valueType = ValueType.NULL;
        } else {
            throw new NotImplementedError(Intrinsics.stringPlus((String)"An operation is not implemented: ", (Object)Intrinsics.stringPlus((String)"Unsupported type: ", (Object)Reflection.getOrCreateKotlinClass(this.bsonValue.getClass()))));
        }
        this.valueType = valueType;
    }

    @Nullable
    public final Object getBsonValue() {
        return this.bsonValue;
    }

    public PartitionValue(@Nullable String value) {
        this((Object)value);
    }

    public PartitionValue(@Nullable Long value) {
        this((Object)value);
    }

    public PartitionValue(@Nullable Integer value) {
        this((Object)value);
    }

    @NotNull
    public final String asSyncPartition() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.valueType.ordinal()]) {
            case 1: {
                Object object = this.bsonValue;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                string = '\"' + (String)object + '\"';
                break;
            }
            case 2: {
                Object object = this.bsonValue;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                }
                string = "{\"$numberLong\":\"" + (Long)object + "\"}";
                break;
            }
            case 3: {
                Object object = this.bsonValue;
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                string = "{\"$numberInt\":\"" + (Integer)object + "\"}";
                break;
            }
            case 4: {
                string = "null";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PartitionValue && Intrinsics.areEqual((Object)this.asSyncPartition(), (Object)((PartitionValue)other).asSyncPartition());
    }

    public int hashCode() {
        int n;
        Object object = this.bsonValue;
        int result = object == null ? 0 : (n = object.hashCode());
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/realm/internal/interop/sync/PartitionValue$ValueType;", "", "(Ljava/lang/String;I)V", "STRING", "LONG", "INT", "NULL", "cinterop"})
    private static final class ValueType
    extends Enum<ValueType> {
        public static final /* enum */ ValueType STRING = new ValueType();
        public static final /* enum */ ValueType LONG = new ValueType();
        public static final /* enum */ ValueType INT = new ValueType();
        public static final /* enum */ ValueType NULL = new ValueType();
        private static final /* synthetic */ ValueType[] $VALUES;

        public static ValueType[] values() {
            return (ValueType[])$VALUES.clone();
        }

        public static ValueType valueOf(String value) {
            return Enum.valueOf(ValueType.class, value);
        }

        static {
            $VALUES = valueTypeArray = new ValueType[]{ValueType.STRING, ValueType.LONG, ValueType.INT, ValueType.NULL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            nArray[ValueType.STRING.ordinal()] = 1;
            nArray[ValueType.LONG.ordinal()] = 2;
            nArray[ValueType.INT.ordinal()] = 3;
            nArray[ValueType.NULL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

