/*
 * Decompiled with CFR 0.152.
 */
package io.realm.jvm;

import io.realm.jvm.OrderedProperties;
import io.realm.jvm.Platform;
import io.realm.jvm.SoLoader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0002J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\"\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00062\b\b\u0002\u0010\u0019\u001a\u00020\u000eH\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u001bH\u0002R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/realm/jvm/SoLoader;", "", "()V", "libs", "", "Lkotlin/Pair;", "", "platform", "Lio/realm/jvm/Platform;", "defaultAbsolutePath", "Ljava/io/File;", "libraryName", "libraryHash", "isValidHash", "", "file", "expected", "libPathInsideJar", "load", "", "expectedHash", "readLibrariesHashes", "unpackAndInstall", "absolutePath", "validHashOrThrow", "cleanup", "toHexString", "", "cinterop"})
public final class SoLoader {
    @NotNull
    private final Platform platform = Platform.Companion.currentOS();
    @NotNull
    private final List<Pair<String, String>> libs = new ArrayList();

    public SoLoader() {
        this.readLibrariesHashes();
    }

    public final void load() {
        for (Pair<String, String> lib : this.libs) {
            this.load((String)lib.getFirst(), (String)lib.getSecond());
        }
    }

    private final void load(String libraryName, String expectedHash) {
        File libraryInstallationLocation = this.defaultAbsolutePath(libraryName, expectedHash);
        if (!libraryInstallationLocation.exists()) {
            this.unpackAndInstall(libraryName, libraryInstallationLocation, expectedHash);
        } else {
            SoLoader.validHashOrThrow$default(this, libraryInstallationLocation, expectedHash, false, 4, null);
        }
        System.load(libraryInstallationLocation.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readLibrariesHashes() {
        Closeable closeable = this.getClass().getResourceAsStream(Intrinsics.stringPlus((String)this.platform.getShortName(), (Object)"/dynamic_libraries.properties"));
        Throwable throwable = null;
        try {
            InputStream props = (InputStream)closeable;
            boolean bl = false;
            OrderedProperties $this$readLibrariesHashes_u24lambda_u2d1_u24lambda_u2d0 = new OrderedProperties();
            boolean bl2 = false;
            $this$readLibrariesHashes_u24lambda_u2d1_u24lambda_u2d0.load(props);
            Iterator iterator = CollectionsKt.iterator($this$readLibrariesHashes_u24lambda_u2d1_u24lambda_u2d0.keys());
            while (iterator.hasNext()) {
                Object libName = iterator.next();
                Object object = $this$readLibrariesHashes_u24lambda_u2d1_u24lambda_u2d0.get(libName);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                this.libs.add((Pair<String, String>)new Pair((Object)((String)libName), (Object)((String)object)));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final File defaultAbsolutePath(String libraryName, String libraryHash) {
        return new File(this.platform.getDefaultSystemLocation() + File.separator + libraryHash + File.separator + this.platform.getPrefix() + libraryName + '.' + this.platform.getSuffix());
    }

    private final String libPathInsideJar(String libraryName) {
        return this.platform.getShortName() + '/' + this.platform.getPrefix() + libraryName + '.' + this.platform.getSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void unpackAndInstall(String libraryName, File absolutePath, String expectedHash) {
        absolutePath.getParentFile().mkdirs();
        Closeable closeable = this.getClass().getResourceAsStream(this.libPathInsideJar(libraryName));
        Throwable throwable = null;
        try {
            long l;
            InputStream lib = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = Files.newOutputStream(absolutePath.toPath(), new OpenOption[0]);
            Throwable throwable2 = null;
            try {
                OutputStream it = (OutputStream)closeable2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)lib, (String)"lib");
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                l = ByteStreamsKt.copyTo$default((InputStream)lib, (OutputStream)it, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        SoLoader.validHashOrThrow$default(this, absolutePath, expectedHash, false, 4, null);
    }

    private final void validHashOrThrow(File file, String expectedHash, boolean cleanup) {
        if (!this.isValidHash(file, expectedHash)) {
            if (cleanup) {
                file.delete();
            }
            throw new IllegalStateException(("Corrupt or invalid hash for " + file.getAbsolutePath() + " expected hash is " + expectedHash).toString());
        }
    }

    static /* synthetic */ void validHashOrThrow$default(SoLoader soLoader, File file, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        soLoader.validHashOrThrow(file, string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isValidHash(File file, String expected) {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        Closeable closeable = Files.newInputStream(file.toPath(), new OpenOption[0]);
        Throwable throwable = null;
        try {
            int bytes;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            byte[] buf = new byte[16384];
            while ((bytes = it.read(buf)) > 0) {
                digest.update(buf, 0, bytes);
            }
            byte[] byArray = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
            String hash = this.toHexString(byArray);
            boolean bl2 = Intrinsics.areEqual((Object)hash, (Object)expected);
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final String toHexString(byte[] $this$toHexString) {
        return ArraysKt.joinToString$default((byte[])$this$toHexString, (CharSequence)"", null, null, (int)0, null, (Function1)toHexString.1.INSTANCE, (int)30, null);
    }
}

