/*
 * Decompiled with CFR 0.152.
 */
package io.reacted.patterns;

import io.reacted.patterns.ObjectUtils;
import io.reacted.patterns.UnChecked;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class Try<T> {
    public static final Try<Void> VOID = Try.of(() -> Try.noOp(new Object[0]));
    private static final UnsupportedOperationException FAILURE_UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException("Failure has not result value");
    private static final UnsupportedOperationException SUCCESS_UNSUPPORTED_OPERATION_EXCEPTION = new UnsupportedOperationException("Success has no failure cause");

    private Try() {
    }

    public static Void noOp(Object ... args) {
        return ObjectUtils.VOID;
    }

    public static <U> Try<U> identity(Try<U> value) {
        return value;
    }

    public static <U> U identity(U value) {
        return value;
    }

    public abstract boolean isSuccess();

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public abstract Throwable getCause();

    public abstract T get();

    public Optional<T> toOptional() {
        return this.isSuccess() ? Optional.ofNullable(this.get()) : Optional.empty();
    }

    public Stream<T> stream() {
        return this.toOptional().stream();
    }

    public static <T, A extends AutoCloseable> Try<T> withResources(TryResourceSupplier<? extends A> resourceSupplier, TryMapper<? super A, ? extends T> resourceToResult) {
        Success<T> success;
        block8: {
            AutoCloseable resource = (AutoCloseable)Objects.requireNonNull(resourceSupplier).get();
            try {
                success = Try.ofSuccess(Objects.requireNonNull(resourceToResult).apply(resource));
                if (resource == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resource != null) {
                        try {
                            resource.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable error) {
                    return Try.ofFailure(error);
                }
            }
            resource.close();
        }
        return success;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T, A extends AutoCloseable, A1 extends AutoCloseable> Try<T> withResources(TryResourceSupplier<? extends A> resourceSupplier1, TryResourceSupplier<? extends A1> resourceSupplier2, UnChecked.CheckedBiFunction<? super A, ? super A1, ? extends T> resourceToResult) {
        try (AutoCloseable resource1 = (AutoCloseable)Objects.requireNonNull(resourceSupplier1).get();){
            Success<T> success;
            block14: {
                AutoCloseable resource2 = (AutoCloseable)Objects.requireNonNull(resourceSupplier2).get();
                try {
                    success = Try.ofSuccess(Objects.requireNonNull(resourceToResult).apply(resource1, resource2));
                    if (resource2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resource2 != null) {
                        try {
                            resource2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resource2.close();
            }
            return success;
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T, A extends AutoCloseable, A1 extends AutoCloseable> Try<T> withChainedResources(TryResourceSupplier<? extends A> resourceSupplier1, TryMapper<A, ? extends A1> resourceMapper, UnChecked.CheckedBiFunction<? super A, ? super A1, ? extends T> resourceToResult) {
        try (AutoCloseable resource1 = Objects.requireNonNull((AutoCloseable)resourceSupplier1.get());){
            Success<T> success;
            block14: {
                AutoCloseable resource2 = (AutoCloseable)Objects.requireNonNull(resourceMapper).apply(resource1);
                try {
                    success = Try.ofSuccess(Objects.requireNonNull(resourceToResult).apply(resource1, resource2));
                    if (resource2 == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resource2 != null) {
                        try {
                            resource2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resource2.close();
            }
            return success;
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public static <T> Try<T> of(TryValueSupplier<? extends T> supplier) {
        try {
            return Try.ofSuccess(Objects.requireNonNull(supplier).get());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public static <T> Try<T> ofCallable(UnChecked.CheckedCallable<? extends T> function) {
        try {
            return Try.ofSuccess(Objects.requireNonNull(function).call());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public static Try<Void> ofRunnable(UnChecked.CheckedRunnable function) {
        try {
            Objects.requireNonNull(function).run();
            return VOID;
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public static <T> Success<T> ofSuccess(T value) {
        return Success.valueOf(value);
    }

    public static <T> Failure<T> ofFailure(Throwable throwable) {
        return Failure.valueOf(throwable);
    }

    public <X extends Throwable> T orElseThrow(Function<Throwable, X> throwableSupplier) throws X {
        if (!this.isSuccess()) {
            throw (Throwable)Objects.requireNonNull(throwableSupplier).apply(this.getCause());
        }
        return this.get();
    }

    public <X extends Throwable> T orElseSneakyThrow() throws X {
        if (this.isFailure()) {
            UnChecked.sneakyThrow(this.getCause());
        }
        return this.get();
    }

    public <U extends T> T orElse(U alternative) {
        return (T)(this.isSuccess() ? this.get() : alternative);
    }

    public T orElseGet(Supplier<? extends T> alternative) {
        return this.isSuccess() ? this.get() : Objects.requireNonNull(alternative).get();
    }

    public T orElseGet(Supplier<? extends T> alternative, Consumer<? super Throwable> exceptionConsumer) {
        if (this.isFailure()) {
            Objects.requireNonNull(exceptionConsumer).accept(this.getCause());
        }
        return this.isSuccess() ? this.get() : Objects.requireNonNull(alternative).get();
    }

    public T orElseGet(Function<? super Throwable, ? extends T> exceptionMapper) {
        return this.isSuccess() ? this.get() : exceptionMapper.apply(this.getCause());
    }

    public T orElse(T alternative, Consumer<? super Throwable> exceptionConsumer) {
        if (this.isFailure()) {
            Objects.requireNonNull(exceptionConsumer).accept(this.getCause());
        }
        return this.isSuccess() ? this.get() : alternative;
    }

    public T orElseRecover(Function<? super Throwable, ? extends T> exceptionMapper) {
        return this.isSuccess() ? this.get() : Objects.requireNonNull(exceptionMapper).apply(this.getCause());
    }

    public Try<T> orElseTry(Try<? extends T> alternative) {
        return this.isSuccess() ? this : Objects.requireNonNull(alternative);
    }

    public Try<T> orElseTry(TryValueSupplier<? extends T> supplier) {
        if (this.isSuccess()) {
            return this;
        }
        try {
            return Try.ofSuccess(Objects.requireNonNull(supplier).get());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public Try<T> orElseTry(TryValueSupplier<? extends T> supplier, UnChecked.CheckedConsumer<? super Throwable> exceptionConsumer) {
        if (this.isSuccess()) {
            return this;
        }
        try {
            exceptionConsumer.accept(this.getCause());
            return Try.ofSuccess(Objects.requireNonNull(supplier).get());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public Try<T> orElseTry(TryMapper<Throwable, Try<? extends T>> excToAlternative) {
        if (this.isSuccess()) {
            return this;
        }
        try {
            return excToAlternative.apply(this.getCause());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public <U> Try<U> flatMap(TryMapper<? super T, Try<? extends U>> flatMapper) {
        Try<Try<U>> unflatMap = this.map(flatMapper);
        return unflatMap.isSuccess() ? unflatMap.get() : (Failure)unflatMap;
    }

    public <U> Try<U> map(TryMapper<? super T, ? extends U> mapper) {
        if (this.isSuccess()) {
            try {
                return Try.ofSuccess(Objects.requireNonNull(mapper).apply(this.get()));
            }
            catch (Throwable error) {
                return Try.ofFailure(error);
            }
        }
        return (Failure)this;
    }

    public Try<T> filter(UnChecked.CheckedPredicate<? super T> predicate) {
        try {
            if (this.isFailure() || this.isSuccess() && predicate.test(this.get())) {
                return this;
            }
            return Try.ofFailure(new NoSuchElementException());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public Try<T> filter(UnChecked.CheckedPredicate<? super T> predicate, Supplier<? extends Throwable> exceptionOnTestFailure) {
        try {
            if (this.isFailure() || this.isSuccess() && predicate.test(this.get())) {
                return this;
            }
            return Try.ofFailure(exceptionOnTestFailure.get());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public Try<Void> ifSuccess(TryConsumer<? super T> consumer) {
        return this.ifSuccessOrElse(consumer, xva$0 -> Try.noOp(xva$0));
    }

    public Try<Void> ifError(TryConsumer<? super Throwable> consumer) {
        return this.ifSuccessOrElse(xva$0 -> Try.noOp(xva$0), consumer);
    }

    public <X extends Throwable> Try<T> recover(Class<X> exception, TryValueSupplier<? extends T> successValGenerator) {
        if (this.isSuccess() || !Objects.requireNonNull(exception).isAssignableFrom(this.getCause().getClass())) {
            return this;
        }
        try {
            return Try.ofSuccess(Objects.requireNonNull(successValGenerator).get());
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public <X extends Throwable> Try<T> recover(Class<X> exception, Try<? extends T> successValue) {
        if (this.isSuccess() || !Objects.requireNonNull(exception).isAssignableFrom(this.getCause().getClass())) {
            return this;
        }
        return successValue;
    }

    public <X extends Throwable> Try<T> recover(Class<X> exception, UnChecked.CheckedSupplier<Try<? extends T>> successProvider) {
        if (this.isSuccess() || !Objects.requireNonNull(exception).isAssignableFrom(this.getCause().getClass())) {
            return this;
        }
        try {
            return Objects.requireNonNull(successProvider).get();
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public <X extends Throwable> Try<T> recover(Class<X> exception, TryMapper<? super Throwable, ? extends T> alternativeMapper) {
        try {
            if (this.isSuccess() || !Objects.requireNonNull(exception).isAssignableFrom(this.getCause().getClass())) {
                return this;
            }
            return Try.ofSuccess(Objects.requireNonNull(alternativeMapper).apply(this.getCause()));
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public Try<T> peekSuccess(Consumer<? super T> ifSuccess) {
        return this.peek(ifSuccess, xva$0 -> Try.noOp(xva$0));
    }

    public Try<T> peekFailure(Consumer<? super Throwable> ifError) {
        return this.peek(xva$0 -> Try.noOp(xva$0), ifError);
    }

    public <ExceptionT extends Throwable> Try<T> peekFailure(Class<ExceptionT> throwableClass, Consumer<ExceptionT> ifError) {
        return this.peek(throwableClass, xva$0 -> Try.noOp(xva$0), ifError);
    }

    public Try<T> peek(Consumer<? super T> ifSuccess, Consumer<? super Throwable> ifError) {
        return this.peek(Throwable.class, ifSuccess, ifError);
    }

    public <ExceptionT extends Throwable> Try<T> peek(Class<? extends ExceptionT> throwableClass, Consumer<? super T> ifSuccess, Consumer<? super ExceptionT> ifError) {
        if (this.isSuccess()) {
            Objects.requireNonNull(ifSuccess).accept(this.get());
        } else if (Objects.requireNonNull(throwableClass).isAssignableFrom(this.getCause().getClass())) {
            Objects.requireNonNull(ifError).accept(this.getCause());
        }
        return this;
    }

    public <U> Try<U> mapOrElse(TryMapper<? super T, ? extends U> ifSuccess, TryMapper<? super Throwable, ? extends U> orElse) {
        try {
            if (this.isSuccess()) {
                return Try.ofSuccess(Objects.requireNonNull(ifSuccess).apply(this.get()));
            }
            return Try.ofSuccess(Objects.requireNonNull(orElse).apply(this.getCause()));
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public Try<Void> ifSuccessOrElse(TryConsumer<? super T> successConsumer, TryConsumer<? super Throwable> failureConsumer) {
        try {
            if (this.isSuccess()) {
                Objects.requireNonNull(successConsumer).accept(this.get());
            } else {
                Objects.requireNonNull(failureConsumer).accept(this.getCause());
            }
            return VOID;
        }
        catch (Throwable error) {
            return Try.ofFailure(error);
        }
    }

    public static interface TryResourceSupplier<T>
    extends UnChecked.CheckedSupplier<T> {
        @Override
        public T get() throws Throwable;
    }

    public static interface TryMapper<T, R>
    extends UnChecked.CheckedFunction<T, R> {
        @Override
        public R apply(T var1) throws Throwable;
    }

    public static final class Success<T>
    extends Try<T> {
        private final T successValue;

        private Success() {
            throw new IllegalStateException("Illegal " + this.getClass().getSimpleName() + " Object State");
        }

        private Success(T successValue) {
            this.successValue = successValue;
        }

        public static <T> Success<T> valueOf(T successValue) {
            return new Success<T>(successValue);
        }

        @Override
        public T get() {
            return this.successValue;
        }

        @Override
        public boolean isSuccess() {
            return true;
        }

        @Override
        public Throwable getCause() {
            throw SUCCESS_UNSUPPORTED_OPERATION_EXCEPTION;
        }
    }

    public static final class Failure<T>
    extends Try<T> {
        private final Throwable failureValue;

        private Failure() {
            throw new IllegalStateException("Illegal " + this.getClass().getSimpleName() + " Object State");
        }

        private Failure(Throwable failureValue) {
            this.failureValue = failureValue;
        }

        public static <T> Failure<T> valueOf(Throwable failureValue) {
            return new Failure<T>(Objects.requireNonNull(failureValue));
        }

        @Override
        public T get() {
            throw FAILURE_UNSUPPORTED_OPERATION_EXCEPTION;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public Throwable getCause() {
            return this.failureValue;
        }
    }

    public static interface TryValueSupplier<T>
    extends UnChecked.CheckedSupplier<T> {
        @Override
        public T get() throws Throwable;
    }

    public static interface TryConsumer<T>
    extends UnChecked.CheckedConsumer<T> {
        @Override
        public void accept(T var1) throws Throwable;
    }
}

