/*
 * Decompiled with CFR 0.152.
 */
package io.reacted.patterns;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class ObjectUtils {
    @Nullable
    public static final Void VOID = null;

    private ObjectUtils() {
    }

    @Nullable
    public static <InputT, OutputT> OutputT ifNotNull(@Nullable InputT input, Function<InputT, OutputT> ifNotNull) {
        if (input == null) {
            return null;
        }
        return Objects.requireNonNull(ifNotNull).apply(input);
    }

    public static <InputT> void runIfNotNull(@Nullable InputT input, Consumer<InputT> ifNotNull) {
        if (input != null) {
            Objects.requireNonNull(ifNotNull).accept(input);
        }
    }

    public static Duration checkNonNullPositiveTimeIntervalWithLimit(@Nullable Duration interval, long limitAmount, TimeUnit limitUnit) {
        return ObjectUtils.requiredCondition(ObjectUtils.checkNonNullPositiveTimeInterval(interval), positiveInterval -> positiveInterval.compareTo(Duration.of(limitAmount, limitUnit.toChronoUnit())) <= 0, () -> new IllegalArgumentException("Provided interval is not within upperbound limit"));
    }

    public static Duration checkNonNullPositiveTimeInterval(@Nullable Duration interval) {
        return ObjectUtils.requiredCondition(Objects.requireNonNull(interval, "Interval cannot be null"), nonNullInterval -> nonNullInterval.compareTo(Duration.ZERO) > 0, () -> new IllegalArgumentException("Provided interval is not positive"));
    }

    public static <ElementT extends Comparable<ElementT>, ExceptionT extends RuntimeException> ElementT requiredInRange(ElementT element, ElementT inclusiveRangeStart, ElementT inclusiveRangeEnd, Supplier<ExceptionT> onError) {
        if (Objects.requireNonNull(inclusiveRangeEnd).compareTo(Objects.requireNonNull(inclusiveRangeStart)) >= 0 && Objects.requireNonNull(element).compareTo(inclusiveRangeStart) >= 0 && element.compareTo(inclusiveRangeEnd) <= 0) {
            return element;
        }
        throw (RuntimeException)onError.get();
    }

    public static <ReturnT, OnErrorT extends RuntimeException> ReturnT requiredCondition(ReturnT element, Predicate<ReturnT> controlPredicate, Supplier<OnErrorT> onControlPredicateFailure) {
        if (Objects.requireNonNull(controlPredicate).negate().test(Objects.requireNonNull(element))) {
            throw (RuntimeException)Objects.requireNonNull(onControlPredicateFailure).get();
        }
        return element;
    }

    public static byte[] toBytes(Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "");
        return byteArrayOutputStream.toByteArray();
    }

    public static Properties fromBytes(byte[] data) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data);
        Properties properties = new Properties();
        properties.load(byteArrayInputStream);
        return properties;
    }
}

