/*
 * Decompiled with CFR 0.152.
 */
package io.reacted.patterns;

import io.reacted.patterns.Try;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public final class UnChecked {
    private UnChecked() {
    }

    public static <T> Supplier<T> supplier(CheckedSupplier<T> checkedSupplier) {
        return UnChecked.unchecker(checkedSupplier);
    }

    public static <T> Consumer<T> consumer(CheckedConsumer<T> checkedConsumer) {
        return arg -> UnChecked.unchecker(() -> {
            checkedConsumer.accept(arg);
            return Try.VOID;
        });
    }

    public static <T, U, D> TriConsumer<T, U, D> triConsumer(CheckedTriConsumer<T, U, D> checkedTriConsumer) {
        return (arg1, arg2, arg3) -> UnChecked.unchecker(() -> {
            checkedTriConsumer.accept(arg1, arg2, arg3);
            return Try.VOID;
        }).get();
    }

    public static <T, U> BiConsumer<T, U> biConsumer(CheckedBiConsumer<T, U> checkedBiConsumer) {
        return (arg1, arg2) -> UnChecked.unchecker(() -> {
            checkedBiConsumer.accept(arg1, arg2);
            return Try.VOID;
        }).get();
    }

    public static <T, R> Function<T, R> function(CheckedFunction<T, R> checkedFunction) {
        return arg -> UnChecked.unchecker(() -> checkedFunction.apply(arg)).get();
    }

    public static <T, U, R> BiFunction<T, U, R> biFunction(CheckedBiFunction<T, U, R> checkedBifunction) {
        return (arg1, arg2) -> UnChecked.unchecker(() -> checkedBifunction.apply(arg1, arg2)).get();
    }

    public static <T> UnaryOperator<T> unaryOperator(CheckedUnaryOperator<T> checkedUnaryOperator) {
        return arg1 -> UnChecked.unchecker(() -> checkedUnaryOperator.apply(arg1)).get();
    }

    public static <T> BinaryOperator<T> binaryOperator(CheckedBinaryOperator<T> checkedBinaryOperator) {
        return (arg1, arg2) -> UnChecked.unchecker(() -> checkedBinaryOperator.apply(arg1, arg2)).get();
    }

    public static <T> Predicate<T> predicate(CheckedPredicate<T> checkedPredicate) {
        return arg -> UnChecked.unchecker(() -> checkedPredicate.test(arg)).get();
    }

    private static <T> Supplier<T> unchecker(CheckedSupplier<T> resultSupplier) {
        return () -> Try.of(resultSupplier::get).orElseRecover(UnChecked::sneakyThrow);
    }

    public static <T extends Throwable, U> U sneakyThrow(Throwable t) throws T {
        throw t;
    }

    @FunctionalInterface
    public static interface CheckedSupplier<T> {
        public T get() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedTriConsumer<T, U, D> {
        public void accept(T var1, U var2, D var3) throws Throwable;
    }

    @FunctionalInterface
    public static interface TriConsumer<T, U, D> {
        public void accept(T var1, U var2, D var3);
    }

    @FunctionalInterface
    public static interface CheckedBiConsumer<T, U> {
        public void accept(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, U> {
        public U apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedBiFunction<T, U, R> {
        public R apply(T var1, U var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedUnaryOperator<T>
    extends CheckedFunction<T, T> {
        public static <T> CheckedUnaryOperator<T> identity() {
            return t -> t;
        }
    }

    @FunctionalInterface
    public static interface CheckedBinaryOperator<T>
    extends CheckedBiFunction<T, T, T> {
    }

    @FunctionalInterface
    public static interface CheckedPredicate<T> {
        public boolean test(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedCallable<T> {
        public T call() throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Throwable;
    }
}

