/*
 * Decompiled with CFR 0.152.
 */
package io.reacted.patterns;

import io.reacted.patterns.NonNullByDefault;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@NonNullByDefault
@Immutable
public final class AsyncUtils {
    private AsyncUtils() {
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, @Nullable PayloadT onErrorAlternative, long iterations) {
        return AsyncUtils.asyncLoop(operation, firstArgument, iterations, (Throwable error) -> onErrorAlternative, (Executor)ForkJoinPool.commonPool());
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, Function<Throwable, PayloadT> onError, long iterations) {
        return AsyncUtils.asyncLoop(operation, firstArgument, iterations, onError, (Executor)ForkJoinPool.commonPool());
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, @Nullable PayloadT onErrorAlternative, long iterations, Executor asyncExecutor) {
        return AsyncUtils.asyncLoop(operation, firstArgument, iterations, (Throwable error) -> onErrorAlternative, asyncExecutor);
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, long iterations, Function<Throwable, PayloadT> onError, Executor asyncExecutor) {
        if (iterations <= 0L) {
            throw new IllegalArgumentException("Iterations must be positive. Provided [" + iterations + "]");
        }
        AtomicLong counter = new AtomicLong(0L);
        return AsyncUtils.asyncLoop(operation, firstArgument, input -> counter.getAndIncrement() < iterations, onError, asyncExecutor);
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, Predicate<PayloadT> shallContinue, Function<Throwable, PayloadT> onError, Executor asyncExecutor) {
        CompletableFuture finalTrigger = new CompletableFuture();
        asyncExecutor.execute(() -> AsyncUtils.asyncMainLoop(operation, firstArgument, shallContinue, finalTrigger, onError, asyncExecutor));
        return finalTrigger;
    }

    private static <PayloadT> CompletionStage<PayloadT> asyncMainLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, Predicate<PayloadT> shallContinue, CompletionStage<PayloadT> finalTrigger, Function<Throwable, PayloadT> onError, Executor executorService) {
        if (shallContinue.test(firstArgument)) {
            return operation.apply(firstArgument).exceptionally(onError).thenComposeAsync(result -> AsyncUtils.asyncMainLoop(operation, result, shallContinue, finalTrigger, onError, executorService), executorService);
        }
        finalTrigger.toCompletableFuture().complete(firstArgument);
        return finalTrigger;
    }
}

