/*
 * Decompiled with CFR 0.152.
 */
package io.reacted.patterns;

import io.reacted.patterns.NonNullByDefault;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@NonNullByDefault
@Immutable
public final class AsyncUtils {
    private AsyncUtils() {
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, @Nullable PayloadT onErrorAlternative, long iterations) {
        return AsyncUtils.asyncLoop(operation, firstArgument, iterations, error -> CompletableFuture.completedFuture(onErrorAlternative), (Executor)ForkJoinPool.commonPool());
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, Function<Throwable, CompletionStage<PayloadT>> onError, long iterations) {
        return AsyncUtils.asyncLoop(operation, firstArgument, iterations, onError, (Executor)ForkJoinPool.commonPool());
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, @Nullable PayloadT onErrorAlternative, long iterations, Executor asyncExecutor) {
        return AsyncUtils.asyncLoop(operation, firstArgument, iterations, error -> CompletableFuture.completedFuture(onErrorAlternative), asyncExecutor);
    }

    public static <PayloadT> CompletionStage<PayloadT> asyncLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, long iterations, Function<Throwable, CompletionStage<PayloadT>> onError, Executor asyncExecutor) {
        if (iterations <= 0L) {
            throw new IllegalArgumentException("Iterations must be positive. Provided [" + iterations + "]");
        }
        CompletableFuture finalTrigger = new CompletableFuture();
        asyncExecutor.execute(() -> AsyncUtils.asyncMainLoop(operation, firstArgument, iterations, finalTrigger, onError, asyncExecutor));
        return finalTrigger;
    }

    private static <PayloadT> CompletionStage<PayloadT> asyncMainLoop(Function<PayloadT, CompletionStage<PayloadT>> operation, @Nullable PayloadT firstArgument, long iterations, CompletionStage<PayloadT> finalTrigger, Function<Throwable, CompletionStage<PayloadT>> onError, Executor executorService) {
        return operation.apply(firstArgument).exceptionallyComposeAsync(onError, executorService).thenComposeAsync(result -> {
            long leftIterations = iterations - 1L;
            if (leftIterations > 0L) {
                return AsyncUtils.asyncMainLoop(operation, result, leftIterations, finalTrigger, onError, executorService);
            }
            finalTrigger.toCompletableFuture().complete(result);
            return finalTrigger;
        }, executorService);
    }
}

