/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.master.context;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Sets;
import io.ray.streaming.jobgraph.JobGraph;
import io.ray.streaming.runtime.config.StreamingConfig;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionGraph;
import io.ray.streaming.runtime.master.coordinator.command.BaseWorkerCmd;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class JobMasterRuntimeContext
implements Serializable {
    public volatile List<Long> checkpointIds = new ArrayList<Long>();
    public volatile long lastCheckpointId = 0L;
    public volatile long lastCpTimestamp = 0L;
    public volatile BlockingQueue<BaseWorkerCmd> cpCmds = new LinkedBlockingQueue<BaseWorkerCmd>();
    public volatile BlockingQueue<BaseWorkerCmd> foCmds = new ArrayBlockingQueue<BaseWorkerCmd>(8192);
    public volatile Set<BaseWorkerCmd> unfinishedFoCmds = Sets.newConcurrentHashSet();
    private StreamingConfig conf;
    private JobGraph jobGraph;
    private volatile ExecutionGraph executionGraph;

    public JobMasterRuntimeContext(StreamingConfig conf) {
        this.conf = conf;
    }

    public String getJobName() {
        return this.conf.masterConfig.commonConfig.jobName();
    }

    public StreamingConfig getConf() {
        return this.conf;
    }

    public JobGraph getJobGraph() {
        return this.jobGraph;
    }

    public void setJobGraph(JobGraph jobGraph) {
        this.jobGraph = jobGraph;
    }

    public ExecutionGraph getExecutionGraph() {
        return this.executionGraph;
    }

    public void setExecutionGraph(ExecutionGraph executionGraph) {
        this.executionGraph = executionGraph;
    }

    public Long getLastValidCheckpointId() {
        if (this.checkpointIds.isEmpty()) {
            return 0L;
        }
        return this.checkpointIds.get(this.checkpointIds.size() - 1);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("jobGraph", (Object)this.jobGraph).add("executionGraph", (Object)this.executionGraph).add("conf", this.conf.getMap()).toString();
    }
}

