/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.core.graph.executiongraph;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.ray.api.BaseActorHandle;
import io.ray.streaming.api.Language;
import io.ray.streaming.jobgraph.JobVertex;
import io.ray.streaming.jobgraph.VertexType;
import io.ray.streaming.operator.StreamOperator;
import io.ray.streaming.runtime.config.master.ResourceConfig;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionJobEdge;
import io.ray.streaming.runtime.core.graph.executiongraph.ExecutionVertex;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.aeonbits.owner.ConfigFactory;

public class ExecutionJobVertex
implements Serializable {
    private final int executionJobVertexId;
    private final String executionJobVertexName;
    private final StreamOperator streamOperator;
    private final VertexType vertexType;
    private final Language language;
    private final Map<String, String> jobConfig;
    private final long buildTime;
    private int parallelism;
    private List<ExecutionVertex> executionVertices;
    private List<ExecutionJobEdge> inputEdges = new ArrayList<ExecutionJobEdge>();
    private List<ExecutionJobEdge> outputEdges = new ArrayList<ExecutionJobEdge>();

    public ExecutionJobVertex(JobVertex jobVertex, Map<String, String> jobConfig, AtomicInteger idGenerator, long buildTime) {
        this.executionJobVertexId = jobVertex.getVertexId();
        this.executionJobVertexName = this.generateExecutionJobVertexName(this.executionJobVertexId, jobVertex.getStreamOperator().getName());
        this.streamOperator = jobVertex.getStreamOperator();
        this.vertexType = jobVertex.getVertexType();
        this.language = jobVertex.getLanguage();
        this.jobConfig = jobConfig;
        this.buildTime = buildTime;
        this.parallelism = jobVertex.getParallelism();
        this.executionVertices = this.createExecutionVertices(idGenerator);
    }

    private List<ExecutionVertex> createExecutionVertices(AtomicInteger idGenerator) {
        ArrayList<ExecutionVertex> executionVertices = new ArrayList<ExecutionVertex>();
        ResourceConfig resourceConfig = (ResourceConfig)ConfigFactory.create(ResourceConfig.class, (Map[])new Map[]{this.jobConfig});
        for (int subIndex = 0; subIndex < this.parallelism; ++subIndex) {
            executionVertices.add(new ExecutionVertex(idGenerator.getAndIncrement(), subIndex, this, resourceConfig));
        }
        return executionVertices;
    }

    private String generateExecutionJobVertexName(int jobVertexId, String streamOperatorName) {
        return jobVertexId + "-" + streamOperatorName;
    }

    public Map<Integer, BaseActorHandle> getExecutionVertexWorkers() {
        HashMap<Integer, BaseActorHandle> executionVertexWorkersMap = new HashMap<Integer, BaseActorHandle>();
        Preconditions.checkArgument((this.executionVertices != null && !this.executionVertices.isEmpty() ? 1 : 0) != 0, (Object)"Empty execution vertex.");
        this.executionVertices.stream().forEach(vertex -> {
            Preconditions.checkArgument((vertex.getWorkerActor() != null ? 1 : 0) != 0, (Object)"Empty execution vertex worker actor.");
            executionVertexWorkersMap.put(vertex.getExecutionVertexId(), vertex.getWorkerActor());
        });
        return executionVertexWorkersMap;
    }

    public int getExecutionJobVertexId() {
        return this.executionJobVertexId;
    }

    public String getExecutionJobVertexName() {
        return this.executionJobVertexName;
    }

    public String getExecutionJobVertexNameWithIndex() {
        return this.executionJobVertexId + "-" + this.executionJobVertexName;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public List<ExecutionVertex> getExecutionVertices() {
        return this.executionVertices;
    }

    public void setExecutionVertices(List<ExecutionVertex> executionVertex) {
        this.executionVertices = executionVertex;
    }

    public List<ExecutionJobEdge> getOutputEdges() {
        return this.outputEdges;
    }

    public void setOutputEdges(List<ExecutionJobEdge> outputEdges) {
        this.outputEdges = outputEdges;
    }

    public List<ExecutionJobEdge> getInputEdges() {
        return this.inputEdges;
    }

    public void setInputEdges(List<ExecutionJobEdge> inputEdges) {
        this.inputEdges = inputEdges;
    }

    public StreamOperator getStreamOperator() {
        return this.streamOperator;
    }

    public VertexType getVertexType() {
        return this.vertexType;
    }

    public Language getLanguage() {
        return this.language;
    }

    public Map<String, String> getJobConfig() {
        return this.jobConfig;
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public boolean isSourceVertex() {
        return this.getVertexType() == VertexType.SOURCE;
    }

    public boolean isTransformationVertex() {
        return this.getVertexType() == VertexType.TRANSFORMATION;
    }

    public boolean isSinkVertex() {
        return this.getVertexType() == VertexType.SINK;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("executionJobVertexId", this.executionJobVertexId).add("executionJobVertexName", (Object)this.executionJobVertexName).add("vertexType", (Object)this.vertexType).add("parallelism", this.parallelism).toString();
    }
}

