/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.util;

import io.ray.api.Ray;
import io.ray.api.id.UniqueId;
import io.ray.api.runtimecontext.NodeInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RayUtils {
    public static List<NodeInfo> getAllNodeInfo() {
        if (Ray.getRuntimeContext().isSingleProcess()) {
            return RayUtils.mockContainerResources();
        }
        return Ray.getRuntimeContext().getAllNodeInfo();
    }

    public static Map<UniqueId, NodeInfo> getAliveNodeInfoMap() {
        return RayUtils.getAllNodeInfo().stream().filter(nodeInfo -> nodeInfo.isAlive).collect(Collectors.toMap(nodeInfo -> nodeInfo.nodeId, nodeInfo -> nodeInfo));
    }

    private static List<NodeInfo> mockContainerResources() {
        LinkedList<NodeInfo> nodeInfos = new LinkedList<NodeInfo>();
        for (int i = 1; i <= 5; ++i) {
            HashMap<String, Double> resources = new HashMap<String, Double>();
            resources.put("CPU", Double.valueOf(i));
            resources.put("MEM", 16.0);
            byte[] nodeIdBytes = new byte[28];
            for (int byteIndex = 0; byteIndex < 28; ++byteIndex) {
                nodeIdBytes[byteIndex] = String.valueOf(i).getBytes()[0];
            }
            NodeInfo nodeInfo = new NodeInfo(new UniqueId(nodeIdBytes), "localhost" + i, "localhost" + i, -1, "", "", true, resources);
            nodeInfos.add(nodeInfo);
        }
        return nodeInfos;
    }
}

