/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.util;

import com.sun.management.OperatingSystemMXBean;
import io.ray.streaming.runtime.core.resource.Container;
import io.ray.streaming.runtime.core.resource.ContainerId;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtil {
    public static final Logger LOG = LoggerFactory.getLogger(ResourceUtil.class);
    private static OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public static void logProcessMemoryDetail() {
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder(32);
        sb.append("used memory: ").append((runtime.totalMemory() - runtime.freeMemory()) / (long)mb).append(", free memory: ").append(runtime.freeMemory() / (long)mb).append(", total memory: ").append(runtime.totalMemory() / (long)mb).append(", max memory: ").append(runtime.maxMemory() / (long)mb);
        if (LOG.isInfoEnabled()) {
            LOG.info(sb.toString());
        }
    }

    public static double getJvmHeapUsageRatio() {
        Runtime runtime = Runtime.getRuntime();
        return (double)(runtime.totalMemory() - runtime.freeMemory()) * 1.0 / (double)runtime.maxMemory();
    }

    public static long getJvmHeapUsageInBytes() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static long getSystemTotalMemory() {
        return osmxb.getTotalPhysicalMemorySize();
    }

    public static long getSystemMemoryUsage() {
        long totalMemory = osmxb.getTotalPhysicalMemorySize();
        long freeMemory = osmxb.getFreePhysicalMemorySize();
        return totalMemory - freeMemory;
    }

    public static double getSystemMemoryUsageRatio() {
        double totalMemory = osmxb.getTotalPhysicalMemorySize();
        double freeMemory = osmxb.getFreePhysicalMemorySize();
        double ratio = freeMemory / totalMemory;
        return 1.0 - ratio;
    }

    public static double getProcessCpuUsage() {
        return osmxb.getProcessCpuLoad();
    }

    public static double getSystemCpuUsage() {
        double cpuUsage = 0.0;
        try {
            cpuUsage = ResourceUtil.getSystemCpuUtilByVsar();
        }
        catch (Exception e) {
            cpuUsage = ResourceUtil.getSystemCpuUtilByMXBean();
        }
        return cpuUsage;
    }

    public static double getSystemCpuUtilByMXBean() {
        return osmxb.getSystemCpuLoad();
    }

    public static double getSystemCpuUtilByVsar() throws Exception {
        double cpuUsageFromVsar = 0.0;
        String[] vsarCpuCommand = new String[]{"/bin/sh", "-c", "vsar --check --cpu -s util"};
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(vsarCpuCommand);
            BufferedInputStream bis = new BufferedInputStream(proc.getInputStream());
            BufferedReader br = new BufferedReader(new InputStreamReader(bis));
            ArrayList<String> processPidList = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                processPidList.add(line);
            }
            if (processPidList.isEmpty()) {
                throw new IOException("Vsar check cpu usage failed, maybe vsar is not installed.");
            }
            String[] split = ((String)processPidList.get(0)).split("=");
            cpuUsageFromVsar = Double.parseDouble(split[1]) / 100.0;
        }
        catch (Exception e) {
            LOG.warn("Failed to get cpu usage by vsar.", (Throwable)e);
            throw e;
        }
        return cpuUsageFromVsar;
    }

    public static double getSystemLoadAverage() {
        return osmxb.getSystemLoadAverage();
    }

    public static int getCpuCores() {
        return osmxb.getAvailableProcessors();
    }

    public static List<Container> getContainersByHostname(List<Container> containers, Collection<String> containerHosts) {
        return containers.stream().filter(container -> containerHosts.contains(container.getHostname()) || containerHosts.contains(container.getAddress())).collect(Collectors.toList());
    }

    public static Optional<Container> getContainerByHostname(List<Container> containers, String hostName) {
        return containers.stream().filter(container -> container.getHostname().equals(hostName) || container.getAddress().equals(hostName)).findFirst();
    }

    public static Optional<Container> getContainerById(List<Container> containers, ContainerId containerID) {
        return containers.stream().filter(container -> container.getId().equals(containerID)).findFirst();
    }
}

