/*
 * Decompiled with CFR 0.152.
 */
package io.ray.streaming.runtime.transfer.channel;

import io.ray.streaming.runtime.config.StreamingWorkerConfig;
import io.ray.streaming.runtime.generated.Streaming;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelUtils.class);

    public static byte[] toNativeConf(StreamingWorkerConfig workerConfig) {
        int readerConsumedStep;
        int writerConsumedStep;
        int flowControlType;
        int emptyMsgInterval;
        int ringBufferCapacity;
        String operatorName;
        String workerName;
        Streaming.StreamingConfig.Builder builder = Streaming.StreamingConfig.newBuilder();
        String jobName = workerConfig.commonConfig.jobName();
        if (!StringUtils.isEmpty((CharSequence)jobName)) {
            builder.setJobName(workerConfig.commonConfig.jobName());
        }
        if (!StringUtils.isEmpty((CharSequence)(workerName = workerConfig.workerInternalConfig.workerName()))) {
            builder.setWorkerName(workerName);
        }
        if (!StringUtils.isEmpty((CharSequence)(operatorName = workerConfig.workerInternalConfig.workerOperatorName()))) {
            builder.setOpName(operatorName);
        }
        if ((ringBufferCapacity = workerConfig.transferConfig.ringBufferCapacity()) != -1) {
            builder.setRingBufferCapacity(ringBufferCapacity);
        }
        if ((emptyMsgInterval = workerConfig.transferConfig.emptyMsgInterval()) != -1) {
            builder.setEmptyMessageInterval(emptyMsgInterval);
        }
        if ((flowControlType = workerConfig.transferConfig.flowControlType()) != -1) {
            builder.setFlowControlType(Streaming.FlowControlType.forNumber(flowControlType));
        }
        if ((writerConsumedStep = workerConfig.transferConfig.writerConsumedStep()) != -1) {
            builder.setWriterConsumedStep(writerConsumedStep);
        }
        if ((readerConsumedStep = workerConfig.transferConfig.readerConsumedStep()) != -1) {
            builder.setReaderConsumedStep(readerConsumedStep);
        }
        Streaming.StreamingConfig streamingConf = builder.build();
        LOGGER.info("Streaming native conf {}", (Object)streamingConf.toString());
        return streamingConf.toByteArray();
    }
}

